/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts.instance;

import com.onewhohears.dscombat.common.container.StorageBoxContainer;
import com.onewhohears.dscombat.common.container.menu.StorageBoxContainerMenu;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.stats.StorageStats;
import com.onewhohears.dscombat.init.ModContainers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;

public class StorageInstance<T extends StorageStats>
extends PartInstance<T> {
    private final StorageBoxContainer container = new StorageBoxContainer(this);

    public StorageInstance(T stats) {
        super(stats);
    }

    public StorageBoxContainerMenu createMenu(int id, Inventory playerInventory) {
        int rows = this.getRowCount();
        return new StorageBoxContainerMenu(StorageInstance.getStorageMenuTypeByRows(rows), id, playerInventory, (Container)this.container, rows);
    }

    public static MenuType<?> getStorageMenuTypeByRows(int rows) {
        if (rows <= 0) {
            return (MenuType)ModContainers.VEHICLE_STORAGE_MENU_9x0.get();
        }
        if (rows == 1) {
            return (MenuType)ModContainers.VEHICLE_STORAGE_MENU_9x1.get();
        }
        if (rows == 2) {
            return (MenuType)ModContainers.VEHICLE_STORAGE_MENU_9x2.get();
        }
        if (rows == 3) {
            return (MenuType)ModContainers.VEHICLE_STORAGE_MENU_9x3.get();
        }
        if (rows == 4) {
            return (MenuType)ModContainers.VEHICLE_STORAGE_MENU_9x4.get();
        }
        if (rows == 5) {
            return (MenuType)ModContainers.VEHICLE_STORAGE_MENU_9x5.get();
        }
        return (MenuType)ModContainers.VEHICLE_STORAGE_MENU_9x6.get();
    }

    public static StorageBoxContainerMenu getEmptyStorageMenu(int id, Inventory playerInventory) {
        return new StorageBoxContainerMenu(StorageInstance.getStorageMenuTypeByRows(0), id, playerInventory, (Container)new SimpleContainer(0), 0);
    }

    public int getRowCount() {
        return (int)Math.ceil((double)this.container.m_6643_() / 9.0);
    }

    @Override
    public void readNBT(CompoundTag tag) {
        super.readNBT(tag);
        this.container.m_7797_(tag.m_128437_("items", 10));
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag tag = super.writeNBT();
        tag.m_128365_("items", (Tag)this.container.m_7927_());
        return tag;
    }

    public StorageBoxContainer getItems() {
        return this.container;
    }
}

