/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.radar;

import com.onewhohears.dscombat.DependencySafety;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.common.network.VehicleSyncAction;
import com.onewhohears.dscombat.common.network.toclient.ToClientRWRWarning;
import com.onewhohears.dscombat.common.network.toclient.ToClientRadarPings;
import com.onewhohears.dscombat.data.radar.RadarInstance;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.data.radar.TrackableEntitiesManager;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.weapon.EntityMissile;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.onewholibs.util.UtilEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadarSystem {
    private final EntityVehicle parent;
    private boolean readData = false;
    private final List<RadarInstance<?>> radars = new ArrayList();
    private final List<EntityMissile<?>> rockets = new ArrayList();
    private final List<RadarStats.RadarPing> targets = new ArrayList<RadarStats.RadarPing>();
    private int selectedIndex = -1;
    private List<RadarStats.RadarPing> clientTargets = new ArrayList<RadarStats.RadarPing>();
    private int clientSelectedIndex = -1;
    private int clientSelectedTime = -21;
    public int clientPingRefreshTime = 0;
    public int clientRwrRefreshTime = 0;
    private final List<RadarStats.RadarPing> dataLinkBuffer = new ArrayList<RadarStats.RadarPing>();
    private final Map<Integer, RWRWarning> rwrWarnings = new HashMap<Integer, RWRWarning>();
    private boolean rwrMissile;
    private boolean rwrRadar;
    public boolean dataLink = false;

    public RadarSystem(EntityVehicle parent) {
        this.parent = parent;
    }

    public List<RadarInstance<?>> getRadars() {
        return this.radars;
    }

    public boolean hasDataLink() {
        return this.dataLink || this.parent.getWorld().m_46469_().m_46207_(DSCGameRules.DATA_LINK_ALWAYS_ON);
    }

    public void tick() {
        if (this.parent.isClientSide()) {
            this.clientTick();
        } else if (this.canServerTick()) {
            this.serverTick();
        }
    }

    public boolean canServerTick() {
        return this.parent.isOperational() && (this.parent.isStationaryRadar() || this.parent.isPlayerRiding() || this.parent.getWorld().m_46469_().m_46207_(DSCGameRules.MOBS_TICK_RADAR) && this.parent.isBotUsingRadar());
    }

    public void tickUpdateTargets() {
        RadarStats.RadarPing old = null;
        if (this.selectedIndex != -1 && this.selectedIndex < this.targets.size()) {
            old = this.targets.get(this.selectedIndex);
        }
        this.selectedIndex = -1;
        for (RadarInstance<?> r : this.radars) {
            r.tickUpdateTargets(this.parent, this.targets);
        }
        if (this.parent.f_19797_ % 20 == 0) {
            this.updateDataLink();
        }
        if (old != null) {
            for (int i = 0; i < this.targets.size(); ++i) {
                if (this.targets.get((int)i).id != old.id) continue;
                this.selectedIndex = i;
                Entity entity = this.getSelectedTarget();
                if (!(entity instanceof EntityVehicle)) break;
                EntityVehicle plane = (EntityVehicle)entity;
                plane.lockedOnto((Entity)this.parent);
                break;
            }
        }
        this.updateSemiActiveTrackMissiles();
        if (this.parent.f_19797_ % 20 == 0) {
            if (this.parent.isStationaryRadar()) {
                this.parent.toTrackers(new ToClientRadarPings(this.parent.m_19879_(), this.targets));
            } else {
                this.parent.toClientPassengers(new ToClientRadarPings(this.parent.m_19879_(), this.targets));
            }
        }
    }

    protected void updateVisibility() {
        if (this.parent.getWorld().m_5776_()) {
            return;
        }
        if (!this.parent.isPlayerRiding()) {
            TrackableEntitiesManager.addTrackableEntity((Entity)this.parent);
            DependencySafety.addExtraEntityToRDP(Objects.requireNonNull(this.parent.m_20194_()), (Entity)this.parent, new ServerPlayer[0]);
        } else {
            TrackableEntitiesManager.removeTrackableEntity((Entity)this.parent);
        }
    }

    public void onParentRemove() {
        if (this.parent.getWorld().m_5776_()) {
            return;
        }
        TrackableEntitiesManager.removeTrackableEntity((Entity)this.parent);
    }

    protected void updateDataLink() {
        if (this.parent.getWorld().m_5776_()) {
            return;
        }
        this.refreshDataLink();
        if (!this.hasDataLink()) {
            return;
        }
        Entity controller = this.parent.getControllingPlayerOrBot();
        boolean check_equals = true;
        if (this.parent.isStationaryRadar() && controller == null) {
            controller = this.parent.getOwner();
            check_equals = false;
        }
        if (controller == null) {
            return;
        }
        ServerPlayer playerController = null;
        if (controller instanceof ServerPlayer) {
            ServerPlayer sp;
            playerController = sp = (ServerPlayer)controller;
        }
        List players = this.parent.getWorld().m_6907_();
        for (Player p : players) {
            Object object;
            if (check_equals && controller.equals((Object)p) || (playerController == null ? !controller.m_7307_((Entity)p) : !UtilEntity.arePlayersAllied((ServerPlayer)playerController, (ServerPlayer)((ServerPlayer)p)))) continue;
            if (!UtilEntity.getLevel((Entity)controller).m_46472_().equals(UtilEntity.getLevel((Entity)p).m_46472_()) || !((object = p.m_20201_()) instanceof EntityVehicle)) continue;
            EntityVehicle plane = (EntityVehicle)object;
            if (!plane.radarSystem.hasDataLink() || plane.equals(this.parent)) continue;
            object = this.targets.iterator();
            while (object.hasNext()) {
                RadarStats.RadarPing rp = (RadarStats.RadarPing)object.next();
                if (rp.id == plane.m_19879_() || rp.isShared() || plane.radarSystem.hasDataLinkBuffer(rp.id)) continue;
                plane.radarSystem.dataLinkBuffer.add(rp.getCopy(true));
            }
        }
    }

    public int getClientPingIndexByEntityId(int id) {
        for (int i = 0; i < this.clientTargets.size(); ++i) {
            if (this.clientTargets.get((int)i).id != id) continue;
            return i;
        }
        return -1;
    }

    public boolean hasTargets() {
        return !this.targets.isEmpty();
    }

    public boolean hasTarget(Entity entity) {
        Entity v;
        if (this.hasTarget(entity.m_19879_())) {
            return true;
        }
        return entity.m_20159_() && this.hasTarget((v = entity.m_20201_()).m_19879_());
    }

    public boolean hasTarget(int id) {
        for (RadarStats.RadarPing rp : this.targets) {
            if (rp.id != id) continue;
            return true;
        }
        return false;
    }

    private boolean hasDataLinkBuffer(int id) {
        for (RadarStats.RadarPing rp : this.dataLinkBuffer) {
            if (rp.id != id) continue;
            return true;
        }
        return false;
    }

    private void refreshDataLink() {
        int i;
        for (i = 0; i < this.targets.size(); ++i) {
            if (!this.targets.get(i).isShared()) continue;
            this.targets.remove(i--);
        }
        for (i = 0; i < this.dataLinkBuffer.size(); ++i) {
            if (this.hasTarget(this.dataLinkBuffer.get((int)i).id)) continue;
            this.targets.add(this.dataLinkBuffer.get(i));
        }
        this.dataLinkBuffer.clear();
    }

    private void updateSemiActiveTrackMissiles() {
        for (int i = 0; i < this.rockets.size(); ++i) {
            EntityMissile<?> r = this.rockets.get(i);
            if (r.m_213877_()) {
                this.rockets.remove(i--);
                continue;
            }
            boolean b = false;
            for (int j = 0; j < this.targets.size(); ++j) {
                if (this.targets.get((int)j).id != r.target.m_19879_()) continue;
                r.targetPos = this.targets.get((int)j).pos;
                b = true;
                break;
            }
            if (b) continue;
            this.rockets.remove(i--);
            r.m_6074_();
        }
    }

    public void addRocket(EntityMissile<?> r) {
        if (!this.rockets.contains(r)) {
            this.rockets.add(r);
        }
    }

    public void selectTarget(RadarStats.RadarPing ping) {
        this.selectTarget(ping.id);
    }

    public void selectTarget(int id) {
        this.selectedIndex = -1;
        for (int i = 0; i < this.targets.size(); ++i) {
            if (this.targets.get((int)i).id != id) continue;
            this.selectedIndex = i;
            break;
        }
    }

    public void selectTarget(Entity entity) {
        Entity v;
        this.selectedIndex = -1;
        if (this.hasTarget(entity.m_19879_())) {
            this.selectTarget(entity.m_19879_());
        } else if (entity.m_20159_() && this.hasTarget((v = entity.m_20201_()).m_19879_())) {
            this.selectTarget(v.m_19879_());
        }
    }

    @Nullable
    public Entity getSelectedTarget() {
        if (this.selectedIndex == -1) {
            return null;
        }
        int id = this.targets.get((int)this.selectedIndex).id;
        return this.parent.getWorld().m_6815_(id);
    }

    @Nullable
    public RadarStats.RadarPing getServerSelectedPing() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.targets.get(this.selectedIndex);
    }

    @Nullable
    public LivingEntity getLivingTargetByWeapon(WeaponInstance<?> wd) {
        for (RadarStats.RadarPing ping : this.targets) {
            Entity entity;
            if (ping.isFriendly || !((entity = this.parent.getWorld().m_6815_(ping.id)) instanceof LivingEntity)) continue;
            LivingEntity target = (LivingEntity)entity;
            if (!wd.couldRadarWeaponTargetEntity(entity, (Entity)this.parent)) continue;
            return target;
        }
        return null;
    }

    @Nullable
    public Player getPlayerTargetByWeapon(WeaponInstance<?> wd) {
        for (RadarStats.RadarPing ping : this.targets) {
            Player target;
            Player target2;
            Entity entity;
            if (ping.isFriendly || (entity = this.parent.getWorld().m_6815_(ping.id)) == null) continue;
            if (entity instanceof Player && !(target2 = (Player)entity).m_7500_() && wd.couldRadarWeaponTargetEntity(entity, (Entity)this.parent)) {
                return target2;
            }
            Entity entity2 = entity.m_6688_();
            if (!(entity2 instanceof Player) || (target = (Player)entity2).m_7500_() || !wd.couldRadarWeaponTargetEntity(entity, (Entity)this.parent)) continue;
            return target;
        }
        return null;
    }

    public void clientSelectTarget(RadarStats.RadarPing ping) {
        this.clientSelectedIndex = -1;
        for (int i = 0; i < this.clientTargets.size(); ++i) {
            if (this.clientTargets.get((int)i).id != ping.id) continue;
            this.clientSelectTarget(i);
        }
    }

    public void clientSelectNextTarget() {
        int size = this.getClientRadarPings().size();
        if (size == 0) {
            return;
        }
        int k = 0;
        int s = this.clientSelectedIndex;
        while (k++ < size) {
            if (++s >= size) {
                s = 0;
            }
            if (this.getClientRadarPings().get((int)s).entityType.isMissile()) continue;
        }
        this.clientSelectTarget(s);
    }

    public void clientSelectTarget(int pingIndex) {
        if (pingIndex < 0 || pingIndex >= this.getClientRadarPings().size()) {
            return;
        }
        if (this.parent.f_19797_ - this.clientSelectedTime < 2) {
            return;
        }
        this.clientSelectedIndex = pingIndex;
        this.parent.soundManager.playPassengerRadarLockSound();
        VehicleSyncAction.sendSyncAction(new VehicleSyncAction.PingSelectAction(this.clientTargets.get(pingIndex)));
        this.clientSelectedTime = this.parent.f_19797_;
    }

    public int getClientSelectedPingIndex() {
        return this.clientSelectedIndex;
    }

    @NotNull
    public List<RadarStats.RadarPing> getClientRadarPings() {
        return this.clientTargets;
    }

    @Nullable
    public RadarStats.RadarPing getClientSelectedPing() {
        if (this.clientSelectedIndex < 0 || this.clientSelectedIndex >= this.getClientRadarPings().size()) {
            return null;
        }
        return this.getClientRadarPings().get(this.clientSelectedIndex);
    }

    public boolean isClientLocking() {
        return this.getClientSelectedPingIndex() != -1;
    }

    public void readClientPingsFromServer(List<RadarStats.RadarPing> pings) {
        this.removeUnwantedPings(pings);
        RadarStats.RadarPing oldSelect = null;
        if (this.clientSelectedIndex != -1) {
            oldSelect = this.clientTargets.get(this.clientSelectedIndex);
        }
        this.clientTargets = pings;
        this.clientSelectedIndex = -1;
        if (oldSelect != null) {
            int id = oldSelect.id;
            for (int i = 0; i < this.clientTargets.size(); ++i) {
                if (this.clientTargets.get((int)i).id != id) continue;
                this.clientSelectedIndex = i;
                break;
            }
        }
        this.updateClientPingPos();
        this.clientPingRefreshTime = this.parent.f_19797_;
    }

    private void removeUnwantedPings(List<RadarStats.RadarPing> pings) {
        RadarStats.RadarMode mode = DSCClientInputs.getPreferredRadarMode();
        for (int i = 0; i < pings.size(); ++i) {
            if (!pings.get(i).dontDisplayByMode(mode)) continue;
            pings.remove(i--);
        }
    }

    public boolean hasRadar() {
        return this.radars.size() > 0;
    }

    public boolean hasRadar(String id) {
        for (RadarInstance<?> r : this.radars) {
            if (!r.getStatsId().equals(id)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public RadarInstance<?> get(String id, String slotId) {
        for (RadarInstance<?> r : this.radars) {
            if (!r.idMatch(id, slotId)) continue;
            return r;
        }
        return null;
    }

    public boolean addRadar(RadarInstance<?> r) {
        if (this.get(r.getStatsId(), r.getSlotId()) != null) {
            return false;
        }
        this.radars.add(r);
        return true;
    }

    public boolean removeRadar(String id, String slotId) {
        RadarInstance<?> radar = this.get(id, slotId);
        if (radar == null) {
            return false;
        }
        radar.resetPings(this.targets);
        return this.radars.remove(radar);
    }

    public double getMaxAirRange() {
        double max = 0.0;
        for (RadarInstance<?> r : this.radars) {
            if (!((RadarStats)r.getStats()).isScanAir() || !(((RadarStats)r.getStats()).getRange() > max)) continue;
            max = ((RadarStats)r.getStats()).getRange();
        }
        return max;
    }

    public String toString() {
        Object s = "Radars:";
        for (int i = 0; i < this.radars.size(); ++i) {
            s = (String)s + this.radars.get(i).toString();
        }
        return s;
    }

    public boolean isReadData() {
        return this.readData;
    }

    public void addRWRWarning(int fromId, Vec3 pos, boolean isMissile, boolean fromGround) {
        if (this.parent == null || this.parent.isClientSide() || !this.hasRadar()) {
            return;
        }
        RWRWarning warning = new RWRWarning(fromId, pos, fromGround, isMissile);
        PacketHandler.sendToTrackers(new ToClientRWRWarning(this.parent.m_19879_(), warning), (Entity)this.parent);
    }

    public void readRWRWarningFromServer(RWRWarning warning) {
        if (this.rwrWarnings.containsKey(warning.fromId)) {
            RWRWarning w = this.rwrWarnings.get(warning.fromId);
            w.age = 0;
            w.pos = warning.pos;
        } else {
            this.rwrWarnings.put(warning.fromId, warning);
        }
        if (warning.isMissile) {
            this.rwrMissile = true;
        }
        this.rwrRadar = true;
        this.clientRwrRefreshTime = this.parent.f_19797_;
    }

    public boolean isTrackedByMissile() {
        return this.rwrMissile;
    }

    public boolean isTrackedByRadar() {
        return this.rwrRadar;
    }

    public boolean clientConsumePingWarningSound() {
        return false;
    }

    public void serverTick() {
        this.tickUpdateTargets();
        this.updateVisibility();
    }

    public void clientTick() {
        this.ageRWR();
        this.updateClientPingPos();
    }

    private void ageRWR() {
        this.rwrRadar = false;
        this.rwrMissile = false;
        if (this.rwrWarnings.isEmpty()) {
            return;
        }
        Iterator<RWRWarning> it = this.rwrWarnings.values().iterator();
        while (it.hasNext()) {
            RWRWarning n = it.next();
            ++n.age;
            if (n.age <= 10) {
                if (n.isMissile) {
                    this.rwrMissile = true;
                }
                this.rwrRadar = true;
            }
            if (n.isMissile && n.age > 20) {
                it.remove();
                continue;
            }
            if (n.age <= 60) continue;
            it.remove();
        }
    }

    private void updateClientPingPos() {
        for (RadarStats.RadarPing ping : this.clientTargets) {
            ping.setClientPos(this.parent.getWorld());
        }
    }

    public boolean clientHasRWRWarnings() {
        return !this.rwrWarnings.isEmpty();
    }

    public Collection<RWRWarning> getClientRWRWarnings() {
        return this.rwrWarnings.values();
    }

    public int getJammedTicks() {
        if (!this.hasRadar()) {
            return 0;
        }
        return 0;
    }

    public static class RWRWarning {
        public final int fromId;
        public final boolean fromGround;
        public final boolean isMissile;
        public Vec3 pos;
        public int age = 0;

        public RWRWarning(int fromId, Vec3 pos, boolean fromGround, boolean isMissile) {
            this.fromId = fromId;
            this.pos = pos;
            this.fromGround = fromGround;
            this.isMissile = isMissile;
        }

        public RWRWarning(FriendlyByteBuf buffer) {
            this.fromId = buffer.readInt();
            this.pos = (Vec3)DataSerializers.VEC3.m_6709_(buffer);
            this.fromGround = buffer.readBoolean();
            this.isMissile = buffer.readBoolean();
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeInt(this.fromId);
            DataSerializers.VEC3.m_6856_(buffer, (Object)this.pos);
            buffer.writeBoolean(this.fromGround);
            buffer.writeBoolean(this.isMissile);
        }

        public String toString() {
            return "RWR[" + (int)this.pos.f_82479_ + "," + (int)this.pos.f_82480_ + "," + (int)this.pos.f_82481_ + "]";
        }
    }
}

