/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.vehicle;

import com.onewhohears.dscombat.client.texture.VehicleDynamicTextures;
import com.onewhohears.dscombat.common.network.toserver.ToServerVehicleTexture;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilEntity;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class VehicleTextureManager {
    public final EntityVehicle parent;
    private ResourceLocation[] baseTextures;
    private TextureLayer[] textureLayers;
    private int baseTextureIndex = 0;
    private boolean changed;
    private ResourceLocation dynamicTexture;

    public VehicleTextureManager(EntityVehicle parent) {
        this.parent = parent;
        this.setupTextureLocations();
        this.dynamicTexture = this.getBaseTexture();
    }

    public void setupTextureLocations() {
        int i;
        this.baseTextures = new ResourceLocation[((VehicleStats)this.parent.getStats()).baseTextureVariants];
        this.textureLayers = new TextureLayer[((VehicleStats)this.parent.getStats()).textureLayers];
        String namespace = ((VehicleStats)this.parent.getStats()).getNameSpace();
        for (i = 0; i < this.baseTextures.length; ++i) {
            this.baseTextures[i] = new ResourceLocation(namespace + ":textures/entity/vehicle/" + this.parent.getAssetId() + "/base" + i + ".png");
        }
        for (i = 0; i < this.textureLayers.length; ++i) {
            this.textureLayers[i] = new TextureLayer(namespace + ":textures/entity/vehicle/" + this.parent.getAssetId() + "/layer" + i + ".png");
        }
    }

    public void setupDynamicTexture() {
        if (!this.parent.isClientSide()) {
            return;
        }
        this.dynamicTexture = VehicleDynamicTextures.createVehicleDynamicTexture(this.parent);
    }

    @Nullable
    public ResourceLocation getDynamicTexture() {
        return this.dynamicTexture;
    }

    public void onTick() {
        if (this.parent.isClientSide()) {
            this.clientTick();
        } else {
            this.serverTick();
        }
    }

    public void clientTick() {
        if (this.isChanged()) {
            new ToServerVehicleTexture(this.parent).sendToServer();
            this.setupDynamicTexture();
            this.resetChanged();
        }
    }

    public void serverTick() {
    }

    public void read(CompoundTag entityNbt) {
        if (!entityNbt.m_128441_("textures")) {
            return;
        }
        this.setupTextureLocations();
        CompoundTag textures = entityNbt.m_128469_("textures");
        this.setBaseTexture(textures.m_128451_("baseTexture"));
        if (textures.m_128441_("layers")) {
            ListTag layers = textures.m_128437_("layers", 10);
            for (int i = 0; i < this.textureLayers.length && i < layers.size(); ++i) {
                this.textureLayers[i].read(layers.m_128728_(i));
            }
        }
        this.changed = false;
    }

    public void write(CompoundTag entityNbt) {
        CompoundTag textures = new CompoundTag();
        textures.m_128405_("baseTexture", this.baseTextureIndex);
        ListTag layers = new ListTag();
        for (TextureLayer layer : this.getTextureLayers()) {
            layers.add((Object)layer.write());
        }
        textures.m_128365_("layers", (Tag)layers);
        entityNbt.m_128365_("textures", (Tag)textures);
    }

    public void read(ByteBuf buffer) {
        this.setupTextureLocations();
        this.setBaseTexture(buffer.readInt());
        int layers = buffer.readInt();
        for (int i = 0; i < layers && i < this.textureLayers.length; ++i) {
            this.textureLayers[i].read(buffer);
        }
        this.setupDynamicTexture();
        this.changed = false;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.baseTextureIndex);
        buffer.writeInt(this.textureLayers.length);
        for (int i = 0; i < this.textureLayers.length; ++i) {
            this.textureLayers[i].write(buffer);
        }
    }

    public ResourceLocation getBaseTexture() {
        return this.baseTextures[this.baseTextureIndex];
    }

    public int getBaseTextureNum() {
        return this.baseTextures.length;
    }

    public int getBaseTextureIndex() {
        return this.baseTextureIndex;
    }

    public void setBaseTexture(int index) {
        if (index >= this.baseTextures.length || index < 0) {
            index = 0;
        }
        this.baseTextureIndex = index;
        this.changed = true;
    }

    public int getLayerNum() {
        return this.textureLayers.length;
    }

    public TextureLayer[] getTextureLayers() {
        return this.textureLayers;
    }

    public boolean isAllLayersDisabled() {
        for (int i = 0; i < this.getTextureLayers().length; ++i) {
            if (!this.getTextureLayers()[i].canRender()) continue;
            return false;
        }
        return true;
    }

    public boolean isChanged() {
        if (this.changed) {
            return true;
        }
        for (int i = 0; i < this.textureLayers.length; ++i) {
            if (!this.textureLayers[i].isChanged()) continue;
            return true;
        }
        return false;
    }

    public void resetChanged() {
        this.changed = false;
        for (int i = 0; i < this.textureLayers.length; ++i) {
            this.textureLayers[i].resetChanged();
        }
    }

    public static class TextureLayer {
        private final ResourceLocation texture;
        private BlendMode blendMode = BlendMode.ON_WHITE;
        private int colorInt;
        private Color color;
        private boolean enabled;
        private boolean changed;

        public TextureLayer(String texture) {
            this.texture = new ResourceLocation(texture);
            this.setColor(UtilEntity.getRandomColor());
            this.changed = false;
        }

        public void read(CompoundTag tag) {
            if (tag.m_128441_("color")) {
                this.setColor(tag.m_128451_("color"));
            }
            this.enabled = tag.m_128471_("enabled");
            if (tag.m_128441_("blendMode")) {
                this.blendMode = BlendMode.getByName(tag.m_128461_("blendMode"));
            }
            this.changed = false;
        }

        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("color", this.colorInt);
            tag.m_128379_("enabled", this.enabled);
            tag.m_128359_("blendMode", this.blendMode.name());
            return tag;
        }

        public void read(ByteBuf buffer) {
            this.setColor(buffer.readInt());
            this.enabled = buffer.readBoolean();
            this.blendMode = BlendMode.values()[buffer.readInt()];
            this.changed = false;
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeInt(this.colorInt);
            buffer.writeBoolean(this.enabled);
            buffer.writeInt(this.blendMode.ordinal());
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public Color getColor() {
            return this.color;
        }

        public int getColorInt() {
            return this.colorInt;
        }

        public void setColor(int color) {
            this.colorInt = color;
            this.color = new Color(this.colorInt);
            this.changed = true;
        }

        public void setColor(String color) {
            try {
                this.setColor(Color.decode("0x" + color).getRGB());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public boolean canRender() {
            return this.enabled;
        }

        public void setCanRender(boolean render) {
            this.enabled = render;
            this.changed = true;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public void resetChanged() {
            this.changed = false;
        }

        public BlendMode getBlendMode() {
            return this.blendMode;
        }

        public void setBlendMode(BlendMode mode) {
            this.blendMode = mode;
            this.changed = true;
        }
    }

    public static enum BlendMode {
        NONE,
        ON_WHITE,
        ON_ALL,
        SCALED,
        EVEN;


        public static BlendMode getByName(String name) {
            for (BlendMode mode : BlendMode.values()) {
                if (!mode.name().equals(name)) continue;
                return mode;
            }
            return NONE;
        }

        public String getTranslatable() {
            return "blendmode.dscombat." + this.name().toLowerCase();
        }
    }
}

