/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.data.vehicle.physics.PhysicsComponentInstance;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public interface PhysicsBody {
    default public void m_146922_(float yRot) {
        this.setQBySide(UtilAngles.toQuaternionF((double)this.m_146908_(), (double)this.m_146909_(), (double)this.getZRot()));
    }

    default public void m_146926_(float xRot) {
        this.setQBySide(UtilAngles.toQuaternionF((double)this.m_146908_(), (double)this.m_146909_(), (double)this.getZRot()));
    }

    default public void tickPhysics() {
        QuaternionF q = this.getQBySide();
        this.setPrevDeltaMove(this.m_20184_());
        this.setPrevForces(this.getForces());
        this.setPrevMoment(this.getMoment());
        this.setPrevZRot(this.getZRot());
        this.setPrevQ(q);
        this.setForces(Vec3.f_82478_);
        this.setMoment(Vec3.f_82478_);
        this.setControlMoment(Vec3.f_82478_);
        boolean testMode = this.isTestMode();
        boolean windTunnel = this.isInWindTunnel();
        if (testMode && !windTunnel) {
            this.m_20256_(this.m_20154_());
        }
        this.calcMoveStatsPre(q);
        this.calcForceMoment(q);
        this.getPhysicsInstances().forEach(instance -> instance.tick(this));
        this.calcAcc();
        this.motionClamp();
        if (!testMode) {
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        this.calcMoveStatsPost(q);
        this.calcRotAcc(q);
        if (!testMode || !windTunnel) {
            this.setQBySide(q);
            this.updateEulerAngles();
        }
    }

    default public boolean isInWindTunnel() {
        return !this.getPhysicsInstances().isEmpty() && this.getPhysicsInstances().get(0).getWindTunnel() != null;
    }

    default public void updateEulerAngles() {
        QuaternionF q = this.getQBySide();
        UtilAngles.EulerAngles angles = UtilAngles.toDegrees((QuaternionF)q);
        this.setXRotNoQ((float)angles.pitch);
        this.setYRotNoQ((float)angles.yaw);
        this.setZRot((float)angles.roll);
    }

    default public void calcRotAcc(QuaternionF q) {
        this.clampControlMoment();
        this.addMoment(this.getControlMoment(), false, true);
        this.addMoment(this.getMomentBetweenTicks(), false, true);
        Vec3 m = this.getMoment().m_82490_(this.getAccTimeScale());
        Vec3 av = this.getAngularVel();
        if (!UtilGeometry.isZero((Vec3)m)) {
            Vec3 I = this.getTotalRotInertia();
            av = av.m_82520_(m.f_82479_ / I.f_82479_, m.f_82480_ / I.f_82480_, m.f_82481_ / I.f_82481_);
            this.setAngularVel(av);
        }
        q.mul(PhysicsBody.rotateAngularVel(av));
        this.setMomentBetweenTicks(Vec3.f_82478_);
        this.reducePitchRateWhileRolling();
    }

    public static QuaternionF rotateAngularVel(Vec3 av) {
        return new QuaternionF((float)(-av.f_82479_), (float)(-av.f_82480_), (float)av.f_82481_, true);
    }

    default public void reducePitchRateWhileRolling() {
        if (Math.abs(this.getZRot()) < 40.0f && this.getPitchInput() == 0.0f && this.isOperational()) {
            this.setAngularVel(this.getAngularVel().m_82542_(0.8, 1.0, 1.0));
        }
    }

    default public void addMoment(Vec3 moment, boolean control, boolean relative) {
        if (!relative) {
            // empty if block
        }
        if (control && (!this.canUseTurnAssist() || this.isUsingTurnAssist())) {
            this.addControlMoment(moment);
        } else {
            this.setMoment(this.getMoment().m_82549_(moment));
        }
    }

    default public void clampControlMoment() {
        Vec3 cm = this.getControlMoment();
        if (UtilGeometry.isZero((Vec3)cm)) {
            return;
        }
        Vec3 I = this.getTotalRotInertia();
        Vec3 av = this.getAngularVel();
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (cm.f_82479_ != 0.0) {
            x = this.getControlMomentComponent(cm.f_82479_, av.f_82479_, this.getControlMaxDeltaPitch(), I.f_82479_);
        }
        if (cm.f_82480_ != 0.0) {
            y = this.getControlMomentComponent(cm.f_82480_, av.f_82480_, this.getControlMaxDeltaYaw(), I.f_82480_);
        }
        if (cm.f_82481_ != 0.0) {
            z = this.getControlMomentComponent(cm.f_82481_, av.f_82481_, this.getControlMaxDeltaRoll(), I.f_82481_);
        }
        this.setControlMoment(new Vec3(x, y, z));
    }

    public float getControlMaxDeltaPitch();

    public float getControlMaxDeltaYaw();

    public float getControlMaxDeltaRoll();

    private double getControlMomentComponent(double cm, double v, float max, double I) {
        if (Math.abs(v) > (double)max && Math.signum(v) == Math.signum(cm)) {
            return 0.0;
        }
        double a2 = cm / I * this.getAccTimeScale();
        double v2 = v + a2;
        double vd = Math.abs(v2) - (double)max;
        if (vd > 0.0) {
            cm -= vd * Math.signum(v2) * I / this.getAccTimeScale();
        }
        return cm;
    }

    default public void calcForceMoment(QuaternionF q) {
        this.calcUniversalForces(q);
        this.calcUniversalMoments(q);
        if (this.m_20096_() && this.m_20069_()) {
            this.calcGroundMovement(q);
            this.calcWaterMovement(q);
        } else if (this.m_20096_()) {
            this.calcGroundMovement(q);
        } else if (this.m_20069_()) {
            this.calcWaterMovement(q);
        } else {
            this.calcAirMovement(q);
        }
    }

    default public void calcUniversalMoments(QuaternionF q) {
        this.applyAngularDrag();
        this.addControllingTorques(q);
    }

    default public void applyAngularDrag() {
        float d;
        Vec3 av = this.getAngularVel();
        float dx = d = this.getAngularDrag();
        float dy = d;
        float dz = d;
        if (!this.m_20096_() || this.dontUseDriveTurnPhysics()) {
            if (this.getPitchInput() != 0.0f && Math.abs(av.f_82479_) <= (double)this.getControlMaxDeltaPitch()) {
                dx = 0.0f;
            }
            if (this.getYawInput() != 0.0f && Math.abs(av.f_82480_) <= (double)this.getControlMaxDeltaYaw()) {
                dy = 0.0f;
            }
            if (this.getRollInput() != 0.0f && Math.abs(av.f_82481_) <= (double)this.getControlMaxDeltaRoll()) {
                dz = 0.0f;
            }
        }
        Vec3 I = this.getTotalRotInertia();
        this.setAngularVel(new Vec3(this.getADComponent(av.f_82479_, dx, I.f_82479_), this.getADComponent(av.f_82480_, dy, I.f_82480_), this.getADComponent(av.f_82481_, dz, I.f_82481_)));
    }

    default public boolean dontUseDriveTurnPhysics() {
        return false;
    }

    private double getADComponent(double v, float d, double I) {
        double a;
        double av = Math.abs(v);
        double da = (double)d / I + av * 0.01;
        if (this.isHardCodedRotAcc()) {
            double d2 = da = d > 0.0f ? (double)this.getHardCodedRotDecel() : 0.0;
        }
        if ((a = av - da) < 0.001) {
            return 0.0;
        }
        return a * Math.signum(v);
    }

    default public float getAngularDrag() {
        float d = (float)this.getFluidDensity() * this.getAngularDragScale();
        if (this.m_20096_()) {
            d *= 10.0f;
        }
        return d;
    }

    public float getAngularDragScale();

    public double getFluidDensity();

    public double getAirDensity();

    public Vec3 getTotalRotInertia();

    public void addControllingTorques(QuaternionF var1);

    default public void hardCodedAccPitch() {
        Vec3 av = this.getAngularVel();
        double acc = this.getHardCodedRotAcc().f_82479_ * (double)this.getPitchInput();
        double next = this.getAccComp(av.f_82479_, acc, this.getControlMaxDeltaPitch());
        this.setAngularVel(new Vec3(next, av.f_82480_, av.f_82481_));
    }

    default public void hardCodedAccYaw() {
        Vec3 av = this.getAngularVel();
        double acc = this.getHardCodedRotAcc().f_82480_ * (double)this.getYawInput();
        double next = this.getAccComp(av.f_82480_, acc, this.getControlMaxDeltaYaw());
        this.setAngularVel(new Vec3(av.f_82479_, next, av.f_82481_));
    }

    default public void hardCodedAccRoll() {
        Vec3 av = this.getAngularVel();
        double acc = this.getHardCodedRotAcc().f_82481_ * (double)this.getRollInput();
        double next = this.getAccComp(av.f_82481_, acc, this.getControlMaxDeltaRoll());
        this.setAngularVel(new Vec3(av.f_82479_, av.f_82480_, next));
    }

    private double getAccComp(double current, double acc, double max) {
        double c = Math.abs(current);
        if (c > max) {
            return current;
        }
        if (acc < 0.0) {
            return Math.max(current + acc, -max);
        }
        return Math.min(current + acc, max);
    }

    default public void calcUniversalForces(QuaternionF q) {
        this.addForce(this.getWeightForce());
        this.addForce(this.getThrustForce(q));
        this.addDragForce(this.getDragForce(q));
    }

    public void calcGroundMovement(QuaternionF var1);

    public void calcWaterMovement(QuaternionF var1);

    public void calcAirMovement(QuaternionF var1);

    default public Vec3 getWeightForce() {
        return new Vec3(0.0, (double)(-this.getTotalMass()) * this.getAccGravity(), 0.0);
    }

    public Vec3 getThrustForce(QuaternionF var1);

    default public Vec3 getDragForce(QuaternionF q) {
        return this.m_20184_().m_82541_().m_82490_(-this.getDragMag());
    }

    default public Vec3 calcTotalDrag(QuaternionF q) {
        Vec3 d = this.getDragForce(q);
        for (PhysicsComponentInstance<?> phy : this.getPhysicsInstances()) {
            d = d.m_82549_(phy.getDragForce());
        }
        return d;
    }

    default public Vec3 calcTotalLift(QuaternionF q) {
        Vec3 l = Vec3.f_82478_;
        for (PhysicsComponentInstance<?> phy : this.getPhysicsInstances()) {
            l = l.m_82549_(phy.getLiftForce());
        }
        return l;
    }

    default public double getDragMag() {
        double speedSqr = this.m_20184_().m_82556_() * 400.0;
        return 0.5 * this.getFluidDensity() * speedSqr * this.getDragArea() * this.getDragCoefficient();
    }

    public double getDragArea();

    public double getDragCoefficient();

    default public void calcAcc() {
        Vec3 f = this.getForces().m_82549_(this.getForcesBetweenTicks());
        this.m_20256_(this.m_20184_().m_82549_(this.getAccFromForce(f)));
        this.setForcesBetweenTicks(Vec3.f_82478_);
    }

    default public Vec3 getAccFromForce(Vec3 forces) {
        if (this.applyHorizontalSpeedScale()) {
            forces = forces.m_82542_(this.getHorizontalSpeedScale(), 1.0, this.getHorizontalSpeedScale());
        }
        if (this.applyVerticalAccScale()) {
            forces = forces.m_82542_(1.0, this.getVerticalAccScale(forces.m_7098_()), 1.0);
        }
        double massScale = 1.0f / this.getTotalMass();
        return forces.m_82490_(massScale).m_82490_(this.getAccTimeScale());
    }

    default public double getAccFromForce(double force, boolean horizontal) {
        force = force / (double)this.getTotalMass() * this.getAccTimeScale();
        if (horizontal) {
            return force * this.getHorizontalSpeedScale();
        }
        return force * this.getVerticalAccScale(force);
    }

    default public void motionClamp() {
        Vec3 move = this.m_20184_();
        double goalMaxXZ = Math.min(this.getMaxSpeedForMotion(), (Double)Config.SERVER.universalTopSpeed.get() / 20.0);
        this.setLerpMaxXZ(Mth.m_14139_((double)0.01f, (double)this.getLerpMaxXZ(), (double)goalMaxXZ));
        Vec3 motionXZ = new Vec3(move.f_82479_, 0.0, move.f_82481_);
        double velXZ = motionXZ.m_82553_();
        if (velXZ > this.getLerpMaxXZ()) {
            motionXZ = motionXZ.m_82490_(this.getLerpMaxXZ() / velXZ);
        }
        this.m_20334_(motionXZ.f_82479_, this.clampYMove(move), motionXZ.f_82481_);
    }

    default public double clampYMove(Vec3 move) {
        double my = move.f_82480_;
        if (my > this.getMaxClimbSpeed()) {
            my = this.getMaxClimbSpeed();
        } else if (my < -this.getMaxFallSpeed()) {
            my = -this.getMaxFallSpeed();
        } else if (Math.abs(my) < 0.001) {
            my = 0.0;
        }
        double decreaseSpeedPos = 100.0;
        double altitude = this.getAltitude();
        double nextY = altitude + my;
        if (nextY > this.getMaxAltitude()) {
            my = this.getMaxAltitude() - altitude;
            if (this.flattenIfMaxAltitude() && this.m_146909_() < 0.0f) {
                this.flattenPitch(this.getQBySide(), 0.1f);
            }
        } else if (altitude > this.getMaxAltitude() - decreaseSpeedPos) {
            double percent = (altitude - this.getMaxAltitude() + decreaseSpeedPos) / decreaseSpeedPos;
            double maxY = 1.0 - percent;
            if (my > maxY) {
                my = maxY;
            }
            if (this.flattenIfMaxAltitude() && (double)this.m_146909_() < -maxY * 20.0) {
                this.flattenPitch(this.getQBySide(), (float)(0.1 * percent));
            }
        }
        if (this.m_20096_() && my < 0.0) {
            my = -0.01;
        }
        return my;
    }

    default public boolean flattenIfMaxAltitude() {
        return true;
    }

    default public void addForce(Vec3 force) {
        this.setForces(this.getForces().m_82549_(force));
    }

    default public void addDragForce(Vec3 force) {
        Vec3 m = this.m_20184_();
        if (UtilGeometry.isZero((Vec3)m)) {
            return;
        }
        Vec3 acc = this.getAccFromForce(force);
        if (m.f_82479_ != 0.0 && Math.signum(m.f_82479_ + acc.f_82479_) != Math.signum(m.f_82479_)) {
            force = force.m_82542_(0.0, 1.0, 1.0);
            m = m.m_82542_(0.0, 1.0, 1.0);
        }
        if (m.f_82480_ != 0.0 && Math.signum(m.f_82480_ + acc.f_82480_) != Math.signum(m.f_82480_)) {
            force = force.m_82542_(1.0, 0.0, 1.0);
            m = m.m_82542_(1.0, 0.0, 1.0);
        }
        if (m.f_82481_ != 0.0 && Math.signum(m.f_82481_ + acc.f_82481_) != Math.signum(m.f_82481_)) {
            force = force.m_82542_(1.0, 1.0, 0.0);
            m = m.m_82542_(1.0, 1.0, 0.0);
        }
        this.m_20256_(m);
        this.addForce(force);
    }

    default public void addFrictionForce(double f) {
        Vec3 m = this.m_20184_();
        if (m.f_82479_ == 0.0 && m.f_82481_ == 0.0) {
            return;
        }
        Vec3 mn = m.m_82541_();
        Vec3 force = mn.m_82490_(-f);
        Vec3 acc = this.getAccFromForce(force);
        if (m.f_82479_ != 0.0 && Math.signum(m.f_82479_ + acc.f_82479_) != Math.signum(m.f_82479_)) {
            force = force.m_82542_(0.0, 1.0, 1.0);
            m = m.m_82542_(0.0, 1.0, 1.0);
        }
        if (m.f_82481_ != 0.0 && Math.signum(m.f_82481_ + acc.f_82481_) != Math.signum(m.f_82481_)) {
            force = force.m_82542_(1.0, 1.0, 0.0);
            m = m.m_82542_(1.0, 1.0, 0.0);
        }
        this.m_20256_(m);
        this.setForces(this.getForces().m_82549_(force));
    }

    default public void addControlMoment(Vec3 moment) {
        this.setControlMoment(this.getControlMoment().m_82549_(moment));
    }

    default public void addForcesBetweenTicks(Vec3 forces) {
        this.setForcesBetweenTicks(this.getForcesBetweenTicks().m_82549_(forces));
    }

    default public void addMomentBetweenTicks(Vec3 moment) {
        this.setMomentBetweenTicks(this.getMomentBetweenTicks().m_82549_(moment));
    }

    default public void addMomentX(float moment, boolean control) {
        this.addMoment(Vec3.f_82478_.m_82520_((double)moment, 0.0, 0.0), control, true);
    }

    default public void addMomentY(float moment, boolean control) {
        this.addMoment(Vec3.f_82478_.m_82520_(0.0, (double)moment, 0.0), control, true);
    }

    default public void addMomentZ(float moment, boolean control) {
        this.addMoment(Vec3.f_82478_.m_82520_(0.0, 0.0, (double)moment), control, true);
    }

    default public void flattenPitch(QuaternionF q, float dPitch) {
        Vec3 av = this.getAngularVel();
        float x = (float)av.f_82479_;
        UtilAngles.EulerAngles angles = UtilAngles.toDegrees((QuaternionF)q);
        if (dPitch != 0.0f) {
            float diff;
            float goalPitch = 0.0f;
            if (this.m_20096_()) {
                goalPitch = -this.getGroundXTilt();
            }
            float pitch = Math.abs(diff = (float)angles.pitch - goalPitch) < dPitch ? diff : Math.signum(diff) * dPitch;
            x += pitch;
        }
        this.setAngularVel(new Vec3((double)x, av.f_82480_, av.f_82481_));
    }

    default public void flatten(QuaternionF q, float dPitch, float dRoll, boolean forced) {
        Vec3 av = this.getAngularVel();
        float x = (float)av.f_82479_;
        float z = (float)av.f_82481_;
        if (!forced) {
            if (Math.abs(av.f_82479_) <= (double)dPitch) {
                x = 0.0f;
            }
            if (Math.abs(av.f_82481_) <= (double)dRoll) {
                z = 0.0f;
            }
        } else {
            z = 0.0f;
            x = 0.0f;
        }
        UtilAngles.EulerAngles angles = UtilAngles.toDegrees((QuaternionF)q);
        if (dRoll != 0.0f) {
            float roll = Math.abs(angles.roll) < (double)dRoll ? (float)(-angles.roll) : -((float)Math.signum(angles.roll)) * dRoll;
            z += roll;
        }
        if (dPitch != 0.0f) {
            float diff;
            float goalPitch = 0.0f;
            if (this.m_20096_()) {
                goalPitch = -this.getGroundXTilt();
            }
            float pitch = Math.abs(diff = (float)angles.pitch - goalPitch) < dPitch ? diff : Math.signum(diff) * dPitch;
            x += pitch;
        }
        this.setAngularVel(new Vec3((double)x, av.f_82480_, (double)z));
    }

    default public double getHorizontalSpeedScaleOrOne() {
        if (this.applyHorizontalSpeedScale()) {
            return this.getHorizontalSpeedScale();
        }
        return 1.0;
    }

    public void m_6478_(@NotNull MoverType var1, @NotNull Vec3 var2);

    public List<PhysicsComponentInstance<?>> getPhysicsInstances();

    public void calcMoveStatsPre(QuaternionF var1);

    public void calcMoveStatsPost(QuaternionF var1);

    public float getTotalMass();

    public double getAccTimeScale();

    public double getHorizontalSpeedScale();

    public boolean applyHorizontalSpeedScale();

    public double getVerticalAccScale(double var1);

    public boolean applyVerticalAccScale();

    public double getMaxSpeedForMotion();

    public double getLerpMaxXZ();

    public void setLerpMaxXZ(double var1);

    public double getMaxClimbSpeed();

    public double getMaxFallSpeed();

    public double getAltitude();

    public double getMaxAltitude();

    public double getAccGravity();

    public float getGroundXTilt();

    public boolean isHardCodedRotAcc();

    public Vec3 getHardCodedRotAcc();

    public float getHardCodedRotDecel();

    public QuaternionF getQBySide();

    public void setQBySide(QuaternionF var1);

    public QuaternionF getPrevQ();

    public void setPrevQ(QuaternionF var1);

    public float m_146909_();

    public float m_146908_();

    public void setXRotNoQ(float var1);

    public void setYRotNoQ(float var1);

    public float getZRot();

    public void setZRot(float var1);

    public float getPrevZRot();

    public void setPrevZRot(float var1);

    public Vec3 m_20184_();

    public void m_20256_(Vec3 var1);

    public void m_20334_(double var1, double var3, double var5);

    public Vec3 getPrevDeltaMove();

    public void setPrevDeltaMove(Vec3 var1);

    public Vec3 getForces();

    public void setForces(Vec3 var1);

    public Vec3 getForcesBetweenTicks();

    public void setForcesBetweenTicks(Vec3 var1);

    public Vec3 getPrevForces();

    public void setPrevForces(Vec3 var1);

    public Vec3 getMoment();

    public void setMoment(Vec3 var1);

    public Vec3 getPrevMoment();

    public void setPrevMoment(Vec3 var1);

    public Vec3 getControlMoment();

    public void setControlMoment(Vec3 var1);

    public Vec3 getMomentBetweenTicks();

    public void setMomentBetweenTicks(Vec3 var1);

    public Vec3 getAngularVel();

    public void setAngularVel(Vec3 var1);

    public Vec3 m_20154_();

    public boolean m_20096_();

    public boolean m_20069_();

    public boolean isTestMode();

    public boolean isArcadeMode();

    public boolean canUseTurnAssist();

    public boolean isUsingTurnAssist();

    public boolean areAllHitboxesDead(String ... var1);

    public boolean isOperational();

    public int getAge();

    public boolean isClientSide();

    public float getPitchInput();

    public float getYawInput();

    public float getRollInput();

    public boolean isFlapsDown();

    public void debug(String var1);
}

