/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.damagesource;

import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VehicleDamageSource
extends DamageSource {
    public final EntityVehicle aircraft;
    public static final String[] roadKillDeaths = new String[]{"roadkill1", "roadkill2"};
    public static final String[] crashDeaths = new String[]{"plane_crash1", "plane_crash2"};
    public static final String[] fallCrashDeaths = new String[]{"plane_crash_fall1", "plane_crash_fall2", "plane_crash_fall3"};
    public static final String[] wallCrashDeaths = new String[]{"plane_crash_collide1", "plane_crash_collide2", "plane_crash_collide3"};

    public VehicleDamageSource(String type, EntityVehicle aircraft) {
        super(type);
        this.aircraft = aircraft;
    }

    public static DamageSource roadKill(EntityVehicle aircraft) {
        return new VehicleDamageSource(VehicleDamageSource.getRoadKillDeath(), aircraft);
    }

    public static DamageSource fall(EntityVehicle aircraft) {
        return new VehicleDamageSource(VehicleDamageSource.getFallDeath(), aircraft).m_19375_();
    }

    public static DamageSource collide(EntityVehicle aircraft) {
        return new VehicleDamageSource(VehicleDamageSource.getCollideDeath(), aircraft).m_19375_();
    }

    public static String getRoadKillDeath() {
        return UtilParse.getRandomString((String[][])new String[][]{crashDeaths, roadKillDeaths, wallCrashDeaths});
    }

    public static String getFallDeath() {
        return UtilParse.getRandomString((String[][])new String[][]{crashDeaths, fallCrashDeaths});
    }

    public static String getCollideDeath() {
        return UtilParse.getRandomString((String[][])new String[][]{crashDeaths, wallCrashDeaths});
    }

    public Component m_6157_(LivingEntity killed) {
        Entity killer = this.aircraft.m_6688_();
        String s = "death.attack.dscombat." + this.f_19326_;
        if (killer == null) {
            return UtilMCText.translatable((String)s, (Object[])new Object[]{killed.m_5446_()});
        }
        if (killed.equals((Object)killer)) {
            return UtilMCText.translatable((String)(s + ".self"), (Object[])new Object[]{killed.m_5446_()});
        }
        return UtilMCText.translatable((String)(s + ".player"), (Object[])new Object[]{killed.m_5446_(), killer.m_5446_()});
    }

    @NotNull
    public Entity m_7640_() {
        return this.aircraft;
    }

    @Nullable
    public Entity m_7639_() {
        return this.aircraft.m_6688_();
    }
}

