/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.damagesource;

import com.onewhohears.dscombat.entity.weapon.EntityWeapon;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeaponDamageSource
extends EntityDamageSource {
    protected final WeaponDamageType type;
    protected final EntityWeapon<?> weapon;
    protected final String deathMsgId;
    public static final String[] saltyDeaths = new String[]{"salty1"};
    public static final String[] explodeDeaths = new String[]{"explode1", "explode2"};
    public static final String[] bulletDeaths = new String[]{"bullet1", "bullet2"};
    public static final String[] bombDeaths = new String[]{"bomb1", "bomb2"};
    public static final String[] missileContactDeaths = new String[]{"missile_contact1", "missile_contact2"};
    public static final String[] missileDeaths = new String[]{"missile1", "missile2", "missile3", "missile4"};
    public static final String[] torpedoDeaths = new String[]{"torpedo1", "torpedo2"};
    public static final String[] irMissileDeaths = new String[]{"ir_missile1", "ir_missile2"};

    public WeaponDamageSource(WeaponDamageType type, @Nullable Entity shooter, @NotNull EntityWeapon<?> weapon) {
        super(type.damageTypeId, shooter);
        this.type = type;
        this.weapon = weapon;
        this.m_19366_();
        if (type.explosion) {
            this.m_19375_();
        }
        if (type.bypassArmor) {
            this.m_19380_();
        }
        this.deathMsgId = type.deathMessages.get();
    }

    public WeaponDamageType getWeaponDamageType() {
        return this.type;
    }

    public static String getBulletDeath() {
        return UtilParse.getRandomString((int[])new int[]{1, 2}, (String[][])new String[][]{saltyDeaths, bulletDeaths});
    }

    public static String getBulletExplodeDeath() {
        return UtilParse.getRandomString((int[])new int[]{1, 2, 4}, (String[][])new String[][]{saltyDeaths, bulletDeaths, explodeDeaths});
    }

    public static String getBombDeath() {
        return UtilParse.getRandomString((int[])new int[]{1, 4, 2}, (String[][])new String[][]{saltyDeaths, bombDeaths, explodeDeaths});
    }

    public static String getMissileContactDeath() {
        return UtilParse.getRandomString((int[])new int[]{1, 2, 4}, (String[][])new String[][]{saltyDeaths, missileDeaths, missileContactDeaths});
    }

    public static String getMissileDeath() {
        return UtilParse.getRandomString((int[])new int[]{1, 4, 2}, (String[][])new String[][]{saltyDeaths, missileDeaths, explodeDeaths});
    }

    public static String getTorpedoDeath() {
        return UtilParse.getRandomString((int[])new int[]{1, 2, 1, 4}, (String[][])new String[][]{saltyDeaths, missileDeaths, explodeDeaths, torpedoDeaths});
    }

    public static String getIRMissileDeath() {
        return UtilParse.getRandomString((int[])new int[]{1, 2, 1, 4}, (String[][])new String[][]{saltyDeaths, missileDeaths, explodeDeaths, irMissileDeaths});
    }

    @NotNull
    public Entity m_7640_() {
        return this.weapon;
    }

    @Nullable
    public Entity m_7639_() {
        return this.f_19391_;
    }

    public boolean m_7986_() {
        return false;
    }

    public Vec3 m_7270_() {
        return this.weapon.m_20182_();
    }

    public String toString() {
        return "WDS: " + this.f_19326_ + " / " + String.valueOf(this.weapon) + " / " + String.valueOf(this.f_19391_);
    }

    public Component m_6157_(LivingEntity livingEntity) {
        LivingEntity killer = livingEntity.m_21232_();
        String s = "death.attack.dscombat." + this.deathMsgId;
        if (killer == null) {
            return UtilMCText.translatable((String)s, (Object[])new Object[]{livingEntity.m_5446_()});
        }
        int dist = (int)livingEntity.m_20182_().m_82554_(this.weapon.getShootPos());
        s = s + ".player";
        return UtilMCText.translatable((String)s, (Object[])new Object[]{livingEntity.m_5446_(), killer.m_5446_(), "" + dist});
    }

    public static enum WeaponDamageType {
        BULLET("bullet", WeaponDamageSource::getBulletDeath, false, false),
        BULLET_EXPLODE("bullet_explode", WeaponDamageSource::getBulletExplodeDeath, true, false),
        BOMB("bomb", WeaponDamageSource::getBombDeath, true, false),
        MISSILE_CONTACT("missile_contact", WeaponDamageSource::getMissileContactDeath, false, true),
        MISSILE("missile", WeaponDamageSource::getMissileDeath, true, false),
        TORPEDO("tordepo", WeaponDamageSource::getTorpedoDeath, true, false),
        IR_MISSILE("ir_missile", WeaponDamageSource::getIRMissileDeath, true, false);

        public final String damageTypeId;
        public final RandomDeathMessageFactory deathMessages;
        public final boolean explosion;
        public final boolean bypassArmor;

        @Nullable
        public static WeaponDamageType byId(String id) {
            for (WeaponDamageType wdt : WeaponDamageType.values()) {
                if (!wdt.damageTypeId.equals(id)) continue;
                return wdt;
            }
            return null;
        }

        private WeaponDamageType(String damageTypeId, RandomDeathMessageFactory deathMessages, boolean explosion, boolean bypassArmor) {
            this.damageTypeId = damageTypeId;
            this.deathMessages = deathMessages;
            this.explosion = explosion;
            this.bypassArmor = bypassArmor;
        }

        public WeaponDamageSource getSource(@Nullable Entity shooter, @NotNull EntityWeapon<?> weapon) {
            return new WeaponDamageSource(this, shooter, weapon);
        }

        public boolean isContact() {
            return this == BULLET || this == MISSILE_CONTACT;
        }

        public boolean isMissileExplode() {
            return this == MISSILE || this == TORPEDO || this == IR_MISSILE;
        }
    }

    public static interface RandomDeathMessageFactory {
        public String get();
    }
}

