/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.weapon;

import com.onewhohears.dscombat.entity.IREmitter;
import com.onewhohears.dscombat.init.ModEntities;
import com.onewhohears.dscombat.init.ModParticles;
import com.onewhohears.onewholibs.util.UtilEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityFlare
extends Entity
implements IREmitter {
    private float heat = 20.0f;
    private int age = 120;
    private float pow = 3.0f;
    private float decay;

    public EntityFlare(EntityType<? extends EntityFlare> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.calcDecay();
    }

    public EntityFlare(Level level, float initHeat, int maxAge, float order) {
        this((EntityType<? extends EntityFlare>)((EntityType)ModEntities.FLARE.get()), level);
        this.heat = initHeat;
        this.age = maxAge;
        this.pow = order;
        this.calcDecay();
    }

    private void calcDecay() {
        if (this.heat == 0.0f || this.age == 0 || this.pow == 0.0f) {
            return;
        }
        this.decay = this.heat / (float)Math.pow(this.age, this.pow);
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag tag) {
        if (this.heat != 0.0f && this.age != 0 && this.pow != 0.0f) {
            return;
        }
        this.heat = tag.m_128457_("heat");
        this.age = tag.m_128451_("age");
        this.pow = tag.m_128457_("pow");
        this.calcDecay();
    }

    protected void m_7380_(CompoundTag tag) {
    }

    @NotNull
    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 move = this.m_20184_().m_82490_(0.999).m_82520_(0.0, -0.01, 0.0);
        if (move.f_82480_ < -0.2) {
            move = new Vec3(move.f_82479_, -0.2, move.f_82481_);
        }
        this.m_20256_(move);
        if (!this.isClientSide() && this.f_19797_ > this.age) {
            this.m_146870_();
        }
        if (this.isClientSide() && this.f_19797_ % 2 == 0) {
            this.particle();
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    public boolean isClientSide() {
        return this.getWorld().m_5776_();
    }

    public Level getWorld() {
        return UtilEntity.getLevel((Entity)this);
    }

    private void particle() {
        Vec3 move = this.m_20184_();
        this.getWorld().m_7106_((ParticleOptions)ModParticles.FLARE.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), move.f_82479_ + this.f_19796_.m_188583_() * 1.0E-4, move.f_82480_ + this.f_19796_.m_188583_() * 1.0E-4, move.f_82481_ + this.f_19796_.m_188583_() * 1.0E-4);
    }

    @Override
    public float getIRHeat() {
        return this.heat - (float)Math.pow(this.f_19797_, this.pow) * this.decay;
    }
}

