/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.item;

import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.data.weapon.client.WeaponAssets;
import com.onewhohears.dscombat.data.weapon.client.WeaponClientStats;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.ModItems;
import com.onewhohears.dscombat.item.ItemVehicle;
import com.onewhohears.dscombat.item.VehicleInteractItem;
import com.onewhohears.dscombat.item.forge.ItemAmmoImpl;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import com.onewhohears.onewholibs.item.ObjModelItem;
import com.onewhohears.onewholibs.util.UtilItem;
import com.onewhohears.onewholibs.util.UtilMCText;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemAmmo
extends Item
implements VehicleInteractItem,
ObjModelItem {
    private final String defaultWeaponId;

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemAmmo create(int stackSize, String defaultWeaponId) {
        void var1_1;
        return ItemAmmoImpl.create(stackSize, (String)var1_1);
    }

    public ItemAmmo(int size, String defaultWeaponId) {
        super(ItemAmmo.weaponProps(size));
        this.defaultWeaponId = defaultWeaponId;
    }

    public void m_6787_(@NotNull CreativeModeTab group, @NotNull NonNullList<ItemStack> items) {
        if (group != ModItems.WEAPONS && group != CreativeModeTab.f_40754_) {
            return;
        }
        String itemId = UtilItem.getItemKeyString((Item)this);
        for (int i = 0; i < WeaponPresets.get().getNum(); ++i) {
            WeaponStats w = ((WeaponStats[])WeaponPresets.get().getAll())[i];
            if (!w.getItemKey().equals(itemId)) continue;
            ItemStack test = new ItemStack((ItemLike)this);
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("weapon", w.getId());
            test.m_41751_(tag);
            items.add((Object)test);
        }
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tips, @NotNull TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tips, isAdvanced);
        String id = ItemAmmo.getWeaponId(stack);
        WeaponStats wd = WeaponPresets.get().get(id);
        if (wd == null) {
            return;
        }
        wd.addToolTips(tips, isAdvanced.m_7050_());
        if (isAdvanced.m_7050_()) {
            tips.add(ItemVehicle.formatTooltip("WeaponId", id));
        }
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        String id = ItemAmmo.getWeaponId(stack);
        WeaponStats wd = WeaponPresets.get().get(id);
        if (wd == null) {
            return UtilMCText.translatable((String)this.m_5524_()).m_130946_(" ").m_7220_((Component)UtilMCText.translatable((String)"error.dscombat.unknown_preset"));
        }
        return wd.getDisplayNameComponent().m_130946_(" ").m_7220_((Component)UtilMCText.literal((String)wd.getWeaponTypeCode())).m_130946_(" ").m_7220_((Component)UtilMCText.translatable((String)"info.dscombat.ammo"));
    }

    public static String getWeaponId(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ItemAmmo) {
            ItemAmmo ia = (ItemAmmo)item;
            if (stack.m_41783_() != null && stack.m_41783_().m_128441_("weapon")) {
                return stack.m_41783_().m_128461_("weapon");
            }
            return ia.defaultWeaponId;
        }
        return "";
    }

    public static Item.Properties weaponProps(int stackSize) {
        return new Item.Properties().m_41491_(ModItems.WEAPONS).m_41487_(stackSize);
    }

    @Override
    public InteractionResult onServerInteract(EntityVehicle vehicle, ItemStack stack, Player player, InteractionHand hand) {
        if (!vehicle.isOperational()) {
            return InteractionResult.FAIL;
        }
        String ammoId = ItemAmmo.getWeaponId(stack);
        for (EntityTurret t : vehicle.getTurrets()) {
            int o = t.addAmmo(stack.m_41613_());
            stack.m_41764_(o);
            if (stack.m_41613_() != 0) continue;
            return InteractionResult.SUCCESS;
        }
        int o = vehicle.weaponSystem.addAmmo(ammoId, stack.m_41613_(), true);
        stack.m_41764_(o);
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_();
        stack.m_41784_().m_128359_("weapon", this.defaultWeaponId);
        return stack;
    }

    @NotNull
    public String getPreset(@NotNull ItemStack stack) {
        return ItemAmmo.getWeaponId(stack);
    }

    @NotNull
    public String getObjModelId(@NotNull String preset) {
        WeaponStats wd = WeaponPresets.get().get(preset);
        if (wd == null) {
            return "";
        }
        String assetId = wd.getAssetId();
        WeaponClientStats assets = WeaponAssets.get().get(assetId);
        if (assets == null) {
            return "";
        }
        return assets.getModelId();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ObjEntityModels.ModelOverrides getItemModelOverrides(@NotNull String preset) {
        return ObjEntityModels.NO_OVERRIDES;
    }

    @NotNull
    public Item m_5456_() {
        return this;
    }
}

