/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.item;

import com.onewhohears.dscombat.data.parts.client.PartAssets;
import com.onewhohears.dscombat.data.parts.client.PartClientStats;
import com.onewhohears.dscombat.data.parts.instance.WeaponPartInstance;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.dscombat.data.parts.stats.WeaponPartStats;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.init.ModItems;
import com.onewhohears.dscombat.item.ItemPart;
import com.onewhohears.dscombat.item.forge.ItemWeaponPartImpl;
import com.onewhohears.dscombat.util.UtilPresetParse;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import com.onewhohears.onewholibs.item.ObjModelItem;
import com.onewhohears.onewholibs.util.UtilMCText;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemWeaponPart
extends ItemPart
implements ObjModelItem {
    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemWeaponPart create(int stackSize, String defaultPresetId) {
        void var1_1;
        return ItemWeaponPartImpl.create(stackSize, (String)var1_1);
    }

    public ItemWeaponPart(int stackSize, String defaultPresetId) {
        super(stackSize, defaultPresetId);
    }

    @Override
    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        String weapon = tag.m_128461_("weapon");
        MutableComponent name = ((MutableComponent)super.m_7626_(stack)).m_130946_(" ");
        if (weapon.isEmpty()) {
            name.m_130946_("EMPTY");
        } else {
            WeaponStats wd = WeaponPresets.get().get(weapon);
            if (wd != null) {
                name.m_7220_((Component)wd.getDisplayNameComponent()).m_130946_(" ").m_7220_((Component)UtilMCText.literal((String)wd.getWeaponTypeCode()));
            } else {
                name.m_130946_(weapon + "?");
            }
        }
        return name;
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tips, @NotNull TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tips, isAdvanced);
        WeaponPartInstance data = (WeaponPartInstance)UtilPresetParse.parsePartFromItem(stack);
        if (data == null) {
            return;
        }
        String id = data.getWeaponId();
        if (id.isEmpty()) {
            return;
        }
        tips.add((Component)UtilMCText.translatable((String)"info.dscombat.ammo").m_130946_(": " + (int)data.getCurrentAmmo() + "/" + ((WeaponPartStats)data.getStats()).getMaxAmmo()).m_6270_(Style.f_131099_.m_178520_(0xAAAAAA)));
        WeaponStats wd = WeaponPresets.get().get(id);
        if (wd == null) {
            return;
        }
        wd.addToolTips(tips, isAdvanced.m_7050_());
    }

    @Override
    protected void fillItemCategory(PartStats stats, NonNullList<ItemStack> items) {
        List<String> list = WeaponPresets.get().getCompatibleWeapons(stats.getId());
        for (String s : list) {
            this.addWeaponRack(stats, s, items);
        }
    }

    private void addWeaponRack(PartStats stats, String preset, NonNullList<ItemStack> items) {
        ItemStack rack = new ItemStack((ItemLike)this);
        if (stats != null) {
            rack.m_41751_(stats.createFilledPartInstance(preset).writeNBT());
        }
        items.add((Object)rack);
    }

    @Override
    public CreativeModeTab getCreativeTab() {
        return ModItems.WEAPON_PARTS;
    }

    @Override
    @NotNull
    public String getPreset(@NotNull ItemStack stack) {
        PartStats stats = UtilPresetParse.getPartStatsFromItem(stack);
        if (stats == null) {
            return this.getDefaultPartPresetId();
        }
        return stats.getId();
    }

    @NotNull
    public String getObjModelId(@NotNull String preset) {
        PartClientStats pcs = PartAssets.get().get(preset);
        if (pcs == null) {
            return "";
        }
        return pcs.getModelId();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ObjEntityModels.ModelOverrides getItemModelOverrides(@NotNull String preset) {
        PartClientStats pcs = PartAssets.get().get(preset);
        if (pcs == null) {
            return ObjEntityModels.NO_OVERRIDES;
        }
        return pcs.getItemModelOverrides();
    }
}

