/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.util;

import com.onewhohears.dscombat.common.network.toclient.ToClientDelayedSound;
import com.onewhohears.dscombat.util.UtilServerPacket;
import com.onewhohears.dscombat.util.forge.UtilSoundImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.phys.Vec3;

public class UtilSound {
    private static final Map<String, SoundEvent> cachedCustomSoundEvents = new HashMap<String, SoundEvent>();

    public static SoundEvent getSoundById(String id, SoundEvent alt) {
        if (id == null || id.isEmpty()) {
            return alt;
        }
        if (cachedCustomSoundEvents.containsKey(id)) {
            return cachedCustomSoundEvents.get(id);
        }
        SoundEvent event = UtilSound.getRegisteredSoundById(id, null);
        if (event == null) {
            SoundEvent sound = new SoundEvent(new ResourceLocation(id));
            cachedCustomSoundEvents.put(id, sound);
            return sound;
        }
        return event;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SoundEvent getRegisteredSoundById(String id, SoundEvent alt) {
        void var1_1;
        return UtilSoundImpl.getRegisteredSoundById(id, (SoundEvent)var1_1);
    }

    public static void sendDelayedSound(ServerLevel level, SoundEvent sound, Vec3 pos, float radius, float volume, float pitch) {
        List<ServerPlayer> players = UtilServerPacket.getPlayersWithinRadius(level, pos, radius);
        new ToClientDelayedSound(sound, pos, radius, volume, pitch).sendTo(players);
    }
}

