/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.util;

import com.mojang.authlib.GameProfile;
import com.onewhohears.dscombat.data.vehicle.physics.SeaLevels;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.wind_tunnel.EntityWindTunnel;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.dscombat.util.DSCFakePlayer;
import com.onewhohears.dscombat.util.forge.UtilVehicleEntityImpl;
import com.onewhohears.onewholibs.util.UtilEntity;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.utils.value.IntValue;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UtilVehicleEntity {
    private static final IntValue XP = new IntValue(){

        public void accept(int value) {
        }

        public int getAsInt() {
            return 0;
        }
    };
    public static final int WIND_TUNNEL_SEARCH_RANGE = 16;

    public static double getRadarCrossSectionalArea(Entity entity, Vec3 radarPos) {
        if (entity instanceof EntityVehicle) {
            EntityVehicle plane = (EntityVehicle)entity;
            return plane.getRadarArea(radarPos);
        }
        double area = entity.m_20206_() * entity.m_20205_();
        if (entity.m_6095_().m_204039_(ModTags.EntityTypes.VEHICLE)) {
            return Math.max(area, 1.0);
        }
        return area;
    }

    public static boolean isOnGroundOrWater(Entity entity) {
        Player p;
        if (entity.m_6095_().m_204039_(ModTags.EntityTypes.ALWAYS_GROUNDED)) {
            return true;
        }
        if (entity.m_20159_()) {
            Entity rv = entity.m_20201_();
            if (rv.m_6095_().m_204039_(ModTags.EntityTypes.ALWAYS_GROUNDED)) {
                return true;
            }
            if (rv.m_20096_() || UtilEntity.isHeadAboveWater((Entity)rv)) {
                return true;
            }
        }
        if (entity instanceof Player && (p = (Player)entity).m_21255_()) {
            return false;
        }
        if (!entity.m_20069_() && entity.m_20142_() && (double)entity.f_19789_ < 1.15) {
            return true;
        }
        return entity.m_20096_() || UtilEntity.isHeadAboveWater((Entity)entity);
    }

    public static double getAirDensity(Entity entity) {
        return SeaLevels.getAirPressure((ResourceKey<Level>)UtilEntity.getLevel((Entity)entity).m_46472_(), entity.m_20186_());
    }

    public static boolean hasPermissionToBreakBlock(BlockPos pos, BlockState state, Level level, @Nullable Entity entity, DSCFakePlayer type) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            EventResult result = ((BlockEvent.Break)BlockEvent.BREAK.invoker()).breakBlock(level, pos, state, player, XP);
            return !result.isPresent() || result.isTrue();
        }
        if (entity instanceof Enemy) {
            return level.m_46469_().m_46207_(GameRules.f_46132_);
        }
        if (!level.m_5776_()) {
            EventResult result = ((BlockEvent.Break)BlockEvent.BREAK.invoker()).breakBlock(level, pos, state, type.getPlayer((ServerLevel)level), XP);
            return !result.isPresent() || result.isTrue();
        }
        return false;
    }

    public static boolean vehicleHasPermissionToTrample(BlockPos pos, BlockState state, Level level, @Nullable Entity entity) {
        return UtilVehicleEntity.hasPermissionToBreakBlock(pos, state, level, entity, DSCFakePlayer.VEHICLE_TRAMPLE);
    }

    public static boolean weaponHasPermissionToBreak(BlockPos pos, BlockState state, Level level, @Nullable Entity entity) {
        return UtilVehicleEntity.hasPermissionToBreakBlock(pos, state, level, entity, DSCFakePlayer.WEAPON_BREAK);
    }

    public static Optional<EntityWindTunnel> findWindTunnel(Vec3 pos, Level level) {
        double r = 16.0;
        List tunnels = level.m_45976_(EntityWindTunnel.class, new AABB(pos.f_82479_ - r, pos.f_82480_ - r, pos.f_82481_ - r, pos.f_82479_ + r, pos.f_82480_ + r, pos.f_82481_ + r));
        if (tunnels.isEmpty()) {
            return Optional.empty();
        }
        return tunnels.stream().min((tunnel1, tunnel2) -> (int)(tunnel2.m_20238_(pos) - tunnel1.m_20238_(pos)));
    }

    public static int getDistFromGround(Entity entity, int limit, boolean ignoreWater) {
        BlockState block;
        int dist;
        Level l = UtilEntity.getLevel((Entity)entity);
        int[] pos = new int[]{entity.m_146903_(), entity.m_146904_(), entity.m_146907_()};
        for (dist = 0; pos[1] >= l.m_141937_() && dist <= limit && ((block = l.m_8055_(new BlockPos(pos[0], pos[1], pos[2]))) == null || block.m_60795_() || ignoreWater && !block.m_60767_().m_76334_()); ++dist) {
            pos[1] = pos[1] - 1;
        }
        return dist;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ServerPlayer createFakePlayer(ServerLevel level, GameProfile profile) {
        void var1_1;
        return UtilVehicleEntityImpl.createFakePlayer(level, (GameProfile)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void revive(Entity entity) {
        UtilVehicleEntityImpl.revive(entity);
    }

    public static boolean isExplosion(@NotNull DamageSource source) {
        return source.m_19372_();
    }

    public static boolean isFire(@NotNull DamageSource source) {
        return source.m_19384_();
    }

    public static boolean isBypassArmor(@NotNull DamageSource source) {
        return source.m_19376_();
    }

    public static boolean isProjectile(@NotNull DamageSource source) {
        return source.m_19360_();
    }
}

