/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.entityscreen;

import com.mojang.logging.LogUtils;
import com.onewhohears.dscombat.client.entityscreen.EntityScreenTypes;
import com.onewhohears.dscombat.data.vehicle.EntityScreenData;
import com.onewhohears.onewholibs.client.model.obj.ObjBakedModel;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import net.minecraft.class_1011;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3532;
import net.minecraft.class_777;
import org.slf4j.Logger;

public class VehicleScreenMapReader {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static List<EntityScreenData> generateScreens(class_2960 screenMap, String modelId, class_243 modelOffset) {
        List<VehicleScreenUV> vehicleScreenUVs = VehicleScreenMapReader.readVehicleScreenUVs(screenMap);
        return VehicleScreenMapReader.getVehicleScreenPos(modelId, vehicleScreenUVs, modelOffset);
    }

    private static List<VehicleScreenUV> readVehicleScreenUVs(class_2960 screenMap) {
        class_1011 image;
        class_310 m = class_310.method_1551();
        ArrayList<VehicleScreenUV> list = new ArrayList<VehicleScreenUV>();
        try {
            InputStream stream = ((class_3298)m.method_1478().method_14486(screenMap).get()).method_14482();
            image = class_1011.method_4309((InputStream)stream);
        }
        catch (NoSuchElementException e) {
            LOGGER.debug(screenMap.toString() + " does not exist. This vehicle won't have any screens.");
            return list;
        }
        catch (IOException e) {
            LOGGER.debug(screenMap.toString() + " not loaded. This vehicle won't have any screens.");
            return list;
        }
        for (int y = 0; y < image.method_4323(); ++y) {
            for (int x = 0; x < image.method_4307(); ++x) {
                int c;
                int screenType;
                int color = image.method_4315(x, y);
                if (class_1011.method_24030((int)color) == 0 || (screenType = EntityScreenTypes.getScreenTypeIdByColor(color)) == -1 || x != 0 && image.method_4315(x - 1, y) == color || y != 0 && image.method_4315(x, y - 1) == color) continue;
                int u0 = x;
                int u1 = x;
                int v0 = y;
                int v1 = y;
                int u = u0 + 1;
                while (u < image.method_4307() && (c = image.method_4315(u, v0)) == color) {
                    u1 = u++;
                }
                int v = v0 + 1;
                while (v < image.method_4323() && (c = image.method_4315(u0, v)) == color) {
                    v1 = v++;
                }
                VehicleScreenUV vsuv = new VehicleScreenUV(screenType, (float)u0 / (float)image.method_4307(), (float)(++u1) / (float)image.method_4307(), (float)v0 / (float)image.method_4323(), (float)(++v1) / (float)image.method_4323());
                list.add(vsuv);
                x = u1;
                LOGGER.debug("Found screen " + String.valueOf(vsuv) + " in " + screenMap.toString());
            }
        }
        return list;
    }

    private static List<EntityScreenData> getVehicleScreenPos(String modelId, List<VehicleScreenUV> vehicleScreenUVs, class_243 offset) {
        ArrayList<EntityScreenData> list = new ArrayList<EntityScreenData>();
        if (!ObjEntityModels.get().hasModel(modelId)) {
            LOGGER.warn("Obj Model " + modelId + " does not exist! No screens created.");
            return list;
        }
        ObjBakedModel model = ObjEntityModels.get().getBakedModel(modelId);
        for (VehicleScreenUV screenUV : vehicleScreenUVs) {
            VehicleScreenMapReader.findScreenPos(screenUV, model, list, offset);
        }
        return list;
    }

    private static void findScreenPos(VehicleScreenUV screenUV, ObjBakedModel model, List<EntityScreenData> list, class_243 offset) {
        List<class_777> middleQuads = VehicleScreenMapReader.findQuadsWithUV(model, screenUV.um, screenUV.vm);
        for (class_777 quad : middleQuads) {
            VehicleScreenMapReader.addScreenFromQuad(quad, list, screenUV, model, offset);
        }
    }

    private static void addScreenFromQuad(class_777 quad, List<EntityScreenData> list, VehicleScreenUV screenUV, ObjBakedModel model, class_243 offset) {
        class_241[] uvs = VehicleScreenMapReader.getUVs(quad);
        class_243[] corners = VehicleScreenMapReader.getQuadPositions(quad);
        class_243 pos = VehicleScreenMapReader.getWorldPos(screenUV.um, screenUV.vm, uvs, corners);
        float width = 0.05f;
        float height = 0.05f;
        float[] wh = VehicleScreenMapReader.getWidthHeight(uvs, corners, pos, screenUV);
        if (wh == null) {
            wh = VehicleScreenMapReader.getWidthHeightOtherQuad(pos, screenUV, model);
        }
        if (wh != null) {
            width = wh[0];
            height = wh[1];
        }
        class_243 normal = corners[2].method_1020(corners[0]).method_1036(corners[1].method_1020(corners[0])).method_1029();
        pos = pos.method_1019(offset).method_1020(normal.method_1021(0.001));
        LOGGER.debug("Found screen pos in model! Adding screen type " + screenUV.screenType + " at " + String.valueOf(pos));
        list.add(new EntityScreenData(screenUV.screenType, pos, width, height, UtilAngles.getPitch((class_243)normal), UtilAngles.getYaw((class_243)normal), 0.0f));
    }

    private static float[] getWidthHeightOtherQuad(class_243 pos, VehicleScreenUV screenUV, ObjBakedModel model) {
        List<class_777> cornerQuads = VehicleScreenMapReader.findQuadsWithUV(model, screenUV.u0, screenUV.v0);
        for (class_777 quad : cornerQuads) {
            class_243[] corners;
            class_241[] uvs = VehicleScreenMapReader.getUVs(quad);
            class_243 cornerPos = VehicleScreenMapReader.getWorldPos(screenUV.u0, screenUV.v0, uvs, corners = VehicleScreenMapReader.getQuadPositions(quad));
            if (cornerPos.method_1022(pos) > 1.0) continue;
            class_241 uvm = new class_241(screenUV.um, screenUV.vm);
            class_241 uvc = new class_241(screenUV.u0, screenUV.v0);
            return VehicleScreenMapReader.getWidthHeight(pos, cornerPos, uvm, uvc);
        }
        return null;
    }

    private static float[] getWidthHeight(class_241[] uvs, class_243[] corners, class_243 pos, VehicleScreenUV screenUV) {
        float[] wh = null;
        class_241 uvm = new class_241(screenUV.um, screenUV.vm);
        wh = VehicleScreenMapReader.getWidthHeight(uvs, corners, pos, uvm, new class_241(screenUV.u0, screenUV.v0));
        if (wh == null) {
            wh = VehicleScreenMapReader.getWidthHeight(uvs, corners, pos, uvm, new class_241(screenUV.u1, screenUV.v0));
        }
        if (wh == null) {
            wh = VehicleScreenMapReader.getWidthHeight(uvs, corners, pos, uvm, new class_241(screenUV.u0, screenUV.v1));
        }
        if (wh == null) {
            wh = VehicleScreenMapReader.getWidthHeight(uvs, corners, pos, uvm, new class_241(screenUV.u1, screenUV.v1));
        }
        return wh;
    }

    private static float[] getWidthHeight(class_241[] uvs, class_243[] corners, class_243 pos, class_241 uvm, class_241 uvc) {
        if (!VehicleScreenMapReader.hasUV(uvs, uvc.field_1343, uvc.field_1342)) {
            return null;
        }
        class_243 cornerPos = VehicleScreenMapReader.getWorldPos(uvc.field_1343, uvc.field_1342, uvs, corners);
        return VehicleScreenMapReader.getWidthHeight(pos, cornerPos, uvm, uvc);
    }

    private static float[] getWidthHeight(class_243 middlePos, class_243 cornerPos, class_241 uvm, class_241 uvc) {
        class_243 posDiff = middlePos.method_1020(cornerPos);
        class_241 uvDiff = uvm.method_35586(uvc.method_35588());
        float posLength = (float)posDiff.method_1033();
        float uvLength = uvDiff.method_35584();
        float scale = posLength / uvLength;
        float width = class_3532.method_15379((float)uvDiff.field_1343) * 2.0f * scale;
        float height = class_3532.method_15379((float)uvDiff.field_1342) * 2.0f * scale;
        return new float[]{width, height};
    }

    private static List<class_777> findQuadsWithUV(ObjBakedModel model, float u, float v) {
        ArrayList<class_777> quads = new ArrayList<class_777>();
        for (ObjBakedModel.Component component : model.getComponents()) {
            VehicleScreenMapReader.searchComponent(component, quads, u, v);
        }
        return quads;
    }

    private static void searchComponent(ObjBakedModel.Component component, List<class_777> quads, float u, float v) {
        for (ObjBakedModel.Mesh mesh : component.getMeshes()) {
            VehicleScreenMapReader.searchMesh(mesh, quads, u, v);
        }
        for (ObjBakedModel.Component childComponent : component.getChildren()) {
            VehicleScreenMapReader.searchComponent(childComponent, quads, u, v);
        }
    }

    private static void searchMesh(ObjBakedModel.Mesh mesh, List<class_777> quads, float u, float v) {
        for (class_777 quad : mesh.getQuads()) {
            VehicleScreenMapReader.searchQuad(quad, quads, u, v);
        }
    }

    private static void searchQuad(class_777 quad, List<class_777> quads, float u, float v) {
        if (VehicleScreenMapReader.hasUV(VehicleScreenMapReader.getUVs(quad), u, v)) {
            quads.add(quad);
        }
    }

    private static class_243 getWorldPos(float u, float v, class_241[] uvs, class_243[] corners) {
        class_241 uvg = new class_241(u, v);
        if (VehicleScreenMapReader.isUVsTri(uvs)) {
            return VehicleScreenMapReader.getWorldPosFromTri(uvg, uvs, corners);
        }
        class_241[] uvt1 = new class_241[]{uvs[0], uvs[1], uvs[2]};
        if (UtilGeometry.isIn2DTriangle((class_241)uvg, (class_241[])uvt1)) {
            return VehicleScreenMapReader.getWorldPosFromTri(uvg, uvt1, new class_243[]{corners[0], corners[1], corners[2]});
        }
        class_241[] uvt2 = new class_241[]{uvs[0], uvs[2], uvs[3]};
        return VehicleScreenMapReader.getWorldPosFromTri(uvg, uvt2, new class_243[]{corners[0], corners[2], corners[3]});
    }

    private static class_243 getWorldPosFromTri(class_241 uvg, class_241[] uvs, class_243[] corners) {
        class_241 Q = uvg;
        class_241 A = uvs[0];
        class_241 B = uvs[1];
        class_241 C = uvs[2];
        class_241 P = UtilGeometry.intersect((class_241)C, (class_241)Q, (class_241)B, (class_241)A);
        class_241 v = B.method_35586(A.method_35588());
        float t = 0.0f;
        float s = 0.0f;
        if (v.field_1343 != 0.0f) {
            t = P.method_35586((class_241)A.method_35588()).field_1343 / v.field_1343;
        } else if (v.field_1342 != 0.0f) {
            t = P.method_35586((class_241)A.method_35588()).field_1342 / v.field_1342;
        }
        class_241 u = P.method_35586(C.method_35588());
        if (u.field_1343 != 0.0f) {
            s = Q.method_35586((class_241)C.method_35588()).field_1343 / u.field_1343;
        } else if (u.field_1342 != 0.0f) {
            s = Q.method_35586((class_241)C.method_35588()).field_1342 / u.field_1342;
        }
        return corners[0].method_1021((double)((1.0f - t) * s)).method_1019(corners[1].method_1021((double)(t * s))).method_1019(corners[2].method_1021((double)(1.0f - s)));
    }

    private static class_243[] getQuadPositions(class_777 quad) {
        class_243[] pos = new class_243[4];
        for (int i = 0; i < 4; ++i) {
            pos[i] = new class_243((double)Float.intBitsToFloat(quad.method_3357()[i * 8]), (double)Float.intBitsToFloat(quad.method_3357()[i * 8 + 1]), (double)Float.intBitsToFloat(quad.method_3357()[i * 8 + 2]));
        }
        return pos;
    }

    private static class_241[] getUVs(class_777 quad) {
        class_241[] uvs = new class_241[4];
        for (int i = 0; i < 4; ++i) {
            uvs[i] = new class_241(Float.intBitsToFloat(quad.method_3357()[i * 8 + 4]), Float.intBitsToFloat(quad.method_3357()[i * 8 + 5]));
        }
        return uvs;
    }

    private static boolean hasUV(class_241[] uvs, float u, float v) {
        class_241 uv = new class_241(u, v);
        if (VehicleScreenMapReader.isUVsTri(uvs)) {
            return UtilGeometry.isIn2DTriangle((class_241)uv, (class_241[])uvs);
        }
        return UtilGeometry.isIn2DQuad((class_241)uv, (class_241[])uvs);
    }

    private static boolean isUVsTri(class_241[] uvs) {
        for (int i = 0; i < uvs.length; ++i) {
            for (int j = 0; j < uvs.length; ++j) {
                if (j == i || uvs[i].field_1343 != uvs[j].field_1343 || uvs[i].field_1342 != uvs[j].field_1342) continue;
                return true;
            }
        }
        return false;
    }

    public static class VehicleScreenUV {
        public final int screenType;
        public final float u0;
        public final float u1;
        public final float um;
        public final float v0;
        public final float v1;
        public final float vm;

        public VehicleScreenUV(int screenType, float u0, float u1, float v0, float v1) {
            this.screenType = screenType;
            this.u0 = u0;
            this.u1 = u1;
            this.um = (u0 + u1) / 2.0f;
            this.v0 = v0;
            this.v1 = v1;
            this.vm = (v0 + v1) / 2.0f;
        }

        public String toString() {
            return "[VehicleScreenUV|type:" + this.screenType + "|u0,u1,v0,v1:" + this.u0 + "," + this.u1 + "," + this.v0 + "," + this.v1 + "]";
        }
    }
}

