/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.entityscreen.instance;

import com.onewhohears.dscombat.client.entityscreen.instance.EntityDynamicScreenInstance;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.util.UtilRender;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public abstract class RadarScreenInstance
extends EntityDynamicScreenInstance {
    protected final int centerX;
    protected final int centerY;
    protected final int textureRadius;
    protected final int pingIconRadius;

    protected RadarScreenInstance(String path, int id, class_2960 baseTexture, int width, int height, int centerX, int centerY, int textureRadius, int pingIconRadius) {
        super(path, id, baseTexture, width, height);
        this.centerX = centerX;
        this.centerY = centerY;
        this.textureRadius = textureRadius;
        this.pingIconRadius = pingIconRadius;
    }

    @Override
    public void draw(class_1297 entity, class_4587 poseStack, class_4597 buffer, float partialTicks, int packedLight, float worldWidth, float worldHeight) {
        super.draw(entity, poseStack, buffer, partialTicks, packedLight, worldWidth, worldHeight);
        EntityVehicle vehicle = (EntityVehicle)entity;
        String radarMode = vehicle.getRadarMode().getTranslatable();
        UtilRender.drawText((class_2561)UtilMCText.translatable((String)radarMode), 0.28f, -0.48f, 0.2f, poseStack, buffer, 65280, packedLight);
    }

    @Override
    public boolean shouldUpdateTexture(class_1297 entity) {
        EntityVehicle vehicle = (EntityVehicle)entity;
        if (entity.field_6012 == this.prevUpdateTickCount) {
            return false;
        }
        if (entity.field_6012 % 2 != 0) {
            return false;
        }
        return entity.field_6012 - vehicle.radarSystem.clientPingRefreshTime <= 100;
    }

    protected void drawPing(RadarStats.RadarPing ping, EntityVehicle vehicle, boolean selected, boolean hover) {
        class_243 dp = ping.getPosForClient().method_1020(vehicle.method_19538());
        double dist = dp.method_37267();
        double screen_dist = this.getScreenDistRatio(dist);
        if (screen_dist > 1.0) {
            screen_dist = 1.0;
        }
        float yaw = (UtilAngles.getYaw((class_243)dp) - vehicle.method_36454() + 180.0f) * ((float)Math.PI / 180);
        int x = class_3532.method_15340((int)(this.centerX + (int)((double)(-class_3532.method_15374((float)yaw) * (float)this.textureRadius) * screen_dist)), (int)10, (int)(this.pixelWidth - 10));
        int y = class_3532.method_15340((int)(this.centerY + (int)((double)(class_3532.method_15362((float)yaw) * (float)this.textureRadius) * screen_dist)), (int)10, (int)(this.pixelHeight - 10));
        this.drawPingAtPos(ping, x, y, selected, hover);
    }

    protected double getScreenDistRatio(double distance) {
        return distance / DSCClientInputs.getRadarDisplayRange();
    }

    protected void drawPingAtPos(RadarStats.RadarPing ping, int x, int y, boolean selected, boolean hover) {
        int color = -16711936;
        if (selected) {
            color = -16776961;
        } else if (hover) {
            color = -16711681;
        } else if (ping.isFriendly) {
            color = -65536;
        } else if (ping.isShared()) {
            color = -5583514;
        }
        if (ping.entityType.isMissile()) {
            this.drawPlus(x, y, this.pingIconRadius / 2, 7, color);
        } else if (ping.terrainType.isGround()) {
            this.drawPlus(x, y, this.pingIconRadius, 5, color);
        } else if (ping.terrainType.isAir()) {
            this.drawCross(x, y, this.pingIconRadius, 7, color);
        } else {
            this.drawCross(x, y, this.pingIconRadius, 5, color);
            this.drawPlus(x, y, this.pingIconRadius, 5, color);
        }
        if (ping.isFriendly) {
            this.drawHollowCircle(x, y, this.pingIconRadius, 2, color);
        }
    }
}

