/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.input;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.ActionInput;
import com.onewhohears.dscombat.client.input.ActionInputHolder;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.input.fabric.ClientInputManagerImpl;
import com.onewhohears.dscombat.client.screen.VehicleMainScreen;
import com.onewhohears.dscombat.common.network.VehicleSyncAction;
import com.onewhohears.dscombat.common.network.toserver.ToServerSeatPos;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.data.radar.RadarSystem;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.parts.EntityGimbal;
import com.onewhohears.dscombat.entity.parts.EntityRidablePart;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.ModSounds;
import com.onewhohears.dscombat.util.UtilPrint;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5498;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

public class ClientInputManager {
    public static final float THROTTLE_CHANGE_RATE = 0.075f;
    private static final Map<String, ActionInputHolder.Button> buttons = new HashMap<String, ActionInputHolder.Button>();
    private static final Map<String, ActionInputHolder.Axis> axes = new HashMap<String, ActionInputHolder.Axis>();
    public static final ActionInputHolder.Axis THROTTLE = ClientInputManager.registerAxis("throttle", "throttle_down_key", "throttle_up_key");
    public static final ActionInputHolder.Axis PITCH = ClientInputManager.registerAxis("pitch", "pitch_down_key", "pitch_up_key");
    public static final ActionInputHolder.Axis ROLL = ClientInputManager.registerAxis("roll", "roll_left_key", "roll_right_key");
    public static final ActionInputHolder.Axis YAW = ClientInputManager.registerAxis("yaw", "yaw_left_key", "yaw_right_key");
    public static final ActionInputHolder.Button MOUSE_MODE = ClientInputManager.registerButton("mouse_mode", "mouse_mode_key");
    public static final ActionInputHolder.Button FLIP_CONTROLS = ClientInputManager.registerButton("flip_controls", "flip_controls_key");
    public static final ActionInputHolder.Button RESET_MOUSE = ClientInputManager.registerButton("reset_mouse", "reset_mouse_key");
    public static final ActionInputHolder.Button LEAN_LEFT = ClientInputManager.registerButton("lean_left", "lean_left_key");
    public static final ActionInputHolder.Button LEAN_RIGHT = ClientInputManager.registerButton("lean_right", "lean_right_key");
    public static final ActionInputHolder.Button TURN_ASSIST = ClientInputManager.registerButton("turn_assist", "turn_assist_key");
    public static final ActionInputHolder.Button CAMERA_TRACK_TARGET = ClientInputManager.registerButton("camera_track_target", "camera_track_target_key");
    public static final ActionInputHolder.Button VEHICLE_MENU = ClientInputManager.registerButton("vehicle_menu", "plane_menu_key");
    public static final ActionInputHolder.Button DISMOUNT = ClientInputManager.registerButton("dismount", "dismount_key");
    public static final ActionInputHolder.Button CHANGE_SEAT = ClientInputManager.registerButton("change_seat", "change_seat_key");
    public static final ActionInputHolder.Button LANDING_GEAR = ClientInputManager.registerButton("landing_gear", "landing_gear_key");
    public static final ActionInputHolder.Button GIMBAL = ClientInputManager.registerButton("gimbal", "gimbal_key");
    public static final ActionInputHolder.Button SPECIAL1 = ClientInputManager.registerButton("special1", "special_key");
    public static final ActionInputHolder.Button SPECIAL2 = ClientInputManager.registerButton("special2", "special_2_key");
    public static final ActionInputHolder.Button EJECT = ClientInputManager.registerButton("eject", "eject_key");
    public static final ActionInputHolder.Button SHOOT = ClientInputManager.registerButton("shoot", "shoot_key");
    public static final ActionInputHolder.Button WEAPON_CYCLE = ClientInputManager.registerButton("weapon_cycle", "weapon_select_key");
    public static final ActionInputHolder.Button WEAPON_CYCLE_INVERSE = ClientInputManager.registerButton("weapon_cycle_inverse", "weapon_select_up_key");
    public static final ActionInputHolder.Button FLARE = ClientInputManager.registerButton("flare", "flare_key");
    public static final ActionInputHolder.Button CHAFF = ClientInputManager.registerButton("chaff", "chaff_key");
    public static final ActionInputHolder.Button RADAR_MODE = ClientInputManager.registerButton("radar_mode", "radar_mode_key");
    public static final ActionInputHolder.Button PING_CYCLE = ClientInputManager.registerButton("ping_cycle", "ping_cycle_key");
    public static final ActionInputHolder.Button AFTERBURNER = ClientInputManager.registerButton("afterburner", "afterburner_toggle_key");
    private static int leftTicks = 0;
    private static long radarModeUpdateTime = 0L;
    private static float currentThrottle = 0.0f;
    private static boolean wasPilot = false;
    private static float smPitch = 0.0f;
    private static float smRoll = 0.0f;
    private static float smYaw = 0.0f;

    private static void pilotTick(@NotNull class_310 mc, @NotNull class_1657 player, @NotNull EntityVehicle vehicle) {
        boolean flipPitchThrottle;
        int invertPitch;
        if (MOUSE_MODE.isInitPressed()) {
            DSCClientInputs.cycleMouseMode();
        }
        if (RESET_MOUSE.isPressed()) {
            DSCClientInputs.centerMousePos();
            if (vehicle.isTestMode()) {
                player.method_36457(0.0f);
                player.method_36456(0.0f);
                vehicle.setClientQ(QuaternionF.ONE);
            }
        } else if (mc.field_1755 != null) {
            DSCClientInputs.centerMousePos();
        }
        boolean flare = FLARE.isPressed();
        boolean chaff = CHAFF.isPressed();
        if (AFTERBURNER.isInitPressed()) {
            DSCClientInputs.toggleAfterBurner();
        }
        if (TURN_ASSIST.isInitPressed()) {
            DSCClientInputs.toggleTurnAssist();
        }
        if (CAMERA_TRACK_TARGET.isInitPressed()) {
            DSCClientInputs.toggleCameraTrackTarget();
        }
        boolean flip = FLIP_CONTROLS.isPressed();
        boolean special = SPECIAL1.isPressed();
        boolean special2 = SPECIAL2.isPressed();
        int n = invertPitch = (Boolean)Config.CLIENT.invertY.get() != false ? 1 : -1;
        if (((VehicleStats)vehicle.getStats()).ignoreInvertY()) {
            invertPitch = -1;
        }
        float throttle = THROTTLE.getValue();
        float pitch = PITCH.getValue();
        float roll = ROLL.getValue();
        float yaw = YAW.getValue();
        boolean isBothRoll = ROLL.isNegAndPos();
        if (flip) {
            float temp = yaw;
            yaw = roll;
            roll = temp;
        }
        boolean type_flip = ((VehicleStats)vehicle.getStats()).flipPitchThrottle();
        boolean mode = DSCClientInputs.isCameraLockedForward();
        boolean bl = flipPitchThrottle = !type_flip && flip ^ mode || type_flip && !flip;
        if (flipPitchThrottle) {
            float temp = throttle;
            throttle = pitch;
            pitch = temp;
        }
        double mouseX = mc.field_1729.method_1603() - DSCClientInputs.getMouseCenterX();
        double mouseY = -(mc.field_1729.method_1604() - DSCClientInputs.getMouseCenterY());
        if (DSCClientInputs.isCameraLockedForward()) {
            int step;
            double ya = Math.abs(mouseY);
            double xa = Math.abs(mouseX);
            float ys = (float)Math.signum(mouseY) * (float)(-invertPitch);
            float xs = (float)Math.signum(mouseX);
            double max = (Double)Config.CLIENT.mouseModeMaxRadius.get();
            float stickStepsY = ((Integer)Config.CLIENT.mouseYSteps.get()).intValue();
            float stickStepsX = ((Integer)Config.CLIENT.mouseXSteps.get()).intValue();
            if (ya >= max) {
                pitch = ys;
            } else {
                step = (int)(ya / max * (double)stickStepsY * (double)ys);
                pitch = (float)step / stickStepsY;
            }
            if (xa >= max) {
                roll = xs;
            } else {
                step = (int)(xa / max * (double)stickStepsX * (double)xs);
                roll = (float)step / stickStepsX;
            }
            if (ClientInputManager.getMouseYVelocity(mc) == 0.0) {
                DSCClientInputs.setMouseCenterY((int)class_3532.method_15348((float)((float)DSCClientInputs.getMouseCenterY()), (float)((float)mc.field_1729.method_1604()), (float)((Double)Config.CLIENT.mouseYReturnRate.get()).floatValue()));
            }
            if (ClientInputManager.getMouseXVelocity(mc) == 0.0) {
                DSCClientInputs.setMouseCenterX((int)class_3532.method_15348((float)((float)DSCClientInputs.getMouseCenterX()), (float)((float)mc.field_1729.method_1603()), (float)((Double)Config.CLIENT.mouseXReturnRate.get()).floatValue()));
            }
        } else {
            pitch *= (float)invertPitch;
        }
        float zeroThrottle = ((VehicleStats)vehicle.getStats()).negativeThrottle ? 0.0f : -1.0f;
        if (!wasPilot && vehicle.cutThrottleOnNoPilot()) {
            currentThrottle = zeroThrottle;
        }
        if (ActionInput.isWindowActive()) {
            float incRate = vehicle.getThrottleIncreaseRate();
            float decRate = vehicle.getThrottleDecreaseRate();
            if (vehicle.inputs.isThrottleOverride(vehicle)) {
                float goal = vehicle.inputs.getGoalThrottle(vehicle);
                if (!((VehicleStats)vehicle.getStats()).negativeThrottle) {
                    goal = goal * 2.0f - 1.0f;
                }
                float step = goal >= currentThrottle ? incRate : decRate;
                currentThrottle = class_3532.method_15348((float)currentThrottle, (float)goal, (float)step);
            } else if (flipPitchThrottle && type_flip && THROTTLE.isJoystickController()) {
                currentThrottle = THROTTLE.getValue();
            } else if (!flipPitchThrottle && THROTTLE.isNegAndPos() || flipPitchThrottle && PITCH.isNegAndPos()) {
                currentThrottle = class_3532.method_15348((float)currentThrottle, (float)zeroThrottle, (float)decRate);
            } else if (!flipPitchThrottle && THROTTLE.isJoystickController() || flipPitchThrottle && PITCH.isJoystickController()) {
                currentThrottle = throttle;
            } else if (throttle > 0.0f) {
                currentThrottle = class_3532.method_15348((float)currentThrottle, (float)1.0f, (float)incRate);
            } else if (throttle < 0.0f) {
                currentThrottle = class_3532.method_15348((float)currentThrottle, (float)-1.0f, (float)incRate);
            }
        }
        if (((VehicleStats)vehicle.getStats()).isHeli() && ((Boolean)Config.CLIENT.enableHeliInputSmoothing.get()).booleanValue()) {
            float stepPitch = ((Double)Config.CLIENT.heliPitchSmoothingStep.get()).floatValue();
            float stepRoll = ((Double)Config.CLIENT.heliRollSmoothingStep.get()).floatValue();
            float stepYaw = ((Double)Config.CLIENT.heliYawSmoothingStep.get()).floatValue();
            smPitch = class_3532.method_15348((float)smPitch, (float)pitch, (float)stepPitch);
            smRoll = class_3532.method_15348((float)smRoll, (float)roll, (float)stepRoll);
            smYaw = class_3532.method_15348((float)smYaw, (float)yaw, (float)stepYaw);
            pitch = smPitch;
            roll = smRoll;
            yaw = smYaw;
        } else {
            smPitch = pitch;
            smRoll = roll;
            smYaw = yaw;
        }
        float t = ((VehicleStats)vehicle.getStats()).negativeThrottle ? currentThrottle : (currentThrottle + 1.0f) / 2.0f;
        vehicle.inputs.clientPilotControlsToServer(vehicle, t, pitch, roll, yaw, flare, chaff, DSCClientInputs.isAfterBurner(), special, special2, isBothRoll, DSCClientInputs.isCameraLockedForward(), DSCClientInputs.isTurnAssist());
        if (!DSCClientInputs.isCameraLockedForward()) {
            DSCClientInputs.centerMousePos();
        }
        if (LANDING_GEAR.isInitPressed()) {
            ClientInputManager.sendSyncAction(new VehicleSyncAction.LandingGearAction(vehicle.toggleLandingGear()));
        }
    }

    private static void passengerTick(@NotNull class_310 mc, @NotNull class_1657 player, @NotNull EntityVehicle vehicle, @NotNull EntityRidablePart seat) {
        boolean cycleRadarMode;
        boolean isRadarController = player.equals((Object)vehicle.getControllingPlayerOrBot());
        if (DSCClientInputs.disable3rdPersonVehicle) {
            mc.field_1690.method_31043(class_5498.field_26664);
        }
        if (player.field_6012 % (Integer)Config.CLIENT.syncSeatPosRate.get() == 0) {
            new ToServerSeatPos(seat.method_19538()).sendToServer();
        }
        if (CHANGE_SEAT.isInitPressed()) {
            ClientInputManager.sendSyncAction(new VehicleSyncAction.SwitchSeatAction());
        }
        int selectNextWeapon = 0;
        if (WEAPON_CYCLE_INVERSE.isInitPressed()) {
            selectNextWeapon = -1;
        } else if (WEAPON_CYCLE.isInitPressed()) {
            selectNextWeapon = 1;
        }
        vehicle.weaponSystem.selectNextWeapon(selectNextWeapon);
        RadarSystem radar = vehicle.radarSystem;
        if (DSCClientInputs.isRadarHovering() && leftTicks == 1) {
            List<RadarStats.RadarPing> pings = radar.getClientRadarPings();
            if (DSCClientInputs.getRadarHoverIndex() < pings.size()) {
                radar.clientSelectTarget(pings.get(DSCClientInputs.getRadarHoverIndex()));
            }
        }
        if (PING_CYCLE.isInitPressed()) {
            radar.clientSelectNextTarget();
        }
        if (SHOOT.isPressed() && ClientInputManager.playerCanShoot(player)) {
            ClientInputManager.sendSyncAction(new VehicleSyncAction.ShootAction(vehicle.weaponSystem.getSelectedIndex(), radar.getClientSelectedPing(), ClientInputManager.getShootPos(player, vehicle)));
        }
        if (((Boolean)Config.CLIENT.customDismount.get()).booleanValue() && DISMOUNT.isPressed()) {
            ClientInputManager.sendSyncAction(new VehicleSyncAction.DismountAction());
        }
        if (EJECT.isInitPressed()) {
            if (seat.canEject()) {
                seat.useEject();
                ClientInputManager.sendSyncAction(new VehicleSyncAction.DismountAction(true));
                UtilEntity.getLevel((class_1297)player).method_8486(player.method_23317(), player.method_23318(), player.method_23321(), ModSounds.EJECT_WIND, class_3419.field_15248, 0.5f, 1.0f, false);
            } else {
                ClientInputManager.sendSyncAction(new VehicleSyncAction.DismountAction(false));
            }
        }
        if (cycleRadarMode = RADAR_MODE.isInitPressed()) {
            DSCClientInputs.cyclePreferredRadarMode();
            if (!isRadarController) {
                player.method_7353((class_2561)UtilMCText.translatable((String)"info.dscombat.not_radar_controller"), true);
            }
        }
        if (isRadarController && DSCClientInputs.getPreferredRadarMode() != vehicle.getRadarMode() && class_156.method_658() - radarModeUpdateTime > 500L) {
            ClientInputManager.sendSyncAction(new VehicleSyncAction.SetRadarModeAction(DSCClientInputs.getPreferredRadarMode()));
            radarModeUpdateTime = class_156.method_658();
        }
        if (GIMBAL.isInitPressed()) {
            DSCClientInputs.toggleGimbalMode();
        }
        if (VEHICLE_MENU.isInitPressed()) {
            mc.method_1507((class_437)new VehicleMainScreen());
        }
        boolean leanLeft = LEAN_LEFT.isInitPressed();
        boolean leanRight = LEAN_RIGHT.isInitPressed();
        if (leanLeft && leanRight) {
            DSCClientInputs.leanNot();
        } else if (leanLeft) {
            DSCClientInputs.leanLeft();
        } else if (leanRight) {
            DSCClientInputs.leanRight();
        }
    }

    private static void tickActions() {
        buttons.forEach((id, action) -> action.tick());
        axes.forEach((id, action) -> action.tick());
    }

    public static void clientTickFirst() {
        class_1297 class_12972;
        ClientInputManager.tickActions();
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            if (wasPilot) {
                smYaw = 0.0f;
                smRoll = 0.0f;
                smPitch = 0.0f;
            }
            wasPilot = false;
            return;
        }
        if (!player.method_5765() || !((class_12972 = player.method_5668()) instanceof EntityVehicle)) {
            if (wasPilot) {
                smYaw = 0.0f;
                smRoll = 0.0f;
                smPitch = 0.0f;
            }
            wasPilot = false;
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)class_12972;
        class_1297 controller = vehicle.method_5642();
        if (controller == null || !controller.equals((Object)player)) {
            if (wasPilot) {
                smYaw = 0.0f;
                smRoll = 0.0f;
                smPitch = 0.0f;
            }
            wasPilot = false;
            return;
        }
        ClientInputManager.pilotTick(mc, (class_1657)player, vehicle);
        wasPilot = true;
    }

    public static void clientTickSecond() {
        class_310 mc = class_310.method_1551();
        leftTicks = mc.field_1729.method_1608() ? ++leftTicks : 0;
        class_746 player = mc.field_1724;
        if (player == null || !player.method_5765()) {
            return;
        }
        class_1297 class_12972 = player.method_5854();
        if (!(class_12972 instanceof EntityRidablePart)) {
            return;
        }
        EntityRidablePart seat = (EntityRidablePart)class_12972;
        EntityVehicle vehicle = seat.getParentVehicle();
        if (vehicle == null) {
            return;
        }
        ClientInputManager.passengerTick(mc, (class_1657)player, vehicle, seat);
    }

    public static void sendSyncAction(VehicleSyncAction action) {
        VehicleSyncAction.sendSyncAction(action);
    }

    public static class_243 getShootPos(class_1657 player, EntityVehicle vehicle) {
        switch (DSCClientInputs.getTargetMode()) {
            case LOOK: {
                return ClientInputManager.getLookPos(player, vehicle);
            }
            case COORDS: {
                return Config.CLIENT.getTargetPos();
            }
            case INDICATOR: {
                return class_243.field_1353;
            }
        }
        return class_243.field_1353;
    }

    public static class_243 getLookPos(class_1657 player, EntityVehicle vehicle) {
        EntityGimbal gimbal;
        Object looker = player;
        if (DSCClientInputs.isGimbalMode() && (gimbal = vehicle.getGimbalForPilotCamera()) != null) {
            looker = gimbal;
            looker.method_36457(player.method_36455());
            looker.method_36456(player.method_36454());
        }
        return UtilEntity.getLookingAtBlockPos((class_1297)looker, (int)300);
    }

    private static boolean playerCanShoot(class_1657 player) {
        return System.currentTimeMillis() - DSCClientInputs.getClientMountTime() > 500L && (!player.method_6115() || player.method_5998(player.method_6058()).method_31574(class_1802.field_8255));
    }

    public static ActionInputHolder.Button registerButton(String id, String defaultKey) {
        ActionInputHolder.Button holder = new ActionInputHolder.Button(id, new ActionInput.DSCKeyButton(defaultKey));
        buttons.put(id, holder);
        return holder;
    }

    public static ActionInputHolder.Axis registerAxis(String id, String defaultNegKey, String defaultPosKey) {
        ActionInputHolder.Axis holder = new ActionInputHolder.Axis(id, new ActionInput.DSCKeyAxis(defaultNegKey, defaultPosKey));
        axes.put(id, holder);
        return holder;
    }

    public static int getNumButtons() {
        return buttons.size();
    }

    public static int getNumAxes() {
        return axes.size();
    }

    public static int getNumActions() {
        return ClientInputManager.getNumButtons() + ClientInputManager.getNumAxes();
    }

    public static Collection<ActionInputHolder.Button> getButtons() {
        return buttons.values();
    }

    public static Collection<ActionInputHolder.Axis> getAxes() {
        return axes.values();
    }

    public static void saveKeyBinds() {
        JsonObject json = new JsonObject();
        buttons.forEach((id, action) -> json.add(id, (JsonElement)action.write()));
        axes.forEach((id, action) -> json.add(id, (JsonElement)action.write()));
        UtilPrint.printJsonClientDirectory("dscombat/config/action_key_binds.json", json);
    }

    public static void loadKeyBinds() {
        JsonObject json = UtilPrint.readJsonClientDirectory("dscombat/config/action_key_binds.json");
        buttons.forEach((id, action) -> {
            JsonObject data = UtilParse.getJsonSafe((JsonObject)json, (String)id);
            String type = UtilParse.getStringSafe((JsonObject)data, (String)"type", (String)"");
            if (!type.equals("button")) {
                return;
            }
            action.read(data);
        });
        axes.forEach((id, action) -> {
            JsonObject data = UtilParse.getJsonSafe((JsonObject)json, (String)id);
            String type = UtilParse.getStringSafe((JsonObject)data, (String)"type", (String)"");
            if (!type.equals("axis")) {
                return;
            }
            action.read(data);
        });
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static double getMouseYVelocity(class_310 mc) {
        return ClientInputManagerImpl.getMouseYVelocity(mc);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static double getMouseXVelocity(class_310 mc) {
        return ClientInputManagerImpl.getMouseXVelocity(mc);
    }
}

