/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.onewhohears.dscombat.client.overlay.OverlayController;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.data.radar.RadarSystem;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.math.Mat4f;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import com.onewhohears.onewholibs.util.math.Vec3f;
import net.minecraft.class_1159;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AimAssistOverlay
extends VehicleOverlayComponent {
    public static final class_2960 AIM_HUD = new class_2960("dscombat", "textures/ui/aim_hud.png");
    public static final int AIM_SIZE = 10;
    protected static float PARTIAL_TICK;
    private class_243 targetWorldPos = null;
    private int prevTick = 0;

    @Override
    protected boolean shouldRender(class_329 gui, class_4587 poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (AimAssistOverlay.defaultRenderConditions()) {
            return false;
        }
        class_1297 class_12972 = AimAssistOverlay.getPlayerRootVehicle();
        if (!(class_12972 instanceof EntityVehicle)) {
            return false;
        }
        EntityVehicle vehicle = (EntityVehicle)class_12972;
        RadarSystem radar = vehicle.radarSystem;
        if (!radar.hasRadar()) {
            return false;
        }
        WeaponInstance<?> data = vehicle.weaponSystem.getSelected();
        if (data == null) {
            return false;
        }
        return ((WeaponStats)data.getStats()).isAimAssist();
    }

    @Override
    protected void render(class_329 gui, class_4587 stack, float partialTick, int screenWidth, int screenHeight) {
        class_1297 class_12972 = AimAssistOverlay.getPlayerRootVehicle();
        if (!(class_12972 instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)class_12972;
        WeaponInstance<?> data = vehicle.weaponSystem.getSelected();
        if (vehicle.field_6012 != this.prevTick) {
            assert (data != null);
            this.targetWorldPos = this.calcTargetWorldPos(vehicle, data);
        }
        this.prevTick = vehicle.field_6012;
        if (this.targetWorldPos == null) {
            return;
        }
        class_4184 cam = class_310.method_1551().field_1773.method_19418();
        class_243 view = cam.method_19326();
        float z_rot = UtilAngles.lerpAngle((float)PARTIAL_TICK, (float)vehicle.zRotO, (float)vehicle.zRot);
        stack.method_22903();
        QuaternionF q = Vec3f.ZP.rotationDegrees(z_rot);
        q.mul(Vec3f.XP.rotationDegrees(cam.method_19329()));
        q.mul(Vec3f.YP.rotationDegrees(cam.method_19330() + 180.0f));
        stack.method_22907(q.convert());
        stack.method_22904(-view.field_1352, -view.field_1351, -view.field_1350);
        Mat4f view_mat = Mat4f.from((class_1159)stack.method_23760().method_23761().method_22673());
        stack.method_22909();
        Mat4f proj_mat = OverlayController.PROJECTION_MATRIX;
        float[] screen_pos = UtilGeometry.worldToScreenPos((class_243)this.targetWorldPos, (Mat4f)view_mat, (Mat4f)proj_mat, (int)screenWidth, (int)screenHeight);
        if (screen_pos[0] < 0.0f || screen_pos[1] < 0.0f) {
            return;
        }
        float x_win = screen_pos[0];
        float y_win = screen_pos[1];
        float adj = 5.0f;
        float x_pos = x_win - adj;
        float y_pos = y_win - adj;
        this.drawCrossHair(stack, x_pos, y_pos);
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_aim_assist";
    }

    protected void drawCrossHair(class_4587 poseStack, float x_pos, float y_pos) {
        poseStack.method_22903();
        poseStack.method_22904((double)x_pos, (double)y_pos, 0.0);
        RenderSystem.setShaderTexture((int)0, (class_2960)AIM_HUD);
        AimAssistOverlay.method_25290((class_4587)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)10, (int)10, (int)10, (int)10);
        poseStack.method_22909();
    }

    @Nullable
    protected class_243 calcTargetWorldPos(EntityVehicle vehicle, WeaponInstance<?> data) {
        return data.estimateImpactPosition(vehicle);
    }
}

