/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilParse;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import net.minecraft.class_243;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;

public class DebugOverlay
extends VehicleOverlayComponent {
    @Override
    protected boolean shouldRender(class_329 gui, class_4587 poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (DebugOverlay.defaultRenderConditions()) {
            return false;
        }
        return DebugOverlay.getPlayerRootVehicle() instanceof EntityVehicle && (Boolean)Config.CLIENT.debugMode.get() != false;
    }

    @Override
    protected void render(class_329 gui, class_4587 stack, float partialTick, int screenWidth, int screenHeight) {
        EntityVehicle vehicle = (EntityVehicle)DebugOverlay.getPlayerRootVehicle();
        assert (vehicle != null);
        int color = 65280;
        int space = 160;
        DebugOverlay.method_25303((class_4587)stack, (class_327)FONT, (String)("V" + UtilParse.prettyVec3((class_243)vehicle.method_18798(), (int)2)), (int)(screenWidth - space), (int)0, (int)color);
        DebugOverlay.method_25303((class_4587)stack, (class_327)FONT, (String)("F" + UtilParse.prettyVec3((class_243)vehicle.forces, (int)2)), (int)(screenWidth - space), (int)10, (int)color);
        DebugOverlay.method_25303((class_4587)stack, (class_327)FONT, (String)("A" + UtilParse.prettyVec3((class_243)vehicle.getAngularVel(), (int)2)), (int)(screenWidth - space), (int)20, (int)color);
        DebugOverlay.method_25303((class_4587)stack, (class_327)FONT, (String)("M" + UtilParse.prettyVec3((class_243)vehicle.getMoment(), (int)2)), (int)(screenWidth - space), (int)30, (int)color);
        DebugOverlay.method_25303((class_4587)stack, (class_327)FONT, (String)("Q" + UtilParse.prettyQ((QuaternionF)vehicle.getClientQ(), (int)2)), (int)(screenWidth - space), (int)40, (int)color);
        DebugOverlay.method_25303((class_4587)stack, (class_327)FONT, (String)("YR: " + String.format("%3.2f", Float.valueOf(vehicle.getYawRate() * 20.0f)) + " TR: " + String.format("%3.2f", Float.valueOf(vehicle.getActualTurnRadius()))), (int)(screenWidth - space), (int)50, (int)color);
        QuaternionF q = vehicle.getClientQ();
        class_243 thrust = vehicle.getThrustForce(q);
        class_243 drag = vehicle.calcTotalDrag(q);
        class_243 lift = vehicle.calcTotalLift(q);
        double weight = vehicle.getWeightForce().field_1351;
        double forceY = thrust.field_1351 + drag.field_1351 + lift.field_1351 + weight;
        double thrustDragXZ = thrust.method_37267() - drag.method_37267();
        double tdXZAcc = vehicle.getAccFromForce(thrustDragXZ, true) * 1000.0;
        DebugOverlay.method_25303((class_4587)stack, (class_327)FONT, (String)("FY: " + String.format("%3.1f", forceY)), (int)(screenWidth - space), (int)60, (int)color);
        DebugOverlay.method_25303((class_4587)stack, (class_327)FONT, (String)("FTD_XZ: " + String.format("%3.1f", thrustDragXZ) + " ATD_XZ: " + String.format("%3.3f", tdXZAcc)), (int)(screenWidth - space), (int)70, (int)color);
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_debug";
    }
}

