/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.client.overlay.components.VehicleControlOverlay;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import java.awt.Color;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;

public class VehicleStatsOverlay
extends VehicleOverlayComponent {
    public static final Color GREEN_ME_SAY_ALONE_RAMP = new Color(0, 255, 0);
    public static final Color RED = new Color(255, 0, 0);
    public static final float START = 0.6f;
    public static final float END = 0.1f;
    public static final float CHANGE_G = (float)GREEN_ME_SAY_ALONE_RAMP.getGreen() / 0.5f;
    public static final float CHANGE_R = (float)RED.getRed() / 0.5f;

    public static int getHealthColor(float health, float max) {
        float healthPercent = health / max;
        if (healthPercent >= 0.6f) {
            return GREEN_ME_SAY_ALONE_RAMP.getRGB();
        }
        if (healthPercent < 0.6f && healthPercent > 0.1f) {
            return new Color((int)(CHANGE_R * (0.6f - healthPercent)), (int)(CHANGE_G * (healthPercent - 0.1f)), 0).getRGB();
        }
        return RED.getRGB();
    }

    @Override
    protected boolean shouldRender(class_329 gui, class_4587 poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (VehicleStatsOverlay.defaultRenderConditions()) {
            return false;
        }
        if (((Boolean)Config.CLIENT.enableModernHUD.get()).booleanValue()) {
            return false;
        }
        if (!(VehicleStatsOverlay.getPlayerRootVehicle() instanceof EntityVehicle)) {
            return false;
        }
        return !DSCClientInputs.isCameraLockedForward();
    }

    @Override
    protected void render(class_329 gui, class_4587 poseStack, float partialTick, int screenWidth, int screenHeight) {
        EntityVehicle vehicle = (EntityVehicle)VehicleStatsOverlay.getPlayerRootVehicle();
        assert (vehicle != null);
        int xOrigin = screenWidth - 60 - 1;
        int yOrigin = screenHeight - 60 - 3 - 40 - 10;
        if (vehicle.isAircraft()) {
            yOrigin -= VehicleControlOverlay.PEDAL_HEIGHT;
        }
        VehicleStatsOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)("m/s: " + String.format("%3.1f", vehicle.method_18798().method_1033() * 20.0)), (int)xOrigin, (int)yOrigin, (int)65280);
        VehicleStatsOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)("A: " + vehicle.getAltitude()), (int)xOrigin, (int)(yOrigin - 10), (int)65280);
        float health = vehicle.getHealth();
        float maxHealth = vehicle.getMaxHealth();
        VehicleStatsOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)("H: " + (int)health + "/" + (int)maxHealth), (int)xOrigin, (int)(yOrigin - 20), (int)VehicleStatsOverlay.getHealthColor(health, maxHealth));
        float armor = vehicle.getArmor();
        float maxArmor = vehicle.getMaxTotalArmor();
        VehicleStatsOverlay.method_25303((class_4587)poseStack, (class_327)FONT, (String)("S: " + (int)armor + "/" + (int)maxArmor), (int)xOrigin, (int)(yOrigin - 30), (int)VehicleStatsOverlay.getHealthColor(armor, maxArmor));
        VehicleStatsOverlay.method_25300((class_4587)poseStack, (class_327)FONT, (String)("[" + vehicle.method_31477() + "," + vehicle.method_31478() + "," + vehicle.method_31479() + "]"), (int)(screenWidth / 2), (int)0, (int)65280);
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_stats";
    }
}

