/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.renderer;

import com.onewhohears.dscombat.client.model.obj.ObjVehicleModel;
import com.onewhohears.dscombat.data.vehicle.client.VehicleClientStats;
import com.onewhohears.dscombat.data.vehicle.physics.PhysicsComponentData;
import com.onewhohears.dscombat.data.vehicle.physics.PhysicsComponentInstance;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.wind_tunnel.EntityWindTunnel;
import com.onewhohears.dscombat.util.UtilRender;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import com.onewhohears.onewholibs.util.math.Mat3f;
import com.onewhohears.onewholibs.util.math.Mat4f;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.Vec3f;
import net.minecraft.class_1159;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;

public class RendererWindTunnel
extends class_897<EntityWindTunnel> {
    public static final class_2960 ARROW_TXT = new class_2960("dscombat", "textures/misc/arrow.png");
    private static final class_1921 ARROW = class_1921.method_23028((class_2960)ARROW_TXT);
    private static final float ARROW_LENGTH_SCALE = 10.0f;

    public RendererWindTunnel(class_5617.class_5618 ctx) {
        super(ctx);
    }

    public void render(@NotNull EntityWindTunnel entity, float yaw, float partialTicks, @NotNull class_4587 poseStack, @NotNull class_4597 buffer, int packedLight) {
        if (entity.getSimulatedVehicle().getClientStatsHolder() == null) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_22904(0.0, 4.0, 0.0);
        this.drawGlobalAxis(partialTicks, poseStack, buffer, packedLight);
        if (!entity.getHideModel()) {
            ObjVehicleModel model = (ObjVehicleModel)((VehicleClientStats)entity.getSimulatedVehicle().getClientStatsHolder().get()).getModel();
            model.render((class_1297)entity.getSimulatedVehicle(), poseStack, buffer, packedLight, partialTicks);
            ObjEntityModels.ModelOverrides overrides = model.getModelOverride();
            poseStack.method_22904((double)(-overrides.translate.x()), (double)(-overrides.translate.y()), (double)(-overrides.translate.z()));
        } else {
            poseStack.method_22907(entity.getQ().convert());
        }
        this.drawAccs(entity, partialTicks, poseStack, buffer, packedLight);
        poseStack.method_22909();
    }

    private void drawAccs(@NotNull EntityWindTunnel entity, float partialTicks, @NotNull class_4587 poseStack, @NotNull class_4597 buffer, int packedLight) {
        poseStack.method_22903();
        EntityVehicle vehicle = entity.getSimulatedVehicle();
        QuaternionF q = vehicle.getQBySide();
        QuaternionF qi = vehicle.getQBySide();
        qi.conj();
        poseStack.method_22907(qi.convert());
        float maxForceMag = (float)entity.weightAcc.method_1033();
        this.drawAcc(poseStack, buffer, packedLight, UtilRender.WHITE, maxForceMag, class_243.field_1353, entity.totalAcc);
        this.drawAcc(poseStack, buffer, packedLight, UtilRender.BLACK, maxForceMag, class_243.field_1353, entity.weightAcc);
        this.drawAcc(poseStack, buffer, packedLight, UtilRender.BLUE, maxForceMag, class_243.field_1353, entity.thrustAcc);
        this.drawAcc(poseStack, buffer, packedLight, UtilRender.RED, maxForceMag, class_243.field_1353, entity.dragAcc);
        this.drawAcc(poseStack, buffer, packedLight, UtilRender.GREEN, maxForceMag, class_243.field_1353, entity.liftAcc);
        for (PhysicsComponentInstance<?> phy : vehicle.getPhysicsInstances()) {
            class_243 pos = UtilAngles.rotateVector((class_243)((PhysicsComponentData)phy.getData()).getPos(), (QuaternionF)q);
            this.drawAcc(poseStack, buffer, packedLight, UtilRender.YELLOW, maxForceMag, pos, vehicle.getAccFromForce(phy.getDragForce()));
            this.drawAcc(poseStack, buffer, packedLight, UtilRender.CYAN, maxForceMag, pos, vehicle.getAccFromForce(phy.getLiftForce()));
        }
        poseStack.method_22909();
    }

    private void drawAcc(@NotNull class_4587 poseStack, @NotNull class_4597 buffer, int packedLight, int[] color, float maxForceMag, class_243 pos, class_243 force) {
        float mag = (float)force.method_1033();
        class_243 dir = mag < 0.001f ? force.method_1021(1000.0).method_1029() : force.method_1029();
        this.drawAcc(poseStack, buffer, packedLight, color, pos, dir, mag / maxForceMag * 10.0f);
    }

    private void drawAcc(@NotNull class_4587 poseStack, @NotNull class_4597 buffer, int packedLight, int[] color, class_243 pos, class_243 dir, float mag) {
        poseStack.method_22903();
        poseStack.method_22904(pos.field_1352, pos.field_1351, pos.field_1350);
        float y = UtilAngles.getYaw((class_243)dir);
        float x = UtilAngles.getPitch((class_243)dir);
        QuaternionF q1 = Vec3f.YN.rotationDegrees(y + 180.0f);
        q1.mul(Vec3f.XN.rotationDegrees(x - 90.0f));
        poseStack.method_22907(q1.convert());
        poseStack.method_22904(0.0, (double)(-mag) * 0.5, 0.0);
        poseStack.method_22905(1.0f, mag, 1.0f);
        for (int i = 0; i < 4; ++i) {
            poseStack.method_22907(Vec3f.YN.rotationDegrees((float)(90 * i)).convert());
            UtilRender.drawTextureCentered(ARROW, Mat4f.from((class_1159)poseStack.method_23760().method_23761()), buffer, packedLight, 0.0f, color);
        }
        poseStack.method_22909();
    }

    private void drawGlobalAxis(float partialTicks, @NotNull class_4587 poseStack, @NotNull class_4597 buffer, int packedLight) {
        class_4588 buff = buffer.getBuffer(class_1921.method_23594());
        Vec3f O = new Vec3f();
        Vec3f X = new Vec3f(8.0f, 0.0f, 0.0f);
        Vec3f Y = new Vec3f(0.0f, 8.0f, 0.0f);
        Vec3f Z = new Vec3f(0.0f, 0.0f, 8.0f);
        Mat4f m4 = Mat4f.from((class_1159)poseStack.method_23760().method_23761());
        Mat3f m3 = Mat3f.from((class_4581)poseStack.method_23760().method_23762());
        UtilRender.drawLine(O, X, buff, m4, m3, UtilRender.RED);
        UtilRender.drawLine(O, Y, buff, m4, m3, UtilRender.GREEN);
        UtilRender.drawLine(O, Z, buff, m4, m3, UtilRender.BLUE);
    }

    @NotNull
    public class_2960 getTextureLocation(@NotNull EntityWindTunnel entity) {
        return null;
    }
}

