/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.screen.VehicleSubScreen;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.data.radar.RadarSystem;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilScreen;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1937;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_474;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5676;
import org.jetbrains.annotations.NotNull;

public class VehicleRadarScreen
extends VehicleSubScreen {
    public static final class_2960 BG_TEXTURE = new class_2960("dscombat", "textures/ui/background/vehicle_radar_screen.png");
    public static final class_2960 RADAR_BG = new class_2960("dscombat", "textures/ui/radar.png");
    public static final class_2960 RADAR_PING = new class_2960("dscombat", "textures/ui/hud_ping.png");
    public static final class_2960 RADAR_PING_HOVER = new class_2960("dscombat", "textures/ui/hud_ping_hover.png");
    public static final class_2960 RADAR_PING_SELECT = new class_2960("dscombat", "textures/ui/hud_ping_select.png");
    public static final class_2960 PING_DATA = new class_2960("dscombat", "textures/ui/ping_data_icons_color.png");
    private static final int imageWidth = 240;
    private static final int imageHeight = 180;
    private static final int textureSize = 256;
    private static final int PING_SIZE = 6;
    private int leftTicks = 0;
    private static final int HALF_PS = 3;
    private static final int SQUARE_PS = 14;
    private static final int LEFT = 9;
    private static final int UP = 13;

    protected VehicleRadarScreen() {
        super("screen.dscombat.vehicle_radar_screen", BG_TEXTURE, 240, 180, 256, 256);
    }

    public void method_25394(@NotNull class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        super.method_25394(poseStack, mouseX, mouseY, partialTick);
        this.renderRadar(poseStack, mouseX, mouseY, partialTick);
    }

    protected void renderRadar(@NotNull class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)RADAR_BG);
        VehicleRadarScreen.method_25293((class_4587)poseStack, (int)(this.guiX + 4), (int)(this.guiY + 66), (int)110, (int)110, (float)0.0f, (float)0.0f, (int)127, (int)128, (int)127, (int)128);
        EntityVehicle vehicle = this.getVehicle();
        RadarSystem radar = vehicle.radarSystem;
        List<RadarStats.RadarPing> pings = radar.getClientRadarPings();
        if (pings.isEmpty()) {
            return;
        }
        int selected = radar.getClientSelectedPingIndex();
        int hover = DSCClientInputs.getRadarHoverIndex();
        int centerX = this.guiX + 4 + 55;
        int centerY = this.guiY + 66 + 55;
        boolean hovering = false;
        for (int i = 0; i < pings.size(); ++i) {
            int y;
            float yaw;
            int x;
            RadarStats.RadarPing ping = pings.get(i);
            class_243 dp = ping.getPosForClient().method_1020(vehicle.method_19538());
            double dist = dp.method_37267();
            double screen_dist = this.getScreenDistRatio(dist);
            if (screen_dist > 1.0) {
                screen_dist = 1.0;
            }
            if (!this.drawPingAtPos(ping, x = class_3532.method_15340((int)((int)((double)(-class_3532.method_15374((float)(yaw = (UtilAngles.getYaw((class_243)dp) - vehicle.method_36454() + 180.0f) * ((float)Math.PI / 180))) * 55.0f) * screen_dist)), (int)-50, (int)50) + centerX, y = class_3532.method_15340((int)((int)((double)(class_3532.method_15362((float)yaw) * 55.0f) * screen_dist)), (int)-50, (int)50) + centerY, i == selected, i == hover, poseStack, mouseX, mouseY, partialTick, vehicle)) continue;
            DSCClientInputs.setRadarHoverIndex(i);
            hovering = true;
        }
        if (!hovering) {
            DSCClientInputs.resetRadarHoverIndex();
        }
    }

    protected boolean drawPingAtPos(RadarStats.RadarPing ping, int x, int y, boolean selected, boolean hover, @NotNull class_4587 poseStack, int mouseX, int mouseY, float partialTick, EntityVehicle vehicle) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (selected) {
            RenderSystem.setShaderTexture((int)0, (class_2960)RADAR_PING_SELECT);
        } else if (hover) {
            RenderSystem.setShaderTexture((int)0, (class_2960)RADAR_PING_HOVER);
        } else {
            RenderSystem.setShaderTexture((int)0, (class_2960)RADAR_PING);
        }
        VehicleRadarScreen.method_25293((class_4587)poseStack, (int)(x - 3), (int)(y - 3), (int)6, (int)6, (float)0.0f, (float)0.0f, (int)200, (int)200, (int)200, (int)200);
        class_241 class_2412 = new class_241((float)x, (float)y);
        class_241 class_2413 = new class_241((float)mouseX, (float)mouseY);
        if (class_2412.method_35589(class_2413) > 14.0f) {
            return false;
        }
        int dist = (int)ping.getPosForClient().method_1022(vehicle.method_19538());
        int alt = UtilEntity.getDistFromSeaLevel((double)ping.getPosForClient().field_1351, (class_1937)vehicle.getWorld());
        String text = dist + " | " + alt;
        class_5250 comp = UtilMCText.literal((String)text);
        int width = this.field_22793.method_27525((class_5348)comp);
        this.field_22793.method_30883(poseStack, (class_2561)comp, (float)x - (float)width / 2.0f, (float)(y - 13), 65280);
        RenderSystem.setShaderTexture((int)0, (class_2960)PING_DATA);
        VehicleRadarScreen.method_25293((class_4587)poseStack, (int)(x - 9), (int)(y - 3), (int)6, (int)6, (float)(ping.entityType.getIconIndex() * 16), (float)0.0f, (int)16, (int)16, (int)240, (int)16);
        VehicleRadarScreen.method_25293((class_4587)poseStack, (int)(x + 3), (int)(y - 3), (int)6, (int)6, (float)(ping.terrainType.getIconIndex() * 16), (float)0.0f, (int)16, (int)16, (int)240, (int)16);
        if (ping.isFriendly) {
            VehicleRadarScreen.method_25293((class_4587)poseStack, (int)(x - 6), (int)(y + 3), (int)6, (int)6, (float)64.0f, (float)0.0f, (int)16, (int)16, (int)240, (int)16);
        }
        if (ping.isShared()) {
            VehicleRadarScreen.method_25293((class_4587)poseStack, (int)x, (int)(y + 3), (int)6, (int)6, (float)144.0f, (float)0.0f, (int)16, (int)16, (int)240, (int)16);
        }
        return true;
    }

    protected double getScreenDistRatio(double distance) {
        return distance / DSCClientInputs.getRadarDisplayRange();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (DSCClientInputs.isRadarHovering()) {
            RadarSystem radar = this.getVehicle().radarSystem;
            List<RadarStats.RadarPing> pings = radar.getClientRadarPings();
            if (DSCClientInputs.getRadarHoverIndex() < pings.size()) {
                radar.clientSelectTarget(pings.get(DSCClientInputs.getRadarHoverIndex()));
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    protected void method_25426() {
        this.vertical_widget_shift = 10;
        super.method_25426();
        this.positionWidgetGrid((class_339)class_5676.method_32606(value -> UtilMCText.translatable((String)value.getTranslatable())).method_32624((Object[])RadarStats.RadarMode.values()).method_32619((Object)DSCClientInputs.getPreferredRadarMode()).method_32617(0, 0, 20, 20, (class_2561)UtilMCText.translatable((String)"ui.dscombat.radar_mode"), this.onRadarModeCycle()), this.ROWS, this.COLUMNS, 1, 2);
        this.vertical_widget_shift = 34;
        this.COLUMNS = 4;
        class_342 rangeBox = new class_342(this.field_22787.field_1772, 0, 0, 20, 20, (class_2561)UtilMCText.empty());
        this.positionWidgetGrid((class_339)rangeBox, this.ROWS, this.COLUMNS, 3, 2);
        rangeBox.method_1852("" + DSCClientInputs.getRadarDisplayRange());
        rangeBox.method_1868(0xFFFFFF);
        rangeBox.method_1863(this.onRadarDisplayRangeChange());
        this.positionWidgetGrid((class_339)new class_4185(0, 0, 20, 20, (class_2561)UtilMCText.translatable((String)"ui.dscombat.cycle_radar_display_range"), onPress -> {
            DSCClientInputs.cycleRadarDisplayRange();
            rangeBox.method_1852("" + DSCClientInputs.getRadarDisplayRange());
        }), this.ROWS, this.COLUMNS, 0, 2, 3);
        this.positionWidgetGrid((class_339)new class_4185(0, 0, 20, 20, (class_2561)UtilMCText.translatable((String)"ui.dscombat.cycle_radar_target"), onPress -> this.getVehicle().radarSystem.clientSelectNextTarget()), this.ROWS, this.COLUMNS, 6, 2, 2);
        class_342 pingSizeBox = new class_342(this.field_22787.field_1772, 0, 0, 20, 20, (class_2561)UtilMCText.empty());
        this.positionWidgetGrid((class_339)pingSizeBox, this.ROWS, 6, 17, 2);
        pingSizeBox.method_1852(String.valueOf(Config.CLIENT.radarPingOverlaySize.get()));
        pingSizeBox.method_1868(0xFFFFFF);
        pingSizeBox.method_1863(UtilScreen.getIntResponder(value -> Config.CLIENT.radarPingOverlaySize.set((Object)Math.max(Math.min(value, 1000), 10))));
        class_474 increaseSize = new class_474(0, 0, true, button -> {
            Config.CLIENT.radarPingOverlaySize.set((Object)Math.min((Integer)Config.CLIENT.radarPingOverlaySize.get() + 50, 1000));
            pingSizeBox.method_1852(String.valueOf(Config.CLIENT.radarPingOverlaySize.get()));
        }, false);
        this.positionWidgetGrid((class_339)increaseSize, this.ROWS, 6, 16, 2);
        class_474 decreaseSize = new class_474(0, 0, false, button -> {
            Config.CLIENT.radarPingOverlaySize.set((Object)Math.max((Integer)Config.CLIENT.radarPingOverlaySize.get() - 50, 10));
            pingSizeBox.method_1852(String.valueOf(Config.CLIENT.radarPingOverlaySize.get()));
        }, false);
        this.positionWidgetGrid((class_339)decreaseSize, this.ROWS, 6, 15, 2);
    }

    @Override
    public void method_25420(@NotNull class_4587 poseStack) {
        super.method_25420(poseStack);
        this.field_22787.field_1772.method_30883(poseStack, (class_2561)UtilMCText.translatable((String)"ui.dscombat.change_ping_size"), (float)(this.guiX + this.left_padding + 126), (float)(this.guiY + this.top_padding + 82), 0x555555);
    }

    private class_5676.class_5678<RadarStats.RadarMode> onRadarModeCycle() {
        return (button, value) -> DSCClientInputs.setPreferredRadarMode(value);
    }

    private Consumer<String> onRadarDisplayRangeChange() {
        return range -> {
            try {
                double number = Double.parseDouble(range);
                DSCClientInputs.setRadarDisplayRange(number);
            }
            catch (NumberFormatException e) {
                DSCClientInputs.setRadarDisplayRange(250.0);
            }
        };
    }
}

