/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.event;

import com.mojang.brigadier.CommandDispatcher;
import com.onewhohears.dscombat.DependencySafety;
import com.onewhohears.dscombat.command.DSCAdminCommands;
import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.command.DSCParticleDebugCommand;
import com.onewhohears.dscombat.command.DebugHitboxPosCommand;
import com.onewhohears.dscombat.command.DebugSlotPosCommand;
import com.onewhohears.dscombat.command.MissileCommand;
import com.onewhohears.dscombat.command.VehicleCommand;
import com.onewhohears.dscombat.command.WindTunnelCommand;
import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.common.network.VehicleSyncAction;
import com.onewhohears.dscombat.data.graph.StatGraphs;
import com.onewhohears.dscombat.data.parts.PartPresets;
import com.onewhohears.dscombat.data.radar.RadarPresets;
import com.onewhohears.dscombat.data.radar.TrackableEntitiesManager;
import com.onewhohears.dscombat.data.vehicle.VehiclePresets;
import com.onewhohears.dscombat.data.vehicle.physics.PhysicsComponentData;
import com.onewhohears.dscombat.data.villager.DSCVillagerTrades;
import com.onewhohears.dscombat.data.weapon.NonTickingMissileManager;
import com.onewhohears.dscombat.data.weapon.RadarTargetTypes;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.entity.CustomExplosion;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.hitbox.RotableHitboxes;
import com.onewhohears.onewholibs.common.event.OWLEvents;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetReloadListener;
import com.onewhohears.onewholibs.util.UtilEntity;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.ExplosionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.config.ModConfig;

public class CommonEventHandlers {
    private static final Set<Integer> explodeRepeatCheck = new HashSet<Integer>();

    public static void init() {
        OWLEvents.GET_JSON_PRESET_LISTENERS.register(CommonEventHandlers::registerPresetListeners);
        LifecycleEvent.SERVER_STOPPING.register(CommonEventHandlers::serverStoppingEvent);
        LifecycleEvent.SETUP.register(CommonEventHandlers::onSetup);
        TickEvent.SERVER_PRE.register(CommonEventHandlers::onServerTickPre);
        TickEvent.PLAYER_POST.register(CommonEventHandlers::onPlayerTick);
        ExplosionEvent.DETONATE.register(CommonEventHandlers::onExplosionDetonate);
        CommandRegistrationEvent.EVENT.register(CommonEventHandlers::registerCommands);
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 context, class_2170.class_5364 selection) {
        new MissileCommand(dispatcher);
        new VehicleCommand(dispatcher);
        new DSCParticleDebugCommand(dispatcher);
        new DebugSlotPosCommand(dispatcher);
        new DebugHitboxPosCommand(dispatcher);
        new DSCAdminCommands(dispatcher);
        new WindTunnelCommand(dispatcher);
    }

    public static void onSetup() {
        PhysicsComponentData.register();
        VehicleSyncAction.register();
        PacketHandler.register();
        DSCGameRules.registerAll();
        DependencySafety.fmlCommonSetup();
        DSCVillagerTrades.register();
    }

    public static float onLivingHurt(class_1309 livingEntity, class_1282 damageSource, float amount) {
        class_1297 class_12972;
        if (damageSource.method_5527()) {
            return amount;
        }
        if (!livingEntity.method_5765() || !((class_12972 = livingEntity.method_5668()) instanceof EntityVehicle)) {
            return amount;
        }
        EntityVehicle plane = (EntityVehicle)class_12972;
        return plane.calcDamageToRider(damageSource, amount);
    }

    public static void onExplosionDetonate(class_1937 level, class_1927 explosion, List<class_1297> affectedEntities) {
        explodeRepeatCheck.clear();
        for (class_1297 e : affectedEntities) {
            if (!e.method_5659() || explodeRepeatCheck.contains(e.method_5628()) || !(e instanceof CustomExplosion)) continue;
            CustomExplosion entity = (CustomExplosion)e;
            entity.customExplosionHandler(explosion);
            explodeRepeatCheck.add(e.method_5628());
        }
    }

    public static void onPlayerTick(class_1657 player) {
        if (player.method_6128() && UtilEntity.getLevel((class_1297)player).method_8450().method_8355(DSCGameRules.DISABLE_ELYTRA_FLYING)) {
            player.method_23670();
        }
    }

    public static void onServerTickPre(MinecraftServer server) {
        NonTickingMissileManager.serverTick(server);
        TrackableEntitiesManager.serverTick(server);
    }

    public static void registerPresetListeners(List<JsonPresetReloadListener<?>> listeners) {
        listeners.add(StatGraphs.get());
        listeners.add(VehiclePresets.get());
        listeners.add(WeaponPresets.get());
        listeners.add(RadarPresets.get());
        listeners.add(PartPresets.get());
    }

    public static void serverStoppingEvent(MinecraftServer server) {
        RotableHitboxes.onServerStop();
    }

    public static void onReadConfig(ModConfig modConfig) {
        if (modConfig.getType() == ModConfig.Type.COMMON) {
            RadarTargetTypes.get().readConfig();
        }
    }
}

