/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network;

import com.onewhohears.dscombat.common.network.toserver.ToServerVehicleSyncAction;
import com.onewhohears.dscombat.data.parts.PartSlot;
import com.onewhohears.dscombat.data.parts.instance.ReloadablePartInstance;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.entity.parts.EntityRidablePart;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.dscombat.init.ModSounds;
import com.onewhohears.dscombat.item.ItemParachute;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public abstract class VehicleSyncAction {
    public static final BiPredicate<class_1657, EntityVehicle> PILOT_CHECK = (player, vehicle) -> {
        if (!vehicle.isPilotOrCopilot((class_1297)player)) {
            player.method_7353((class_2561)UtilMCText.translatable((String)"error.dscombat.not_a_pilot"), true);
            return false;
        }
        return true;
    };
    public static final BiPredicate<class_1657, EntityVehicle> OWNER_CHECK = (player, vehicle) -> {
        if (!vehicle.isOwner((class_1297)player)) {
            player.method_7353((class_2561)UtilMCText.translatable((String)"error.dscombat.not_owner"), true);
            return false;
        }
        return true;
    };
    public static final BiPredicate<class_1657, EntityVehicle> PERMISSION_CHECK = (player, vehicle) -> {
        if (!vehicle.hasPermission((class_1297)player)) {
            player.method_7353((class_2561)UtilMCText.translatable((String)"error.dscombat.no_perm_vehicle"), true);
            return false;
        }
        return true;
    };
    private static final IntObjectMap<VehicleSyncAction> sync_action_map = new IntObjectHashMap();
    private final int id;

    public static void register() {
        VehicleSyncAction.addVehicleSyncAction(new LandingGearAction(false));
        VehicleSyncAction.addVehicleSyncAction(new OpenStorageAction(0));
        VehicleSyncAction.addVehicleSyncAction(new OpenPartsAction());
        VehicleSyncAction.addVehicleSyncAction(new SetRadarModeAction(RadarStats.RadarMode.ALL));
        VehicleSyncAction.addVehicleSyncAction(new PingSelectAction(null));
        VehicleSyncAction.addVehicleSyncAction(new ShootAction(-1, null, null));
        VehicleSyncAction.addVehicleSyncAction(new ToItemAction());
        VehicleSyncAction.addVehicleSyncAction(new DismountAction());
        VehicleSyncAction.addVehicleSyncAction(new SwitchSeatAction());
        VehicleSyncAction.addVehicleSyncAction(new LoadPartAction("", false));
        VehicleSyncAction.addVehicleSyncAction(new JetesinAction(""));
        VehicleSyncAction.addVehicleSyncAction(new SetPermModeAction(EntityVehicle.PermMode.PUBLIC));
        VehicleSyncAction.addVehicleSyncAction(new SetCustomNameAction((class_2561)class_2561.method_43473()));
    }

    public static void sendSyncAction(VehicleSyncAction action) {
        new ToServerVehicleSyncAction(action).sendToServer();
    }

    @Nullable
    public static VehicleSyncAction getAction(int id) {
        return (VehicleSyncAction)sync_action_map.get(id);
    }

    public static void addVehicleSyncAction(VehicleSyncAction action) {
        sync_action_map.put(action.id, (Object)action);
    }

    protected VehicleSyncAction(int id) {
        this.id = id;
    }

    protected abstract BiPredicate<class_1657, EntityVehicle> getPermissionCheck();

    protected abstract BiConsumer<class_3222, EntityVehicle> getServerAction();

    protected abstract Consumer<class_2540> getWriteData();

    protected abstract Consumer<class_2540> getReadData();

    public int getId() {
        return this.id;
    }

    public void writeData(class_2540 buffer) {
        this.getWriteData().accept(buffer);
    }

    public void readData(class_2540 buffer) {
        this.getReadData().accept(buffer);
    }

    public boolean hasPermission(class_1657 player, EntityVehicle vehicle) {
        return this.getPermissionCheck().test(player, vehicle);
    }

    public void runServerAction(class_3222 player, EntityVehicle vehicle) {
        this.getServerAction().accept(player, vehicle);
    }

    public static class LandingGearAction
    extends VehicleSyncAction {
        private boolean active;

        public LandingGearAction(boolean active) {
            super(0);
            this.active = active;
        }

        public boolean isActive() {
            return this.active;
        }

        @Override
        protected BiPredicate<class_1657, EntityVehicle> getPermissionCheck() {
            return PILOT_CHECK;
        }

        @Override
        protected BiConsumer<class_3222, EntityVehicle> getServerAction() {
            return (player, vehicle) -> vehicle.setLandingGear(this.isActive());
        }

        @Override
        protected Consumer<class_2540> getWriteData() {
            return buffer -> buffer.writeBoolean(this.isActive());
        }

        @Override
        protected Consumer<class_2540> getReadData() {
            return buffer -> {
                this.active = buffer.readBoolean();
            };
        }
    }

    public static class OpenStorageAction
    extends VehicleSyncAction {
        private int index;

        public OpenStorageAction(int index) {
            super(1);
            this.index = index;
        }

        @Override
        protected BiPredicate<class_1657, EntityVehicle> getPermissionCheck() {
            return (player, vehicle) -> {
                if (!vehicle.canOpenPartsMenu()) {
                    player.method_7353((class_2561)UtilMCText.translatable((String)vehicle.getOpenMenuError()), true);
                    return false;
                }
                if (!vehicle.partsManager.hasStorageBoxes()) {
                    player.method_7353((class_2561)UtilMCText.translatable((String)"error.dscombat.no_storage_boxes"), true);
                    return false;
                }
                return true;
            };
        }

        @Override
        protected BiConsumer<class_3222, EntityVehicle> getServerAction() {
            return (player, vehicle) -> vehicle.openStorage((class_3222)player, this.index);
        }

        @Override
        protected Consumer<class_2540> getWriteData() {
            return buffer -> buffer.writeInt(this.index);
        }

        @Override
        protected Consumer<class_2540> getReadData() {
            return buffer -> {
                this.index = buffer.readInt();
            };
        }
    }

    public static class OpenPartsAction
    extends VehicleSyncAction {
        public OpenPartsAction() {
            super(2);
        }

        @Override
        protected BiPredicate<class_1657, EntityVehicle> getPermissionCheck() {
            return (player, vehicle) -> {
                if (!vehicle.canOpenPartsMenu()) {
                    player.method_7353((class_2561)UtilMCText.translatable((String)vehicle.getOpenMenuError()), true);
                    return false;
                }
                return true;
            };
        }

        @Override
        protected BiConsumer<class_3222, EntityVehicle> getServerAction() {
            return (player, vehicle) -> vehicle.openPartsMenu((class_3222)player);
        }

        @Override
        protected Consumer<class_2540> getWriteData() {
            return buffer -> {};
        }

        @Override
        protected Consumer<class_2540> getReadData() {
            return buffer -> {};
        }
    }

    public static class SetRadarModeAction
    extends VehicleSyncAction {
        private RadarStats.RadarMode mode;

        public SetRadarModeAction(RadarStats.RadarMode mode) {
            super(3);
            this.mode = mode;
        }

        @Override
        protected BiPredicate<class_1657, EntityVehicle> getPermissionCheck() {
            return (player, vehicle) -> true;
        }

        @Override
        protected BiConsumer<class_3222, EntityVehicle> getServerAction() {
            return (player, vehicle) -> vehicle.setRadarMode(this.mode);
        }

        @Override
        protected Consumer<class_2540> getWriteData() {
            return buffer -> buffer.method_10817((Enum)this.mode);
        }

        @Override
        protected Consumer<class_2540> getReadData() {
            return buffer -> {
                this.mode = (RadarStats.RadarMode)buffer.method_10818(RadarStats.RadarMode.class);
            };
        }
    }

    public static class PingSelectAction
    extends VehicleSyncAction {
        private RadarStats.RadarPing ping;

        public PingSelectAction(RadarStats.RadarPing ping) {
            super(4);
            this.ping = ping;
        }

        @Override
        protected BiPredicate<class_1657, EntityVehicle> getPermissionCheck() {
            return (player, vehicle) -> true;
        }

        @Override
        protected BiConsumer<class_3222, EntityVehicle> getServerAction() {
            return (player, vehicle) -> vehicle.radarSystem.selectTarget(this.ping);
        }

        @Override
        protected Consumer<class_2540> getWriteData() {
            return buffer -> this.ping.write((class_2540)buffer);
        }

        @Override
        protected Consumer<class_2540> getReadData() {
            return buffer -> {
                this.ping = new RadarStats.RadarPing((class_2540)buffer);
            };
        }
    }

    public static class ShootAction
    extends VehicleSyncAction {
        private int selectedWeaponIndex;
        @Nullable
        private RadarStats.RadarPing ping;
        @Nullable
        private class_243 targetPos;

        public ShootAction(int selectedWeaponIndex, @Nullable RadarStats.RadarPing ping, @Nullable class_243 targetPos) {
            super(5);
            this.selectedWeaponIndex = selectedWeaponIndex;
            this.ping = ping;
            this.targetPos = targetPos;
        }

        @Override
        protected BiPredicate<class_1657, EntityVehicle> getPermissionCheck() {
            return (player, vehicle) -> true;
        }

        @Override
        protected BiConsumer<class_3222, EntityVehicle> getServerAction() {
            return (player, vehicle) -> {
                class_1297 patt0$temp = player.method_5854();
                if (!(patt0$temp instanceof EntityRidablePart)) {
                    return;
                }
                EntityRidablePart seat = (EntityRidablePart)patt0$temp;
                if (this.ping != null) {
                    vehicle.radarSystem.selectTarget(this.ping);
                }
                if (this.targetPos != null) {
                    vehicle.weaponSystem.setTargetPos(this.targetPos);
                }
                if (seat.isTurret()) {
                    ((EntityTurret)seat).shoot((class_1297)player);
                    return;
                }
                if (this.selectedWeaponIndex == -1) {
                    return;
                }
                if (!seat.canPassengerShootParentWeapon()) {
                    return;
                }
                vehicle.weaponSystem.setSelected(this.selectedWeaponIndex);
                vehicle.weaponSystem.shootSelected((class_1297)player);
            };
        }

        @Override
        protected Consumer<class_2540> getWriteData() {
            return buffer -> {
                buffer.writeInt(this.selectedWeaponIndex);
                if (this.ping != null) {
                    buffer.writeBoolean(true);
                    this.ping.write((class_2540)buffer);
                } else {
                    buffer.writeBoolean(false);
                }
                if (this.targetPos != null) {
                    buffer.writeBoolean(true);
                    DataSerializers.VEC3.method_12715(buffer, (Object)this.targetPos);
                } else {
                    buffer.writeBoolean(false);
                }
            };
        }

        @Override
        protected Consumer<class_2540> getReadData() {
            return buffer -> {
                this.selectedWeaponIndex = buffer.readInt();
                this.ping = buffer.readBoolean() ? new RadarStats.RadarPing((class_2540)buffer) : null;
                this.targetPos = buffer.readBoolean() ? (class_243)DataSerializers.VEC3.method_12716(buffer) : null;
            };
        }
    }

    public static class ToItemAction
    extends VehicleSyncAction {
        public ToItemAction() {
            super(6);
        }

        @Override
        protected BiPredicate<class_1657, EntityVehicle> getPermissionCheck() {
            return (player, vehicle) -> {
                class_2561 reason = vehicle.getCantBecomeItemReason((class_1657)player);
                if (reason != null) {
                    player.method_7353(reason, true);
                    return false;
                }
                return true;
            };
        }

        @Override
        protected BiConsumer<class_3222, EntityVehicle> getServerAction() {
            return (player, vehicle) -> {
                class_1799 item = vehicle.getItem();
                if (player.method_31548().method_7376() != -1 && player.method_7270(item)) {
                    vehicle.method_31472();
                    return;
                }
                vehicle.becomeItem(player.method_19538());
            };
        }

        @Override
        protected Consumer<class_2540> getWriteData() {
            return buffer -> {};
        }

        @Override
        protected Consumer<class_2540> getReadData() {
            return buffer -> {};
        }
    }

    public static class DismountAction
    extends VehicleSyncAction {
        private boolean eject = false;

        public DismountAction() {
            super(7);
        }

        public DismountAction(boolean eject) {
            this();
            this.eject = eject;
        }

        @Override
        protected BiPredicate<class_1657, EntityVehicle> getPermissionCheck() {
            return (player, vehicle) -> true;
        }

        @Override
        protected BiConsumer<class_3222, EntityVehicle> getServerAction() {
            return (player, vehicle) -> {
                EntityRidablePart seat;
                class_1297 patt0$temp;
                if (this.eject && (patt0$temp = player.method_5854()) instanceof EntityRidablePart && (seat = (EntityRidablePart)patt0$temp).canEject()) {
                    class_243 dir;
                    seat.useEject();
                    player.method_5848();
                    double EJECT_PUSH = 4.0;
                    double EJECT_MOVE = 1.0;
                    if (vehicle != null) {
                        dir = UtilAngles.getYawAxis((QuaternionF)vehicle.getQ());
                        player.method_18799(vehicle.method_18798().method_1019(dir.method_1021(EJECT_MOVE)));
                    } else {
                        dir = new class_243(0.0, 1.0, 0.0);
                    }
                    player.method_33574(player.method_19538().method_1019(dir.method_1021(EJECT_PUSH)));
                    class_3218 level = (class_3218)UtilEntity.getLevel((class_1297)player);
                    ItemParachute.createParachute(level, (class_1657)player, null);
                    level.method_8396(null, player.method_24515(), ModSounds.EJECT, class_3419.field_15248, 1.0f, 1.0f);
                } else {
                    player.method_5848();
                }
            };
        }

        @Override
        protected Consumer<class_2540> getWriteData() {
            return buffer -> buffer.writeBoolean(this.eject);
        }

        @Override
        protected Consumer<class_2540> getReadData() {
            return buffer -> {
                this.eject = buffer.readBoolean();
            };
        }
    }

    public static class SwitchSeatAction
    extends VehicleSyncAction {
        public SwitchSeatAction() {
            super(8);
        }

        @Override
        protected BiPredicate<class_1657, EntityVehicle> getPermissionCheck() {
            return (player, vehicle) -> true;
        }

        @Override
        protected BiConsumer<class_3222, EntityVehicle> getServerAction() {
            return (player, vehicle) -> {
                if (!vehicle.switchSeat((class_1297)player)) {
                    player.method_7353((class_2561)UtilMCText.translatable((String)"error.dscombat.no_open_seats"), true);
                }
            };
        }

        @Override
        protected Consumer<class_2540> getWriteData() {
            return buffer -> {};
        }

        @Override
        protected Consumer<class_2540> getReadData() {
            return buffer -> {};
        }
    }

    public static class LoadPartAction
    extends VehicleSyncAction {
        private String slotId = "";
        private boolean unload = false;
        private boolean all = false;

        public LoadPartAction(String slotId, boolean unload) {
            super(9);
            this.slotId = slotId;
            this.unload = unload;
        }

        public LoadPartAction(boolean unload) {
            super(9);
            this.unload = unload;
            this.all = true;
        }

        @Override
        protected BiPredicate<class_1657, EntityVehicle> getPermissionCheck() {
            return (player, vehicle) -> vehicle.canReload((class_1657)player);
        }

        @Override
        protected BiConsumer<class_3222, EntityVehicle> getServerAction() {
            return (player, vehicle) -> {
                if (this.all) {
                    for (PartSlot slot : vehicle.partsManager.getReloadableParts()) {
                        this.handleSlot((class_3222)player, (ReloadablePartInstance)((Object)slot.getPartData()));
                    }
                } else {
                    this.handleSlot((class_3222)player, vehicle.partsManager.getReloadablePart(this.slotId));
                }
            };
        }

        private void handleSlot(class_3222 player, @Nullable ReloadablePartInstance part) {
            if (part == null) {
                return;
            }
            if (this.unload && (!this.all || part.canUnload())) {
                part.unloadPartToInventory(player);
            } else {
                part.loadPartFromInventory(player);
            }
        }

        @Override
        protected Consumer<class_2540> getWriteData() {
            return buffer -> {
                buffer.method_10814(this.slotId);
                buffer.writeBoolean(this.unload);
                buffer.writeBoolean(this.all);
            };
        }

        @Override
        protected Consumer<class_2540> getReadData() {
            return buffer -> {
                this.slotId = buffer.method_19772();
                this.unload = buffer.readBoolean();
                this.all = buffer.readBoolean();
            };
        }
    }

    public static class JetesinAction
    extends VehicleSyncAction {
        private String slotId = "";

        public JetesinAction(String slotId) {
            super(10);
            this.slotId = slotId;
        }

        @Override
        protected BiPredicate<class_1657, EntityVehicle> getPermissionCheck() {
            return PILOT_CHECK;
        }

        @Override
        protected BiConsumer<class_3222, EntityVehicle> getServerAction() {
            return (player, vehicle) -> vehicle.jetesinPart(this.slotId);
        }

        @Override
        protected Consumer<class_2540> getWriteData() {
            return buffer -> buffer.method_10814(this.slotId);
        }

        @Override
        protected Consumer<class_2540> getReadData() {
            return buffer -> {
                this.slotId = buffer.method_19772();
            };
        }
    }

    public static class SetPermModeAction
    extends VehicleSyncAction {
        private EntityVehicle.PermMode mode;

        public SetPermModeAction(EntityVehicle.PermMode mode) {
            super(11);
            this.mode = mode;
        }

        @Override
        protected BiPredicate<class_1657, EntityVehicle> getPermissionCheck() {
            return OWNER_CHECK;
        }

        @Override
        protected BiConsumer<class_3222, EntityVehicle> getServerAction() {
            return (player, vehicle) -> vehicle.setPermMode(this.mode);
        }

        @Override
        protected Consumer<class_2540> getWriteData() {
            return buffer -> buffer.method_10817((Enum)this.mode);
        }

        @Override
        protected Consumer<class_2540> getReadData() {
            return buffer -> {
                this.mode = (EntityVehicle.PermMode)buffer.method_10818(EntityVehicle.PermMode.class);
            };
        }
    }

    public static class SetCustomNameAction
    extends VehicleSyncAction {
        private class_2561 name;

        public SetCustomNameAction(class_2561 name) {
            super(12);
            this.name = name;
        }

        @Override
        protected BiPredicate<class_1657, EntityVehicle> getPermissionCheck() {
            return PERMISSION_CHECK;
        }

        @Override
        protected BiConsumer<class_3222, EntityVehicle> getServerAction() {
            return (player, vehicle) -> {
                if (this.name.getString().isEmpty()) {
                    vehicle.method_5665(null);
                } else {
                    vehicle.method_5665(this.name);
                }
            };
        }

        @Override
        protected Consumer<class_2540> getWriteData() {
            return buffer -> buffer.method_10805(this.name);
        }

        @Override
        protected Consumer<class_2540> getReadData() {
            return buffer -> {
                this.name = buffer.method_10808();
            };
        }
    }
}

