/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.crafting;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.vehicle.VehiclePresets;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.init.ModBlocks;
import com.onewhohears.onewholibs.data.crafting.IngredientStack;
import com.onewhohears.onewholibs.util.UtilItem;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VehicleRecipe
implements class_1860<class_1661> {
    private final class_2960 id;
    private final String presetId;
    @Nullable
    private class_2371<class_1856> ingredients;

    public VehicleRecipe(class_2960 id, String presetId, @Nullable class_2371<class_1856> ingredients) {
        this.id = id;
        this.presetId = presetId;
        this.ingredients = ingredients;
    }

    public boolean matches(class_1661 inventory, class_1937 level) {
        return UtilItem.testRecipe(this.method_8117(), (class_1263)inventory);
    }

    @NotNull
    public class_1799 assemble(class_1661 container) {
        return this.getOutput();
    }

    @NotNull
    public class_2371<class_1799> getRemainingItems(class_1661 inventory) {
        return UtilItem.getRemainingItemsStackIngredients((class_1263)inventory, this.method_8117());
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    @NotNull
    public class_1799 method_8110() {
        return this.getOutput().method_7972();
    }

    @NotNull
    public class_1799 method_17447() {
        return new class_1799((class_1935)ModBlocks.AIRCRAFT_BLOCK.get());
    }

    @NotNull
    public class_2960 method_8114() {
        return this.id;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public class_3956<?> method_17716() {
        return Type.INSTANCE;
    }

    public String getVehiclePresetId() {
        return this.presetId;
    }

    public VehicleStats getVehicleStats() {
        return (VehicleStats)VehiclePresets.get().get(this.getVehiclePresetId());
    }

    public int getSortFactor() {
        VehicleStats preset = this.getVehicleStats();
        if (preset == null) {
            return 0;
        }
        return preset.getSortFactor();
    }

    public int compare(VehicleRecipe other) {
        if (this.getSortFactor() != other.getSortFactor()) {
            return this.getSortFactor() - other.getSortFactor();
        }
        return this.presetId.compareToIgnoreCase(other.presetId);
    }

    @NotNull
    public class_2371<class_1856> method_8117() {
        if (this.ingredients == null) {
            VehicleStats preset = this.getVehicleStats();
            this.ingredients = preset == null ? class_2371.method_10211() : preset.getIngredients();
        }
        return this.ingredients;
    }

    public class_1799 getOutput() {
        VehicleStats preset = this.getVehicleStats();
        if (preset == null) {
            return class_1799.field_8037;
        }
        return preset.getItem();
    }

    public boolean method_8118() {
        return true;
    }

    public static class Serializer
    implements class_1865<VehicleRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final class_2960 ID = new class_2960("dscombat", "aircraft_workbench");

        @NotNull
        public VehicleRecipe fromJson(class_2960 recipeId, JsonObject serializedRecipe) {
            String presetId = serializedRecipe.get("presetId").getAsString();
            return new VehicleRecipe(recipeId, presetId, null);
        }

        @NotNull
        public VehicleRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            String presetId = buffer.method_19772();
            int size = buffer.readInt();
            class_2371 ingredients = class_2371.method_10211();
            for (int i = 0; i < size; ++i) {
                ingredients.add((Object)IngredientStack.fromNetwork((class_2540)buffer));
            }
            return new VehicleRecipe(recipeId, presetId, (class_2371<class_1856>)ingredients);
        }

        public void toNetwork(class_2540 buffer, VehicleRecipe recipe) {
            buffer.method_10814(recipe.presetId);
            buffer.writeInt(recipe.method_8117().size());
            for (class_1856 i : recipe.method_8117()) {
                IngredientStack.toNetwork((class_2540)buffer, (class_1856)i);
            }
        }
    }

    public static class Type
    implements class_3956<VehicleRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "aircraft_workbench";

        private Type() {
        }

        public String toString() {
            return ID;
        }
    }
}

