/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.crafting;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.init.ModBlocks;
import com.onewhohears.onewholibs.data.crafting.IngredientStack;
import com.onewhohears.onewholibs.util.UtilItem;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeaponRecipe
implements class_1860<class_1661> {
    private final class_2960 id;
    private final String presetId;
    @Nullable
    private class_2371<class_1856> ingredients;

    public WeaponRecipe(class_2960 id, String presetId, @Nullable class_2371<class_1856> ingredients) {
        this.id = id;
        this.presetId = presetId;
        this.ingredients = ingredients;
    }

    public boolean matches(class_1661 inventory, class_1937 level) {
        return UtilItem.testRecipe(this.method_8117(), (class_1263)inventory);
    }

    @NotNull
    public class_1799 assemble(class_1661 container) {
        return this.getOutput();
    }

    @NotNull
    public class_2371<class_1799> getRemainingItems(class_1661 inventory) {
        return UtilItem.getRemainingItemsStackIngredients((class_1263)inventory, this.method_8117());
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    @NotNull
    public class_1799 method_8110() {
        return this.getOutput().method_7972();
    }

    @NotNull
    public class_1799 method_17447() {
        return new class_1799((class_1935)ModBlocks.WEAPONS_BLOCK.get());
    }

    @NotNull
    public class_2960 method_8114() {
        return this.id;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public class_3956<?> method_17716() {
        return Type.INSTANCE;
    }

    public String getWeaponPresetId() {
        return this.presetId;
    }

    public WeaponStats getWeaponData() {
        return WeaponPresets.get().get(this.getWeaponPresetId());
    }

    public int compare(WeaponRecipe other) {
        WeaponStats me = this.getWeaponData();
        WeaponStats you = other.getWeaponData();
        if (me == null || you == null) {
            return 0;
        }
        return me.compare(you);
    }

    @NotNull
    public class_2371<class_1856> method_8117() {
        if (this.ingredients == null) {
            WeaponStats preset = this.getWeaponData();
            this.ingredients = preset == null ? class_2371.method_10211() : preset.getIngredients();
        }
        return this.ingredients;
    }

    public class_1799 getOutput() {
        WeaponStats preset = this.getWeaponData();
        if (preset == null) {
            return class_1799.field_8037;
        }
        return preset.getNewItem();
    }

    public boolean method_8118() {
        return true;
    }

    public static class Serializer
    implements class_1865<WeaponRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final class_2960 ID = new class_2960("dscombat", "weapon_workbench");

        @NotNull
        public WeaponRecipe fromJson(class_2960 recipeId, JsonObject serializedRecipe) {
            String presetId = serializedRecipe.get("presetId").getAsString();
            return new WeaponRecipe(recipeId, presetId, null);
        }

        @NotNull
        public WeaponRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            String presetId = buffer.method_19772();
            int size = buffer.readInt();
            class_2371 ingredients = class_2371.method_10211();
            for (int i = 0; i < size; ++i) {
                ingredients.add((Object)IngredientStack.fromNetwork((class_2540)buffer));
            }
            return new WeaponRecipe(recipeId, presetId, (class_2371<class_1856>)ingredients);
        }

        public void toNetwork(class_2540 buffer, WeaponRecipe recipe) {
            buffer.method_10814(recipe.presetId);
            buffer.writeInt(recipe.method_8117().size());
            for (class_1856 i : recipe.method_8117()) {
                IngredientStack.toNetwork((class_2540)buffer, (class_1856)i);
            }
        }
    }

    public static class Type
    implements class_3956<WeaponRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "weapon_workbench";

        private Type() {
        }

        public String toString() {
            return ID;
        }
    }
}

