/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.graph;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.graph.Graph;
import com.onewhohears.dscombat.data.graph.GraphType;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import net.minecraft.class_2960;

public class FloatFloatGraph
extends Graph<Float, Float> {
    private final Float[] keys;
    private final Float[] values;
    private final boolean overrideSize;

    public FloatFloatGraph(class_2960 key, JsonObject json) {
        super(key, json);
        if (json.has("map")) {
            this.overrideSize = true;
            JsonArray mapJA = json.get("map").getAsJsonArray();
            this.keys = new Float[mapJA.size()];
            this.values = new Float[mapJA.size()];
            for (int i = 0; i < mapJA.size(); ++i) {
                JsonObject entry = mapJA.get(i).getAsJsonObject();
                this.keys[i] = Float.valueOf(entry.get("key").getAsFloat());
                this.values[i] = Float.valueOf(entry.get("value").getAsFloat());
            }
        } else {
            this.overrideSize = false;
            this.keys = new Float[this.getSize()];
            this.values = new Float[this.getSize()];
            JsonArray keyJA = json.get("keys").getAsJsonArray();
            JsonArray valueJA = json.get("values").getAsJsonArray();
            for (int i = 0; i < this.getSize(); ++i) {
                this.keys[i] = Float.valueOf(keyJA.get(i).getAsFloat());
                this.values[i] = Float.valueOf(valueJA.get(i).getAsFloat());
            }
        }
    }

    public Float[] getKeys() {
        return this.keys;
    }

    public Float[] getValues() {
        return this.values;
    }

    @Override
    public boolean isFloatLessThan(float a, Float b) {
        return a < b.floatValue();
    }

    public JsonPresetType getType() {
        return GraphType.FLOATFLOAT;
    }

    public JsonPresetInstance<?> createPresetInstance() {
        return null;
    }

    @Override
    public int getSize() {
        if (this.overrideSize) {
            return this.keys.length;
        }
        return super.getSize();
    }
}

