/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts.stats;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.parts.PartType;
import com.onewhohears.dscombat.data.parts.instance.EngineInstance;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import java.util.List;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;

public class EngineStats
extends PartStats {
    private final EngineType engineType;
    private final float thrust;
    private final float heat;
    private final float fuelRate;

    public EngineStats(class_2960 key, JsonObject json) {
        super(key, json);
        this.engineType = (EngineType)UtilParse.getEnumSafe((JsonObject)json, (String)"engineType", EngineType.class);
        this.thrust = UtilParse.getFloatSafe((JsonObject)json, (String)"thrust", (float)0.0f);
        this.heat = UtilParse.getFloatSafe((JsonObject)json, (String)"heat", (float)0.0f);
        this.fuelRate = UtilParse.getFloatSafe((JsonObject)json, (String)"fuelRate", (float)0.0f);
    }

    public JsonPresetType getType() {
        return PartType.INTERNAL_ENGINE;
    }

    public JsonPresetInstance<?> createPresetInstance() {
        return new EngineInstance<EngineStats>(this);
    }

    public EngineType getEngineType() {
        return this.engineType;
    }

    public float getThrust() {
        return this.thrust;
    }

    public float getHeat() {
        return this.heat;
    }

    public float getFuelPerTick() {
        return this.fuelRate;
    }

    @Override
    public boolean isEngine() {
        return true;
    }

    @Override
    public void addToolTips(List<class_2561> tips, class_1836 isAdvanced) {
        super.addToolTips(tips, isAdvanced);
        tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.vehicle_engine_stats_override"));
        tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.thrust").method_27693(": " + this.thrust).method_10862(class_2583.field_24360.method_36139(0xAAAAAA)));
        tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.fuel_liter_per_minute").method_27693(": " + String.format("%.1f", Float.valueOf(this.fuelRate * 1200.0f))).method_10862(class_2583.field_24360.method_36139(0xAAAAAA)));
    }

    public static enum EngineType {
        SPIN,
        PUSH;

    }
}

