/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.radar;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.radar.RadarInstance;
import com.onewhohears.dscombat.data.radar.RadarType;
import com.onewhohears.dscombat.data.vehicle.physics.DSCPhyCons;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.data.jsonpreset.PresetBuilder;
import com.onewhohears.onewholibs.util.UtilParse;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class RadarStats
extends JsonPresetStats {
    private final double range;
    private final double sensitivity;
    private final double fov;
    private final int scanRate;
    private final boolean scanAircraft;
    private final boolean scanPlayers;
    private final boolean scanMobs;
    private final boolean scanGround;
    private final boolean scanAir;
    private final double throWaterRange;
    private final double throGroundRange;
    private final boolean scanMissiles;
    private final boolean useDistanceScale;

    public RadarStats(class_2960 key, JsonObject json) {
        super(key, json);
        this.range = UtilParse.getFloatSafe((JsonObject)json, (String)"range", (float)0.0f);
        this.sensitivity = UtilParse.getFloatSafe((JsonObject)json, (String)"sensitivity", (float)0.0f);
        this.fov = UtilParse.getFloatSafe((JsonObject)json, (String)"fov", (float)0.0f);
        this.scanRate = UtilParse.getIntSafe((JsonObject)json, (String)"scanRate", (int)100);
        this.scanAircraft = UtilParse.getBooleanSafe((JsonObject)json, (String)"scanAircraft", (boolean)false);
        this.scanPlayers = UtilParse.getBooleanSafe((JsonObject)json, (String)"scanPlayers", (boolean)false);
        this.scanMobs = UtilParse.getBooleanSafe((JsonObject)json, (String)"scanMobs", (boolean)false);
        this.scanGround = UtilParse.getBooleanSafe((JsonObject)json, (String)"scanGround", (boolean)false);
        this.scanAir = UtilParse.getBooleanSafe((JsonObject)json, (String)"scanAir", (boolean)false);
        this.throWaterRange = UtilParse.getFloatSafe((JsonObject)json, (String)"throWaterRange", (float)0.0f);
        this.throGroundRange = UtilParse.getFloatSafe((JsonObject)json, (String)"throGroundRange", (float)0.0f);
        this.scanMissiles = UtilParse.getBooleanSafe((JsonObject)json, (String)"scanMissiles", (boolean)false);
        this.useDistanceScale = UtilParse.getBooleanSafe((JsonObject)json, (String)"useDistanceScale", (boolean)false);
    }

    public JsonPresetInstance<?> createPresetInstance() {
        return new RadarInstance<RadarStats>(this);
    }

    public RadarInstance<?> createRadarInstance() {
        return (RadarInstance)this.createPresetInstance();
    }

    public JsonPresetType getType() {
        return RadarType.STANDARD;
    }

    public double getUnscaledRange() {
        return this.range;
    }

    public double getFov() {
        return this.fov;
    }

    public int getScanRate() {
        return this.scanRate;
    }

    public boolean isScanAircraft() {
        return this.scanAircraft;
    }

    public boolean isScanPlayers() {
        return this.scanPlayers;
    }

    public boolean isScanMobs() {
        return this.scanMobs;
    }

    public boolean isScanGround() {
        return this.scanGround;
    }

    public boolean isScanAir() {
        return this.scanAir;
    }

    public double getSensitivity() {
        return this.sensitivity;
    }

    public double getThroWaterRange() {
        return this.throWaterRange;
    }

    public double getThroGroundRange() {
        return this.throGroundRange;
    }

    public boolean isScanMissiles() {
        return this.scanMissiles;
    }

    public boolean isUseDistanceScale() {
        return this.useDistanceScale;
    }

    public double getRange() {
        if (this.isUseDistanceScale()) {
            return DSCPhyCons.getIRLScale() * this.getUnscaledRange();
        }
        return this.getUnscaledRange();
    }

    public String toString() {
        return "[" + this.getId() + ":" + this.fov + ":" + this.range + "]";
    }

    public static class Builder
    extends PresetBuilder<Builder> {
        public Builder(String namespace, String name, RadarType type) {
            super(namespace, name, (JsonPresetType)type);
        }

        public static Builder create(String namespace, String name) {
            return new Builder(namespace, name, RadarType.STANDARD);
        }

        public Builder setRange(float range) {
            return (Builder)this.setFloat("range", range);
        }

        public Builder setSensitivity(float sensitivity) {
            return (Builder)this.setFloat("sensitivity", sensitivity);
        }

        public Builder setFieldOfView(float fov) {
            return (Builder)this.setFloat("fov", fov);
        }

        public Builder setScanRate(int scanRate) {
            return (Builder)this.setInt("scanRate", scanRate);
        }

        public Builder setScanAircraft(boolean scanAircraft) {
            return (Builder)this.setBoolean("scanAircraft", scanAircraft);
        }

        public Builder setScanPlayers(boolean scanPlayers) {
            return (Builder)this.setBoolean("scanPlayers", scanPlayers);
        }

        public Builder setScanMobs(boolean scanMobs) {
            return (Builder)this.setBoolean("scanMobs", scanMobs);
        }

        public Builder setScanGround(boolean scanGround) {
            return (Builder)this.setBoolean("scanGround", scanGround);
        }

        public Builder setScanAir(boolean scanAir) {
            return (Builder)this.setBoolean("scanAir", scanAir);
        }

        public Builder setThroWaterRange(float throWaterRange) {
            return (Builder)this.setFloat("throWaterRange", throWaterRange);
        }

        public Builder setThroGroundRange(float throGroundRange) {
            return (Builder)this.setFloat("throGroundRange", throGroundRange);
        }

        public Builder setScanMissiles(boolean scanMissiles) {
            return (Builder)this.setBoolean("scanMissiles", scanMissiles);
        }

        public Builder setUseDistanceScale(boolean useDistanceScale) {
            return (Builder)this.setBoolean("useDistanceScale", useDistanceScale);
        }
    }

    public static enum RadarMode {
        ALL,
        PLAYERS,
        BOTS,
        VEHICLES,
        MOBS,
        OFF;


        public RadarMode cycle() {
            int i = this.ordinal();
            if (++i >= RadarMode.values().length) {
                i = 0;
            }
            return RadarMode.values()[i];
        }

        public boolean canScan(RadarMode mode) {
            if (this == ALL) {
                return true;
            }
            return this == mode;
        }

        public boolean isPlayersOnly() {
            return this == PLAYERS;
        }

        public boolean isPlayersOrBots() {
            return this.isPlayersOnly() || this == BOTS;
        }

        public boolean isMobsOnly() {
            return this == MOBS;
        }

        public boolean isVehiclesOnly() {
            return this == VEHICLES;
        }

        public boolean isOff() {
            return this == OFF;
        }

        public boolean isOn() {
            return !this.isOff();
        }

        public boolean isAll() {
            return this == ALL;
        }

        public String getTranslatable() {
            return "radarmode.dscombat." + this.name().toLowerCase();
        }

        public static RadarMode byId(int id) {
            if (id < 0 || id >= RadarMode.values().length) {
                return ALL;
            }
            return RadarMode.values()[id];
        }
    }

    public static enum PingEntityType {
        PLAYER(0, 0),
        HOSTILE_MOB(1, 1),
        FRIENDLY_MOB(2, 2),
        VEHICLE(3, 3),
        VEHICLE_PLAYER(4, 3),
        VEHICLE_BOT(5, 3),
        MISSILE(6, 5);

        public final byte id;
        public final int index;

        private PingEntityType(byte id, int index) {
            this.id = id;
            this.index = index;
        }

        public int getIconIndex() {
            return this.index;
        }

        public boolean isMob() {
            return this == HOSTILE_MOB || this == FRIENDLY_MOB;
        }

        public boolean isVehicle() {
            return this == VEHICLE || this == VEHICLE_PLAYER || this == VEHICLE_BOT;
        }

        public boolean isPlayer() {
            return this == PLAYER || this == VEHICLE_PLAYER;
        }

        public boolean isBot() {
            return this == PLAYER || this == VEHICLE_PLAYER || this == VEHICLE_BOT;
        }

        public boolean isMissile() {
            return this == MISSILE;
        }

        public static PingEntityType getById(byte id) {
            for (int i = 0; i < PingEntityType.values().length; ++i) {
                if (PingEntityType.values()[i].id != id) continue;
                return PingEntityType.values()[i];
            }
            return FRIENDLY_MOB;
        }
    }

    public static enum PingTerrainType {
        GROUND(0, 6),
        AIR(1, 8),
        WATER(2, 7);

        public final byte id;
        public final int index;

        private PingTerrainType(byte id, int index) {
            this.id = id;
            this.index = index;
        }

        public int getIconIndex() {
            return this.index;
        }

        public boolean isGround() {
            return this == GROUND;
        }

        public boolean isAir() {
            return this == AIR;
        }

        public boolean isWater() {
            return this == WATER;
        }

        public static PingTerrainType getById(byte id) {
            for (int i = 0; i < PingTerrainType.values().length; ++i) {
                if (PingTerrainType.values()[i].id != id) continue;
                return PingTerrainType.values()[i];
            }
            return GROUND;
        }

        public static PingTerrainType getByEntity(class_1297 e) {
            if (e.method_5799()) {
                return WATER;
            }
            if (UtilVehicleEntity.isOnGroundOrWater(e)) {
                return GROUND;
            }
            return AIR;
        }
    }

    public static class RadarPing {
        public final int id;
        public final class_243 pos;
        public final boolean isFriendly;
        public final PingTerrainType terrainType;
        public final PingEntityType entityType;
        private boolean isShared;
        private class_243 clientPos;

        public RadarPing(class_1297 ping, boolean isFriendly, PingEntityType entityType) {
            this.id = ping.method_5628();
            this.pos = ping.method_5829().method_1005();
            this.isFriendly = isFriendly;
            this.isShared = false;
            this.terrainType = PingTerrainType.getByEntity(ping);
            this.entityType = entityType;
        }

        private RadarPing(int id, class_243 pos, boolean isFriendly, boolean isShared, PingTerrainType terrainType, PingEntityType entityType) {
            this.id = id;
            this.pos = pos;
            this.isFriendly = isFriendly;
            this.isShared = isShared;
            this.terrainType = terrainType;
            this.entityType = entityType;
        }

        public RadarPing(class_2540 buffer) {
            this.id = buffer.readInt();
            this.pos = (class_243)DataSerializers.VEC3.method_12716(buffer);
            this.isFriendly = buffer.readBoolean();
            this.isShared = buffer.readBoolean();
            this.terrainType = PingTerrainType.getById(buffer.readByte());
            this.entityType = PingEntityType.getById(buffer.readByte());
        }

        public void write(class_2540 buffer) {
            buffer.writeInt(this.id);
            DataSerializers.VEC3.method_12715(buffer, (Object)this.pos);
            buffer.writeBoolean(this.isFriendly);
            buffer.writeBoolean(this.isShared);
            buffer.writeByte((int)this.terrainType.id);
            buffer.writeByte((int)this.entityType.id);
        }

        public boolean isShared() {
            return this.isShared;
        }

        public RadarPing getCopy(boolean isShared) {
            return new RadarPing(this.id, this.pos, this.isFriendly, isShared, this.terrainType, this.entityType);
        }

        public class_243 getPosForClient() {
            if (this.clientPos != null) {
                return this.clientPos;
            }
            return this.pos;
        }

        public void setClientPos(class_1937 level) {
            class_1297 e = level.method_8469(this.id);
            if (e == null) {
                this.clientPos = null;
                return;
            }
            this.clientPos = e.method_5829().method_1005();
        }

        public String toString() {
            return "PING[" + (int)this.pos.field_1352 + "," + (int)this.pos.field_1351 + "," + (int)this.pos.field_1350 + "]";
        }

        public boolean equals(Object o) {
            if (o instanceof RadarPing) {
                RadarPing ping = (RadarPing)o;
                if (ping.id == this.id) {
                    return true;
                }
            }
            return false;
        }

        public boolean dontDisplayByMode(RadarMode mode) {
            if (mode.isOff()) {
                return true;
            }
            if (mode.isAll()) {
                return false;
            }
            if (this.entityType.isMissile()) {
                return false;
            }
            if (mode.isMobsOnly()) {
                return !this.entityType.isMob();
            }
            if (mode.isPlayersOnly()) {
                return !this.entityType.isPlayer();
            }
            if (mode.isPlayersOrBots()) {
                return !this.entityType.isBot();
            }
            if (mode.isVehiclesOnly()) {
                return !this.entityType.isVehicle();
            }
            return false;
        }
    }
}

