/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.vehicle;

import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.ModSounds;
import com.onewhohears.dscombat.util.UtilClientSafeSounds;
import com.onewhohears.dscombat.util.UtilSound;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_3414;

public abstract class VehicleLoopingSounds {
    private static Map<String, VehicleLoopingSoundsFactory> loopFactories = new HashMap<String, VehicleLoopingSoundsFactory>();
    public final EntityVehicle parent;
    protected float prevThrottle = 0.0f;
    protected double prevVelSqr = 0.0;

    public static VehicleLoopingSounds getByType(String type, EntityVehicle parent) {
        if (loopFactories.containsKey(type)) {
            return loopFactories.get(type).create(parent);
        }
        return new BasicLooper(parent);
    }

    public static void addVehicleLoopSoundManager(String type, VehicleLoopingSoundsFactory factory) {
        loopFactories.put(type, factory);
    }

    protected VehicleLoopingSounds(EntityVehicle parent) {
        this.parent = parent;
    }

    public void baseTick() {
        if (this.prevThrottle == 0.0f && this.parent.getCurrentThrottle() != 0.0f) {
            this.onThrottleReset();
        }
        if (this.prevVelSqr <= 0.01 && this.parent.method_18798().method_1027() > 0.01) {
            this.onVelReset();
        }
        this.tick();
        this.prevThrottle = this.parent.getCurrentThrottle();
        this.prevVelSqr = this.parent.method_18798().method_1027();
    }

    public abstract void loadPreset(class_2487 var1);

    protected abstract void tick();

    protected abstract void onThrottleReset();

    protected abstract void onVelReset();

    static {
        VehicleLoopingSounds.addVehicleLoopSoundManager("basic", parent -> new BasicLooper(parent));
        VehicleLoopingSounds.addVehicleLoopSoundManager("fighter_jet", parent -> new FighterJetLooper(parent));
    }

    public static interface VehicleLoopingSoundsFactory {
        public VehicleLoopingSounds create(EntityVehicle var1);
    }

    public static class BasicLooper
    extends VehicleLoopingSounds {
        protected class_3414 nonPassengerEngine = ModSounds.BIPLANE_1;
        protected class_3414 passengerEngine = ModSounds.BIPLANE_1;

        protected BasicLooper(EntityVehicle parent) {
            super(parent);
        }

        @Override
        public void loadPreset(class_2487 sounds) {
            this.nonPassengerEngine = UtilSound.getSoundById(sounds.method_10558("nonPassengerEngine"), this.nonPassengerEngine);
            this.passengerEngine = UtilSound.getSoundById(sounds.method_10558("passengerEngine"), this.passengerEngine);
        }

        @Override
        protected void tick() {
        }

        @Override
        protected void onThrottleReset() {
            UtilClientSafeSounds.nonPassengerVehicleEngineSound(this.parent, this.nonPassengerEngine);
            UtilClientSafeSounds.passengerVehicleEngineSound(this.parent, this.passengerEngine);
        }

        @Override
        protected void onVelReset() {
        }
    }

    public static class FighterJetLooper
    extends VehicleLoopingSounds {
        protected class_3414 externalAfterBurnerClose = ModSounds.ALEXIS_EXT_AFTERBURNER_CLOSE;
        protected class_3414 externalAfterBurnerFar = ModSounds.ALEXIS_EXT_AFTERBURNER_FAR;
        protected class_3414 externalRPM = ModSounds.ALEXIS_EXT_RPM;
        protected class_3414 externalWindClose = ModSounds.ALEXIS_EXT_WIND_CLOSE;
        protected class_3414 externalWindFar = ModSounds.ALEXIS_EXT_WIND_FAR;
        protected class_3414 cockpitRPM = ModSounds.ALEXIS_CP_RPM;
        protected class_3414 cockpitAfterBurner = ModSounds.ALEXIS_CP_AFTERBURNER;
        protected class_3414 cockpitWindSlow = ModSounds.ALEXIS_CP_WIND_SLOW;
        protected class_3414 cockpitWindFast = ModSounds.ALEXIS_CP_WIND_FAST;

        protected FighterJetLooper(EntityVehicle parent) {
            super(parent);
        }

        @Override
        public void loadPreset(class_2487 sounds) {
            this.externalAfterBurnerClose = UtilSound.getSoundById(sounds.method_10558("externalAfterBurnerClose"), this.externalAfterBurnerClose);
            this.externalAfterBurnerFar = UtilSound.getSoundById(sounds.method_10558("externalAfterBurnerFar"), this.externalAfterBurnerFar);
            this.externalRPM = UtilSound.getSoundById(sounds.method_10558("externalRPM"), this.externalRPM);
            this.externalWindClose = UtilSound.getSoundById(sounds.method_10558("externalWindClose"), this.externalWindClose);
            this.externalWindFar = UtilSound.getSoundById(sounds.method_10558("externalWindFar"), this.externalWindFar);
            this.cockpitRPM = UtilSound.getSoundById(sounds.method_10558("cockpitRPM"), this.cockpitRPM);
            this.cockpitAfterBurner = UtilSound.getSoundById(sounds.method_10558("cockpitAfterBurner"), this.cockpitAfterBurner);
            this.cockpitWindSlow = UtilSound.getSoundById(sounds.method_10558("cockpitWindSlow"), this.cockpitWindSlow);
            this.cockpitWindFast = UtilSound.getSoundById(sounds.method_10558("cockpitWindFast"), this.cockpitWindFast);
        }

        @Override
        protected void tick() {
        }

        @Override
        protected void onThrottleReset() {
            UtilClientSafeSounds.nonPassengerVehicleEngineSound(this.parent, this.externalRPM, 90.0);
            UtilClientSafeSounds.nonPassengerAfterBurnerSound(this.parent, this.externalAfterBurnerClose, 90.0, 0.0f);
            UtilClientSafeSounds.nonPassengerAfterBurnerSound(this.parent, this.externalAfterBurnerFar, 250.0, 80.0f);
            UtilClientSafeSounds.passengerVehicleEngineSound(this.parent, this.cockpitRPM);
            UtilClientSafeSounds.passengerAfterBurnerSound(this.parent, this.cockpitAfterBurner);
        }

        @Override
        protected void onVelReset() {
            UtilClientSafeSounds.nonPassengerWindSound(this.parent, this.externalWindClose, 90.0, 0.0f);
            UtilClientSafeSounds.nonPassengerWindSound(this.parent, this.externalWindFar, 250.0, 80.0f);
            UtilClientSafeSounds.passengerWindSound(this.parent, this.cockpitWindSlow, 0.0);
            UtilClientSafeSounds.passengerWindSound(this.parent, this.cockpitWindFast, 1.0);
        }
    }
}

