/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.vehicle.physics;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.vehicle.physics.LiftSurfaceData;
import com.onewhohears.dscombat.data.vehicle.physics.PhysicsComponentInstance;
import com.onewhohears.onewholibs.util.UtilParse;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;

public abstract class PhysicsComponentData {
    private static final Map<String, Function<JsonObject, PhysicsComponentData>> components = new HashMap<String, Function<JsonObject, PhysicsComponentData>>();
    private final String hitbox;
    private final class_243 pos;

    public static void register() {
        components.put("lift_surface", LiftSurfaceData::new);
    }

    @Nullable
    public static PhysicsComponentData getData(JsonObject json) {
        String id = UtilParse.getStringSafe((JsonObject)json, (String)"id", (String)"");
        if (!components.containsKey(id)) {
            return null;
        }
        return components.get(id).apply(json);
    }

    public PhysicsComponentData(JsonObject json) {
        this.hitbox = UtilParse.getStringSafe((JsonObject)json, (String)"hitbox", (String)"NONE");
        this.pos = UtilParse.readVec3((JsonObject)json, (String)"pos");
    }

    public String getHitbox() {
        return this.hitbox;
    }

    public class_243 getPos() {
        return this.pos;
    }

    public abstract PhysicsComponentInstance<?> createInstance();
}

