/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.data.vehicle.physics.PhysicsComponentInstance;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.List;
import net.minecraft.class_1313;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public interface PhysicsBody {
    default public void method_36456(float yRot) {
        this.setQBySide(UtilAngles.toQuaternionF((double)this.method_36454(), (double)this.method_36455(), (double)this.getZRot()));
    }

    default public void method_36457(float xRot) {
        this.setQBySide(UtilAngles.toQuaternionF((double)this.method_36454(), (double)this.method_36455(), (double)this.getZRot()));
    }

    default public void tickPhysics() {
        QuaternionF q = this.getQBySide();
        this.setPrevDeltaMove(this.method_18798());
        this.setPrevForces(this.getForces());
        this.setPrevMoment(this.getMoment());
        this.setPrevZRot(this.getZRot());
        this.setPrevQ(q);
        this.setForces(class_243.field_1353);
        this.setMoment(class_243.field_1353);
        this.setControlMoment(class_243.field_1353);
        boolean testMode = this.isTestMode();
        boolean windTunnel = this.isInWindTunnel();
        if (testMode && !windTunnel) {
            this.method_18799(this.method_5720());
        }
        this.calcMoveStatsPre(q);
        this.calcForceMoment(q);
        this.getPhysicsInstances().forEach(instance -> instance.tick(this));
        this.calcAcc();
        this.motionClamp();
        if (!testMode) {
            this.method_5784(class_1313.field_6308, this.method_18798());
        }
        this.calcMoveStatsPost(q);
        this.calcRotAcc(q);
        if (!testMode || !windTunnel) {
            this.setQBySide(q);
            this.updateEulerAngles();
        }
    }

    default public boolean isInWindTunnel() {
        return !this.getPhysicsInstances().isEmpty() && this.getPhysicsInstances().get(0).getWindTunnel() != null;
    }

    default public void updateEulerAngles() {
        QuaternionF q = this.getQBySide();
        UtilAngles.EulerAngles angles = UtilAngles.toDegrees((QuaternionF)q);
        this.setXRotNoQ((float)angles.pitch);
        this.setYRotNoQ((float)angles.yaw);
        this.setZRot((float)angles.roll);
    }

    default public void calcRotAcc(QuaternionF q) {
        this.clampControlMoment();
        this.addMoment(this.getControlMoment(), false, true);
        this.addMoment(this.getMomentBetweenTicks(), false, true);
        class_243 m = this.getMoment().method_1021(this.getAccTimeScale());
        class_243 av = this.getAngularVel();
        if (!UtilGeometry.isZero((class_243)m)) {
            class_243 I = this.getTotalRotInertia();
            av = av.method_1031(m.field_1352 / I.field_1352, m.field_1351 / I.field_1351, m.field_1350 / I.field_1350);
            this.setAngularVel(av);
        }
        q.mul(PhysicsBody.rotateAngularVel(av));
        this.setMomentBetweenTicks(class_243.field_1353);
        this.reducePitchRateWhileRolling();
    }

    public static QuaternionF rotateAngularVel(class_243 av) {
        return new QuaternionF((float)(-av.field_1352), (float)(-av.field_1351), (float)av.field_1350, true);
    }

    default public void reducePitchRateWhileRolling() {
        if (Math.abs(this.getZRot()) < 40.0f && this.getPitchInput() == 0.0f && this.isOperational()) {
            this.setAngularVel(this.getAngularVel().method_18805(0.8, 1.0, 1.0));
        }
    }

    default public void addMoment(class_243 moment, boolean control, boolean relative) {
        if (!relative) {
            // empty if block
        }
        if (control && (!this.canUseTurnAssist() || this.isUsingTurnAssist())) {
            this.addControlMoment(moment);
        } else {
            this.setMoment(this.getMoment().method_1019(moment));
        }
    }

    default public void clampControlMoment() {
        class_243 cm = this.getControlMoment();
        if (UtilGeometry.isZero((class_243)cm)) {
            return;
        }
        class_243 I = this.getTotalRotInertia();
        class_243 av = this.getAngularVel();
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (cm.field_1352 != 0.0) {
            x = this.getControlMomentComponent(cm.field_1352, av.field_1352, this.getControlMaxDeltaPitch(), I.field_1352);
        }
        if (cm.field_1351 != 0.0) {
            y = this.getControlMomentComponent(cm.field_1351, av.field_1351, this.getControlMaxDeltaYaw(), I.field_1351);
        }
        if (cm.field_1350 != 0.0) {
            z = this.getControlMomentComponent(cm.field_1350, av.field_1350, this.getControlMaxDeltaRoll(), I.field_1350);
        }
        this.setControlMoment(new class_243(x, y, z));
    }

    public float getControlMaxDeltaPitch();

    public float getControlMaxDeltaYaw();

    public float getControlMaxDeltaRoll();

    private double getControlMomentComponent(double cm, double v, float max, double I) {
        if (Math.abs(v) > (double)max && Math.signum(v) == Math.signum(cm)) {
            return 0.0;
        }
        double a2 = cm / I * this.getAccTimeScale();
        double v2 = v + a2;
        double vd = Math.abs(v2) - (double)max;
        if (vd > 0.0) {
            cm -= vd * Math.signum(v2) * I / this.getAccTimeScale();
        }
        return cm;
    }

    default public void calcForceMoment(QuaternionF q) {
        this.calcUniversalForces(q);
        this.calcUniversalMoments(q);
        if (this.method_24828() && this.method_5799()) {
            this.calcGroundMovement(q);
            this.calcWaterMovement(q);
        } else if (this.method_24828()) {
            this.calcGroundMovement(q);
        } else if (this.method_5799()) {
            this.calcWaterMovement(q);
        } else {
            this.calcAirMovement(q);
        }
    }

    default public void calcUniversalMoments(QuaternionF q) {
        this.applyAngularDrag();
        this.addControllingTorques(q);
    }

    default public void applyAngularDrag() {
        float d;
        class_243 av = this.getAngularVel();
        float dx = d = this.getAngularDrag();
        float dy = d;
        float dz = d;
        if (!this.method_24828() || this.dontUseDriveTurnPhysics()) {
            if (this.getPitchInput() != 0.0f && Math.abs(av.field_1352) <= (double)this.getControlMaxDeltaPitch()) {
                dx = 0.0f;
            }
            if (this.getYawInput() != 0.0f && Math.abs(av.field_1351) <= (double)this.getControlMaxDeltaYaw()) {
                dy = 0.0f;
            }
            if (this.getRollInput() != 0.0f && Math.abs(av.field_1350) <= (double)this.getControlMaxDeltaRoll()) {
                dz = 0.0f;
            }
        }
        class_243 I = this.getTotalRotInertia();
        this.setAngularVel(new class_243(this.getADComponent(av.field_1352, dx, I.field_1352), this.getADComponent(av.field_1351, dy, I.field_1351), this.getADComponent(av.field_1350, dz, I.field_1350)));
    }

    default public boolean dontUseDriveTurnPhysics() {
        return false;
    }

    private double getADComponent(double v, float d, double I) {
        double a;
        double av = Math.abs(v);
        double da = (double)d / I + av * 0.01;
        if (this.isHardCodedRotAcc()) {
            double d2 = da = d > 0.0f ? (double)this.getHardCodedRotDecel() : 0.0;
        }
        if ((a = av - da) < 0.001) {
            return 0.0;
        }
        return a * Math.signum(v);
    }

    default public float getAngularDrag() {
        float d = (float)this.getFluidDensity() * this.getAngularDragScale();
        if (this.method_24828()) {
            d *= 10.0f;
        }
        return d;
    }

    public float getAngularDragScale();

    public double getFluidDensity();

    public double getAirDensity();

    public class_243 getTotalRotInertia();

    public void addControllingTorques(QuaternionF var1);

    default public void hardCodedAccPitch() {
        class_243 av = this.getAngularVel();
        double acc = this.getHardCodedRotAcc().field_1352 * (double)this.getPitchInput();
        double next = this.getAccComp(av.field_1352, acc, this.getControlMaxDeltaPitch());
        this.setAngularVel(new class_243(next, av.field_1351, av.field_1350));
    }

    default public void hardCodedAccYaw() {
        class_243 av = this.getAngularVel();
        double acc = this.getHardCodedRotAcc().field_1351 * (double)this.getYawInput();
        double next = this.getAccComp(av.field_1351, acc, this.getControlMaxDeltaYaw());
        this.setAngularVel(new class_243(av.field_1352, next, av.field_1350));
    }

    default public void hardCodedAccRoll() {
        class_243 av = this.getAngularVel();
        double acc = this.getHardCodedRotAcc().field_1350 * (double)this.getRollInput();
        double next = this.getAccComp(av.field_1350, acc, this.getControlMaxDeltaRoll());
        this.setAngularVel(new class_243(av.field_1352, av.field_1351, next));
    }

    private double getAccComp(double current, double acc, double max) {
        double c = Math.abs(current);
        if (c > max) {
            return current;
        }
        if (acc < 0.0) {
            return Math.max(current + acc, -max);
        }
        return Math.min(current + acc, max);
    }

    default public void calcUniversalForces(QuaternionF q) {
        this.addForce(this.getWeightForce());
        this.addForce(this.getThrustForce(q));
        this.addDragForce(this.getDragForce(q));
    }

    public void calcGroundMovement(QuaternionF var1);

    public void calcWaterMovement(QuaternionF var1);

    public void calcAirMovement(QuaternionF var1);

    default public class_243 getWeightForce() {
        return new class_243(0.0, (double)(-this.getTotalMass()) * this.getAccGravity(), 0.0);
    }

    public class_243 getThrustForce(QuaternionF var1);

    default public class_243 getDragForce(QuaternionF q) {
        return this.method_18798().method_1029().method_1021(-this.getDragMag());
    }

    default public class_243 calcTotalDrag(QuaternionF q) {
        class_243 d = this.getDragForce(q);
        for (PhysicsComponentInstance<?> phy : this.getPhysicsInstances()) {
            d = d.method_1019(phy.getDragForce());
        }
        return d;
    }

    default public class_243 calcTotalLift(QuaternionF q) {
        class_243 l = class_243.field_1353;
        for (PhysicsComponentInstance<?> phy : this.getPhysicsInstances()) {
            l = l.method_1019(phy.getLiftForce());
        }
        return l;
    }

    default public double getDragMag() {
        double speedSqr = this.method_18798().method_1027() * 400.0;
        return 0.5 * this.getFluidDensity() * speedSqr * this.getDragArea() * this.getDragCoefficient();
    }

    public double getDragArea();

    public double getDragCoefficient();

    default public void calcAcc() {
        class_243 f = this.getForces().method_1019(this.getForcesBetweenTicks());
        this.method_18799(this.method_18798().method_1019(this.getAccFromForce(f)));
        this.setForcesBetweenTicks(class_243.field_1353);
    }

    default public class_243 getAccFromForce(class_243 forces) {
        if (this.applyHorizontalSpeedScale()) {
            forces = forces.method_18805(this.getHorizontalSpeedScale(), 1.0, this.getHorizontalSpeedScale());
        }
        if (this.applyVerticalAccScale()) {
            forces = forces.method_18805(1.0, this.getVerticalAccScale(forces.method_10214()), 1.0);
        }
        double massScale = 1.0f / this.getTotalMass();
        return forces.method_1021(massScale).method_1021(this.getAccTimeScale());
    }

    default public double getAccFromForce(double force, boolean horizontal) {
        force = force / (double)this.getTotalMass() * this.getAccTimeScale();
        if (horizontal) {
            return force * this.getHorizontalSpeedScale();
        }
        return force * this.getVerticalAccScale(force);
    }

    default public void motionClamp() {
        class_243 move = this.method_18798();
        double goalMaxXZ = Math.min(this.getMaxSpeedForMotion(), (Double)Config.SERVER.universalTopSpeed.get() / 20.0);
        this.setLerpMaxXZ(class_3532.method_16436((double)0.01f, (double)this.getLerpMaxXZ(), (double)goalMaxXZ));
        class_243 motionXZ = new class_243(move.field_1352, 0.0, move.field_1350);
        double velXZ = motionXZ.method_1033();
        if (velXZ > this.getLerpMaxXZ()) {
            motionXZ = motionXZ.method_1021(this.getLerpMaxXZ() / velXZ);
        }
        this.method_18800(motionXZ.field_1352, this.clampYMove(move), motionXZ.field_1350);
    }

    default public double clampYMove(class_243 move) {
        double my = move.field_1351;
        if (my > this.getMaxClimbSpeed()) {
            my = this.getMaxClimbSpeed();
        } else if (my < -this.getMaxFallSpeed()) {
            my = -this.getMaxFallSpeed();
        } else if (Math.abs(my) < 0.001) {
            my = 0.0;
        }
        double decreaseSpeedPos = 100.0;
        double altitude = this.getAltitude();
        double nextY = altitude + my;
        if (nextY > this.getMaxAltitude()) {
            my = this.getMaxAltitude() - altitude;
            if (this.flattenIfMaxAltitude() && this.method_36455() < 0.0f) {
                this.flattenPitch(this.getQBySide(), 0.1f);
            }
        } else if (altitude > this.getMaxAltitude() - decreaseSpeedPos) {
            double percent = (altitude - this.getMaxAltitude() + decreaseSpeedPos) / decreaseSpeedPos;
            double maxY = 1.0 - percent;
            if (my > maxY) {
                my = maxY;
            }
            if (this.flattenIfMaxAltitude() && (double)this.method_36455() < -maxY * 20.0) {
                this.flattenPitch(this.getQBySide(), (float)(0.1 * percent));
            }
        }
        if (this.method_24828() && my < 0.0) {
            my = -0.01;
        }
        return my;
    }

    default public boolean flattenIfMaxAltitude() {
        return true;
    }

    default public void addForce(class_243 force) {
        this.setForces(this.getForces().method_1019(force));
    }

    default public void addDragForce(class_243 force) {
        class_243 m = this.method_18798();
        if (UtilGeometry.isZero((class_243)m)) {
            return;
        }
        class_243 acc = this.getAccFromForce(force);
        if (m.field_1352 != 0.0 && Math.signum(m.field_1352 + acc.field_1352) != Math.signum(m.field_1352)) {
            force = force.method_18805(0.0, 1.0, 1.0);
            m = m.method_18805(0.0, 1.0, 1.0);
        }
        if (m.field_1351 != 0.0 && Math.signum(m.field_1351 + acc.field_1351) != Math.signum(m.field_1351)) {
            force = force.method_18805(1.0, 0.0, 1.0);
            m = m.method_18805(1.0, 0.0, 1.0);
        }
        if (m.field_1350 != 0.0 && Math.signum(m.field_1350 + acc.field_1350) != Math.signum(m.field_1350)) {
            force = force.method_18805(1.0, 1.0, 0.0);
            m = m.method_18805(1.0, 1.0, 0.0);
        }
        this.method_18799(m);
        this.addForce(force);
    }

    default public void addFrictionForce(double f) {
        class_243 m = this.method_18798();
        if (m.field_1352 == 0.0 && m.field_1350 == 0.0) {
            return;
        }
        class_243 mn = m.method_1029();
        class_243 force = mn.method_1021(-f);
        class_243 acc = this.getAccFromForce(force);
        if (m.field_1352 != 0.0 && Math.signum(m.field_1352 + acc.field_1352) != Math.signum(m.field_1352)) {
            force = force.method_18805(0.0, 1.0, 1.0);
            m = m.method_18805(0.0, 1.0, 1.0);
        }
        if (m.field_1350 != 0.0 && Math.signum(m.field_1350 + acc.field_1350) != Math.signum(m.field_1350)) {
            force = force.method_18805(1.0, 1.0, 0.0);
            m = m.method_18805(1.0, 1.0, 0.0);
        }
        this.method_18799(m);
        this.setForces(this.getForces().method_1019(force));
    }

    default public void addControlMoment(class_243 moment) {
        this.setControlMoment(this.getControlMoment().method_1019(moment));
    }

    default public void addForcesBetweenTicks(class_243 forces) {
        this.setForcesBetweenTicks(this.getForcesBetweenTicks().method_1019(forces));
    }

    default public void addMomentBetweenTicks(class_243 moment) {
        this.setMomentBetweenTicks(this.getMomentBetweenTicks().method_1019(moment));
    }

    default public void addMomentX(float moment, boolean control) {
        this.addMoment(class_243.field_1353.method_1031((double)moment, 0.0, 0.0), control, true);
    }

    default public void addMomentY(float moment, boolean control) {
        this.addMoment(class_243.field_1353.method_1031(0.0, (double)moment, 0.0), control, true);
    }

    default public void addMomentZ(float moment, boolean control) {
        this.addMoment(class_243.field_1353.method_1031(0.0, 0.0, (double)moment), control, true);
    }

    default public void flattenPitch(QuaternionF q, float dPitch) {
        class_243 av = this.getAngularVel();
        float x = (float)av.field_1352;
        UtilAngles.EulerAngles angles = UtilAngles.toDegrees((QuaternionF)q);
        if (dPitch != 0.0f) {
            float diff;
            float goalPitch = 0.0f;
            if (this.method_24828()) {
                goalPitch = -this.getGroundXTilt();
            }
            float pitch = Math.abs(diff = (float)angles.pitch - goalPitch) < dPitch ? diff : Math.signum(diff) * dPitch;
            x += pitch;
        }
        this.setAngularVel(new class_243((double)x, av.field_1351, av.field_1350));
    }

    default public void flatten(QuaternionF q, float dPitch, float dRoll, boolean forced) {
        class_243 av = this.getAngularVel();
        float x = (float)av.field_1352;
        float z = (float)av.field_1350;
        if (!forced) {
            if (Math.abs(av.field_1352) <= (double)dPitch) {
                x = 0.0f;
            }
            if (Math.abs(av.field_1350) <= (double)dRoll) {
                z = 0.0f;
            }
        } else {
            z = 0.0f;
            x = 0.0f;
        }
        UtilAngles.EulerAngles angles = UtilAngles.toDegrees((QuaternionF)q);
        if (dRoll != 0.0f) {
            float roll = Math.abs(angles.roll) < (double)dRoll ? (float)(-angles.roll) : -((float)Math.signum(angles.roll)) * dRoll;
            z += roll;
        }
        if (dPitch != 0.0f) {
            float diff;
            float goalPitch = 0.0f;
            if (this.method_24828()) {
                goalPitch = -this.getGroundXTilt();
            }
            float pitch = Math.abs(diff = (float)angles.pitch - goalPitch) < dPitch ? diff : Math.signum(diff) * dPitch;
            x += pitch;
        }
        this.setAngularVel(new class_243((double)x, av.field_1351, (double)z));
    }

    default public double getHorizontalSpeedScaleOrOne() {
        if (this.applyHorizontalSpeedScale()) {
            return this.getHorizontalSpeedScale();
        }
        return 1.0;
    }

    public void method_5784(@NotNull class_1313 var1, @NotNull class_243 var2);

    public List<PhysicsComponentInstance<?>> getPhysicsInstances();

    public void calcMoveStatsPre(QuaternionF var1);

    public void calcMoveStatsPost(QuaternionF var1);

    public float getTotalMass();

    public double getAccTimeScale();

    public double getHorizontalSpeedScale();

    public boolean applyHorizontalSpeedScale();

    public double getVerticalAccScale(double var1);

    public boolean applyVerticalAccScale();

    public double getMaxSpeedForMotion();

    public double getLerpMaxXZ();

    public void setLerpMaxXZ(double var1);

    public double getMaxClimbSpeed();

    public double getMaxFallSpeed();

    public double getAltitude();

    public double getMaxAltitude();

    public double getAccGravity();

    public float getGroundXTilt();

    public boolean isHardCodedRotAcc();

    public class_243 getHardCodedRotAcc();

    public float getHardCodedRotDecel();

    public QuaternionF getQBySide();

    public void setQBySide(QuaternionF var1);

    public QuaternionF getPrevQ();

    public void setPrevQ(QuaternionF var1);

    public float method_36455();

    public float method_36454();

    public void setXRotNoQ(float var1);

    public void setYRotNoQ(float var1);

    public float getZRot();

    public void setZRot(float var1);

    public float getPrevZRot();

    public void setPrevZRot(float var1);

    public class_243 method_18798();

    public void method_18799(class_243 var1);

    public void method_18800(double var1, double var3, double var5);

    public class_243 getPrevDeltaMove();

    public void setPrevDeltaMove(class_243 var1);

    public class_243 getForces();

    public void setForces(class_243 var1);

    public class_243 getForcesBetweenTicks();

    public void setForcesBetweenTicks(class_243 var1);

    public class_243 getPrevForces();

    public void setPrevForces(class_243 var1);

    public class_243 getMoment();

    public void setMoment(class_243 var1);

    public class_243 getPrevMoment();

    public void setPrevMoment(class_243 var1);

    public class_243 getControlMoment();

    public void setControlMoment(class_243 var1);

    public class_243 getMomentBetweenTicks();

    public void setMomentBetweenTicks(class_243 var1);

    public class_243 getAngularVel();

    public void setAngularVel(class_243 var1);

    public class_243 method_5720();

    public boolean method_24828();

    public boolean method_5799();

    public boolean isTestMode();

    public boolean isArcadeMode();

    public boolean canUseTurnAssist();

    public boolean isUsingTurnAssist();

    public boolean areAllHitboxesDead(String ... var1);

    public boolean isOperational();

    public int getAge();

    public boolean isClientSide();

    public float getPitchInput();

    public float getYawInput();

    public float getRollInput();

    public boolean isFlapsDown();

    public void debug(String var1);
}

