/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.weapon;

import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.data.weapon.WeaponType;
import com.onewhohears.dscombat.data.weapon.stats.BulletStats;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.damagesource.WeaponDamageSource;
import com.onewhohears.dscombat.entity.weapon.EntityWeapon;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_243;

public class EntityBullet<T extends BulletStats>
extends EntityWeapon<T> {
    public EntityBullet(class_1299<? extends EntityBullet<?>> type, class_1937 level, String defaultWeaponId) {
        super(type, level, defaultWeaponId);
    }

    @Override
    public WeaponType getWeaponType() {
        return WeaponType.BULLET;
    }

    @Override
    public void init() {
        super.init();
        class_243 dir = UtilAngles.rotationToVector((double)this.method_36454(), (double)this.method_36455());
        this.method_18799(dir.method_1021(this.getSpeed()));
    }

    protected void checkExplode() {
        if (this.getAge() < this.minExplodeAge()) {
            return;
        }
        if (!this.getWorld().method_8393(this.method_31476().field_9181, this.method_31476().field_9180)) {
            return;
        }
        if (!this.isClientSide() && this.getExplosive()) {
            class_1927.class_4179 interact = class_1927.class_4179.field_18685;
            if (this.getTerrain() && this.getWorld().method_8450().method_8355(DSCGameRules.WEAPONS_BREAK_BLOCKS)) {
                interact = class_1927.class_4179.field_18686;
            }
            for (int i = 0; i < this.getExplodeNum(); ++i) {
                this.getWorld().method_8454((class_1297)this, (class_1282)this.getExplosionDamageSource(), null, this.method_23317(), this.method_23318(), this.method_23321(), this.getRadius(), this.getFire(), interact);
            }
        }
    }

    public int minExplodeAge() {
        return 1;
    }

    @Override
    public float getDamage() {
        return ((BulletStats)((Object)this.getWeaponStats())).getDamage();
    }

    public boolean getExplosive() {
        return ((BulletStats)((Object)this.getWeaponStats())).isExplosive();
    }

    public boolean getTerrain() {
        return ((BulletStats)((Object)this.getWeaponStats())).isDestroyTerrain();
    }

    public boolean getFire() {
        return ((BulletStats)((Object)this.getWeaponStats())).isCausesFire();
    }

    public float getRadius() {
        return ((BulletStats)((Object)this.getWeaponStats())).getExplosionRadius();
    }

    public double getSpeed() {
        return ((BulletStats)((Object)this.getWeaponStats())).getSpeed();
    }

    public int getExplodeNum() {
        return ((BulletStats)((Object)this.getWeaponStats())).getExplodeNum();
    }

    @Override
    public void method_5768() {
        super.method_5768();
        this.checkExplode();
    }

    @Override
    protected WeaponDamageSource getImpactDamageSource() {
        return WeaponDamageSource.WeaponDamageType.BULLET.getSource(this.method_24921(), this);
    }

    @Override
    protected WeaponDamageSource getExplosionDamageSource() {
        return WeaponDamageSource.WeaponDamageType.BULLET_EXPLODE.getSource(this.method_24921(), this);
    }

    @Override
    public WeaponStats.WeaponClientImpactType getClientImpactType() {
        if (this.getExplosive()) {
            return WeaponStats.WeaponClientImpactType.SMALL_BULLET_EXPLODE;
        }
        return WeaponStats.WeaponClientImpactType.SMALL_BULLET_IMPACT;
    }
}

