/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.weapon;

import com.onewhohears.dscombat.data.weapon.WeaponType;
import com.onewhohears.dscombat.data.weapon.stats.BunkerBusterStats;
import com.onewhohears.dscombat.entity.weapon.EntityBomb;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import java.util.Iterator;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;

public class EntityBunkerBuster<T extends BunkerBusterStats>
extends EntityBomb<T> {
    public static final class_2940<Integer> BLOCK_STRENGTH = class_2945.method_12791(EntityBunkerBuster.class, (class_2941)class_2943.field_13327);

    public EntityBunkerBuster(class_1299<? extends EntityBunkerBuster<?>> type, class_1937 level, String defaultWeaponId) {
        super((class_1299<? extends EntityBomb<?>>)type, level, defaultWeaponId);
        if (this.getWeaponStats() != null) {
            this.setBlockStrength(((BunkerBusterStats)((Object)this.getWeaponStats())).getBlockStrength());
        }
    }

    @Override
    public WeaponType getWeaponType() {
        return WeaponType.BUNKER_BUSTER;
    }

    @Override
    protected class_3965 checkBlockCollide() {
        Iterator it = this.getWorld().method_20812((class_1297)this, this.method_5829().method_18804(this.method_18798())).iterator();
        class_1297 owner = this.method_24921();
        while (it.hasNext()) {
            class_265 voxel = (class_265)it.next();
            class_2338 pos = new class_2338(voxel.method_1107().method_1005());
            class_2680 state = this.getWorld().method_8320(pos);
            int hit_block_strength = this.getBlockStrength(pos, state);
            if (this.getBlockStrength() >= hit_block_strength && UtilVehicleEntity.weaponHasPermissionToBreak(pos, state, this.getWorld(), owner)) {
                this.getWorld().method_8651(pos, true, (class_1297)this);
                this.reduceBlockStrength(hit_block_strength);
                continue;
            }
            return new class_3965(voxel.method_1107().method_1005(), this.method_5735(), pos, false);
        }
        class_243 p = this.method_19538().method_1019(this.method_18798());
        return class_3965.method_17778((class_243)p, (class_2350)this.method_5735(), (class_2338)new class_2338(p));
    }

    protected int getBlockStrength(class_2338 pos, class_2680 state) {
        if (state.method_27852(class_2246.field_9987)) {
            return Integer.MAX_VALUE;
        }
        if (state.method_26164(ModTags.Blocks.ABSORBENT)) {
            return 50;
        }
        return (int)state.method_26204().method_9520();
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(BLOCK_STRENGTH, (Object)0);
    }

    @Override
    public void method_5749(@NotNull class_2487 compound) {
        super.method_5749(compound);
        this.setBlockStrength(compound.method_10550("blockStrength"));
    }

    @Override
    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("blockStrength", this.getBlockStrength());
    }

    public int getBlockStrength() {
        return (Integer)this.field_6011.method_12789(BLOCK_STRENGTH);
    }

    public void setBlockStrength(int block_strength) {
        this.field_6011.method_12778(BLOCK_STRENGTH, (Object)block_strength);
    }

    public void reduceBlockStrength(int num) {
        this.setBlockStrength(Math.max(this.getBlockStrength() - num, 0));
    }
}

