/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.weapon;

import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.common.network.toclient.ToClientWeaponImpact;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.data.weapon.WeaponType;
import com.onewhohears.dscombat.data.weapon.client.WeaponAssets;
import com.onewhohears.dscombat.data.weapon.client.WeaponClientStats;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.damagesource.WeaponDamageSource;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetAssetReader;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetReloadListener;
import com.onewhohears.onewholibs.entity.CustomAnimProjectile;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilParse;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_270;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EntityWeapon<T extends WeaponStats>
extends CustomAnimProjectile<T, WeaponClientStats> {
    public static final class_2940<Integer> OWNER_ID = class_2945.method_12791(EntityWeapon.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> AGE = class_2945.method_12791(EntityWeapon.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> TEST_MODE = class_2945.method_12791(EntityWeapon.class, (class_2941)class_2943.field_13323);
    public static final class_2940<class_243> SHOOT_POS = class_2945.method_12791(EntityWeapon.class, DataSerializers.VEC3);
    @NotNull
    protected class_243 throughBlockMove = class_243.field_1353;

    public EntityWeapon(class_1299<? extends EntityWeapon<?>> type, class_1937 level, String defaultWeaponId) {
        super(type, level, defaultWeaponId);
    }

    protected void method_5693() {
        this.field_6011.method_12784(OWNER_ID, (Object)-1);
        this.field_6011.method_12784(AGE, (Object)0);
        this.field_6011.method_12784(TEST_MODE, (Object)false);
        this.field_6011.method_12784(SHOOT_POS, (Object)class_243.field_1353);
    }

    public void method_5674(class_2940<?> key) {
        if (this.isClientSide() && key.equals(AGE)) {
            this.field_6012 = (Integer)this.field_6011.method_12789(AGE);
        }
    }

    public void method_5749(@NotNull class_2487 compound) {
        super.method_5749(compound);
        this.field_6012 = compound.method_10550("tickCount");
        if (this.method_24921() != null) {
            this.setOwnerId(this.method_24921().method_5628());
        } else {
            this.setOwnerId(-1);
        }
        this.setTestMode(compound.method_10577("test_mode"));
        this.setShootPos(UtilParse.readVec3((class_2487)compound, (String)"shoot_pos"));
    }

    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("tickCount", this.field_6012);
        compound.method_10556("test_mode", this.isTestMode());
        UtilParse.writeVec3((class_2487)compound, (class_243)this.getShootPos(), (String)"shoot_pos");
    }

    public T getWeaponStats() {
        return (T)((Object)((WeaponStats)this.getStats()));
    }

    public void init() {
    }

    public void method_5773() {
        if (this.isTestMode()) {
            return;
        }
        if (this.field_5953) {
            this.init();
        }
        if (!this.isClientSide() && this.field_5953) {
            this.setShootPos(this.method_19538());
        }
        super.method_5773();
        this.tickCheckCollide();
        this.tickSetMove();
        this.tickSetAngle();
        this.method_33574(this.method_19538().method_1019(this.method_18798()).method_1020(this.throughBlockMove));
        this.throughBlockMove = class_243.field_1353;
        this.method_5852();
        this.tickAge();
    }

    protected void tickAge() {
        if (!this.isClientSide()) {
            this.setAge(this.field_6012);
            if (this.field_6012 > this.getMaxAge()) {
                this.method_5768();
            }
        }
    }

    public class_3959.class_242 getFluidClipContext() {
        return class_3959.class_242.field_1348;
    }

    protected void tickCheckCollide() {
        class_243 move = this.method_18798();
        class_243 pos = this.method_19538();
        class_243 next_pos = pos.method_1019(move);
        class_3965 hitresult = this.checkBlockCollide();
        if (hitresult.method_17783() != class_239.class_240.field_1333) {
            next_pos = hitresult.method_17784();
        }
        class_1297 owner = this.method_24921();
        while (!this.method_31481()) {
            class_1297 hit;
            class_3966 entityhitresult = this.findHitEntity(pos, next_pos);
            if (entityhitresult != null) {
                hitresult = entityhitresult;
            }
            if (owner != null && hitresult != null && hitresult.method_17783() == class_239.class_240.field_1331 && this.shouldSkipCollide(hit = ((class_3966)hitresult).method_17782(), owner)) {
                hitresult = null;
                entityhitresult = null;
            }
            if (hitresult != null && hitresult.method_17783() != class_239.class_240.field_1333 && !this.field_5960) {
                this.method_7488((class_239)hitresult);
                this.field_6007 = true;
                break;
            }
            if (entityhitresult == null) break;
            hitresult = null;
        }
    }

    private boolean shouldSkipCollide(class_1297 hit, class_1297 owner) {
        return this.isClientSide() != UtilEntity.getLevel((class_1297)hit).method_8608() || hit.method_5722(owner);
    }

    protected class_3965 checkBlockCollide() {
        return this.getWorld().method_17742(new class_3959(this.method_19538(), this.method_19538().method_1019(this.method_18798()).method_1020(this.throughBlockMove), class_3959.class_3960.field_17558, this.getFluidClipContext(), (class_1297)this));
    }

    public class_1937 getWorld() {
        return UtilEntity.getLevel((class_1297)this);
    }

    @Nullable
    protected class_3966 findHitEntity(class_243 start, class_243 end) {
        return UtilEntity.getEntityHitResultAtClip((class_1937)this.getWorld(), (class_1297)this, (class_243)start, (class_243)end, (class_238)this.method_5829().method_18804(this.method_18798()).method_1014(1.0), this::method_26958, (float)0.3f);
    }

    public boolean method_26958(class_1297 entity) {
        return super.method_26958(entity) && !this.method_5722(entity);
    }

    public void method_7488(class_239 result) {
        if (this.method_31481()) {
            return;
        }
        this.throughBlockMove = this.throughBlockMove.method_1019(result.method_17784().method_1020(this.method_19538()));
        this.method_33574(result.method_17784());
        super.method_7488(result);
    }

    public void method_24920(class_3965 result) {
        class_2680 state;
        super.method_24920(result);
        if (this.canBreakFragileBlocks() && (state = this.getWorld().method_8320(result.method_17777())).method_26164(ModTags.Blocks.FRAGILE) && this.getWorld().method_8450().method_8355(DSCGameRules.WEAPONS_BREAK_BLOCKS) && UtilVehicleEntity.weaponHasPermissionToBreak(result.method_17777(), state, this.getWorld(), this.method_24921())) {
            this.getWorld().method_8651(result.method_17777(), true, (class_1297)this);
            class_3965 blockHitResult = this.checkBlockCollide();
            if (blockHitResult != null && blockHitResult.method_17783() == class_239.class_240.field_1332) {
                this.method_7488((class_239)blockHitResult);
            }
            return;
        }
        this.method_5768();
    }

    public void method_7454(class_3966 result) {
        super.method_7454(result);
        this.method_5768();
        result.method_17782().method_5643((class_1282)this.getImpactDamageSource(), this.getDamage());
    }

    public void method_5768() {
        if (!this.isClientSide() && this.field_6012 > 4) {
            PacketHandler.sendToTrackers(new ToClientWeaponImpact(this, this.method_19538()), (class_1297)this);
        }
        super.method_5768();
    }

    public float getDamage() {
        return 0.0f;
    }

    protected int getOwnerId() {
        return (Integer)this.field_6011.method_12789(OWNER_ID);
    }

    protected void setOwnerId(int id) {
        this.field_6011.method_12778(OWNER_ID, (Object)id);
    }

    protected void setAge(int age) {
        this.field_6011.method_12778(AGE, (Object)age);
    }

    public int getAge() {
        if (!this.isClientSide()) {
            return this.field_6012;
        }
        return (Integer)this.field_6011.method_12789(AGE);
    }

    public boolean method_5659() {
        return true;
    }

    public boolean method_30948() {
        return false;
    }

    public boolean method_5643(class_1282 source, float amount) {
        return false;
    }

    public boolean method_5640(double dist) {
        return dist < 65536.0;
    }

    protected void tickSetMove() {
        this.method_18799(this.method_18798().method_1031(0.0, -this.getGravityAcc(), 0.0));
    }

    protected double getGravityAcc() {
        return 0.024525;
    }

    protected void tickSetAngle() {
        if (this.getAge() > this.getSetAngleTicks()) {
            float goalPitch = UtilAngles.getPitch((class_243)this.method_18798());
            float goalYaw = UtilAngles.getYaw((class_243)this.method_18798());
            this.method_36457(goalPitch);
            this.method_36456(goalYaw);
        }
    }

    protected int getSetAngleTicks() {
        return 4;
    }

    public void method_5750(double x, double y, double z) {
        if (this.getAge() > this.getLerpWaitTicks()) {
            super.method_5750(x, y, z);
        }
    }

    protected int getLerpWaitTicks() {
        return 4;
    }

    public class_1297 method_24921() {
        class_1297 o = super.method_24921();
        if (o == null && this.isClientSide()) {
            class_310 m = class_310.method_1551();
            o = m.field_1687.method_8469(this.getOwnerId());
        }
        return o;
    }

    public void method_7432(class_1297 owner) {
        super.method_7432(owner);
        if (owner != null) {
            this.setOwnerId(owner.method_5628());
        } else {
            this.setOwnerId(-1);
        }
    }

    public boolean method_5722(class_1297 entity) {
        class_1676 p;
        class_1297 po;
        if (entity == null) {
            return false;
        }
        class_1297 o = this.method_24921();
        if (entity.equals((Object)o)) {
            return true;
        }
        if (entity instanceof class_1676 && (po = (p = (class_1676)entity).method_24921()) != null && po.equals((Object)o)) {
            return true;
        }
        class_1297 c = entity.method_5642();
        if (c != null) {
            if (c.equals((Object)o)) {
                return true;
            }
            return this.method_5645(c.method_5781());
        }
        return super.method_5722(entity);
    }

    public boolean method_5645(class_270 team) {
        if (team == null) {
            return false;
        }
        class_1297 o = this.method_24921();
        if (o != null) {
            return team.method_1206(o.method_5781());
        }
        return super.method_5645(team);
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
    }

    public void method_5982() {
        if (this.isTestMode()) {
            return;
        }
        if (!this.isClientSide() && !this.inEntityTickingRange()) {
            this.method_31472();
            return;
        }
    }

    public boolean inEntityTickingRange() {
        if (this.isClientSide()) {
            return true;
        }
        class_3218 sl = (class_3218)this.getWorld();
        class_3215 scc = sl.method_14178();
        return scc.field_17254.method_17263().method_38630(this.method_31476().method_8324());
    }

    public int getMaxAge() {
        return ((WeaponStats)((Object)this.getWeaponStats())).getMaxAge();
    }

    public boolean isTestMode() {
        return (Boolean)this.field_6011.method_12789(TEST_MODE);
    }

    public void setTestMode(boolean testMode) {
        this.field_6011.method_12778(TEST_MODE, (Object)testMode);
    }

    public class_243 getShootPos() {
        return (class_243)this.field_6011.method_12789(SHOOT_POS);
    }

    private void setShootPos(class_243 pos) {
        this.field_6011.method_12778(SHOOT_POS, (Object)pos);
    }

    public String getModelId() {
        if (this.getAssets() == null) {
            return this.getAssetId();
        }
        return ((WeaponClientStats)this.getAssets()).getModelId();
    }

    public abstract WeaponType getWeaponType();

    protected abstract WeaponDamageSource getImpactDamageSource();

    protected abstract WeaponDamageSource getExplosionDamageSource();

    public abstract WeaponStats.WeaponClientImpactType getClientImpactType();

    public boolean canBreakFragileBlocks() {
        return true;
    }

    @Nullable
    public String getAssetId() {
        return ((WeaponStats)this.getStats()).getAssetId();
    }

    @Nullable
    public JsonPresetAssetReader<WeaponClientStats> getClientPresets() {
        if (!this.isClientSide()) {
            return null;
        }
        return WeaponAssets.get();
    }

    @NotNull
    public JsonPresetReloadListener<T> getPresets() {
        return WeaponPresets.get();
    }

    public boolean isDiscardedButTicking() {
        return false;
    }
}

