/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.integration.distant_players;

import com.onewhohears.distant_players.common.core.extra_render_info.ExtraRenderTargetInfo;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;

public class DSCVehicleRenderInfo
implements ExtraRenderTargetInfo {
    private String preset = "wooden_plane";
    private QuaternionF q = QuaternionF.ONE;
    private boolean landingGear = false;
    private float throttle = 0.0f;
    private int baseTextureIndex = 0;

    public void tickFakeEntity(@NotNull class_1297 entity) {
        if (!(entity instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)entity;
        vehicle.clientTick();
    }

    public void updateFakeEntity(@NotNull class_1297 entity) {
        if (!(entity instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)entity;
        vehicle.setPreset(this.preset);
        vehicle.updateClientStatsHolder();
        vehicle.setPrevQ(this.q);
        vehicle.setClientQ(this.q);
        vehicle.setLandingGear(this.landingGear);
        vehicle.setCurrentThrottle(this.throttle);
        vehicle.textureManager.setBaseTexture(this.baseTextureIndex);
    }

    public void setupEntityOnCreate(@NotNull class_1297 entity) {
        if (!(entity instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)entity;
        vehicle.setPreset(this.preset);
        vehicle.updateClientStatsHolder();
        vehicle.textureManager.setupTextureLocations();
        vehicle.textureManager.setupDynamicTexture();
    }

    public void getInfoServerSide(@NotNull class_1297 entity) {
        if (!(entity instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)entity;
        this.preset = vehicle.getStatsId();
        this.q = vehicle.getQBySide();
        this.landingGear = vehicle.isLandingGear();
        this.throttle = vehicle.getCurrentThrottle();
        this.baseTextureIndex = vehicle.textureManager.getBaseTextureIndex();
    }

    public void getInfoClientSide(class_2540 buffer) {
        this.preset = buffer.method_19772();
        this.q = (QuaternionF)DataSerializers.QUATERNION.method_12716(buffer);
        this.landingGear = buffer.readBoolean();
        this.throttle = buffer.readFloat();
        this.baseTextureIndex = buffer.readInt();
    }

    public void encodeInfoServerSide(class_2540 buffer) {
        buffer.method_10814(this.preset);
        DataSerializers.QUATERNION.method_12715(buffer, (Object)this.q);
        buffer.writeBoolean(this.landingGear);
        buffer.writeFloat(this.throttle);
        buffer.writeInt(this.baseTextureIndex);
    }

    public class_243 onRender(@NotNull class_1297 entity, class_4587 poseStack, class_4184 camera, float yaw, class_243 renderDisplacement, float partialTick, class_4597 buffer, int packedLight) {
        return renderDisplacement;
    }
}

