/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.item;

import com.onewhohears.dscombat.data.parts.PartPresets;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.dscombat.init.ModItems;
import com.onewhohears.dscombat.item.ItemVehicle;
import com.onewhohears.dscombat.util.UtilPresetParse;
import com.onewhohears.onewholibs.util.UtilItem;
import java.util.List;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemPart
extends class_1792 {
    @NotNull
    private String defaultPresetId = "";

    public ItemPart(int stackSize, @NotNull String defaultPresetId) {
        this(ItemPart.partProps(stackSize), defaultPresetId);
    }

    public ItemPart(class_1792.class_1793 props, @NotNull String defaultPresetId) {
        super(props);
        this.defaultPresetId = defaultPresetId;
    }

    public ItemPart(int stackSize) {
        super(ItemPart.partProps(stackSize));
    }

    public ItemPart(class_1792.class_1793 props) {
        super(props);
    }

    public static class_1792.class_1793 partProps(int stackSize) {
        return new class_1792.class_1793().method_7892(ModItems.PARTS).method_7889(stackSize);
    }

    public static class_1792.class_1793 itemProps(int stackSize) {
        return new class_1792.class_1793().method_7892(ModItems.DSC_ITEMS).method_7889(stackSize);
    }

    public void method_7850(@NotNull class_1761 group, @NotNull class_2371<class_1799> items) {
        if (group != this.getCreativeTab() && group != class_1761.field_7915) {
            return;
        }
        String itemId = UtilItem.getItemKeyString((class_1792)this);
        for (int i = 0; i < PartPresets.get().getNum(); ++i) {
            PartStats stats = ((PartStats[])PartPresets.get().getAll())[i];
            if (!stats.getItemId().equals(itemId)) continue;
            this.fillItemCategory(stats, items);
        }
    }

    protected void fillItemCategory(PartStats stats, class_2371<class_1799> items) {
        items.add((Object)stats.createFilledPartInstance("").getNewItemStack());
    }

    public class_1761 getCreativeTab() {
        return ModItems.PARTS;
    }

    @Nullable
    public PartStats getDefaultPartStats() {
        return (PartStats)PartPresets.get().get(this.getDefaultPartPresetId());
    }

    public String getDefaultPartPresetId() {
        if (this.defaultPresetId.isEmpty()) {
            this.defaultPresetId = this.toString();
        }
        return this.defaultPresetId;
    }

    @NotNull
    public class_1799 method_7854() {
        class_1799 stack = new class_1799((class_1935)this);
        PartStats stats = this.getDefaultPartStats();
        if (stats != null) {
            stack.method_7980(stats.createPartInstance().writeNBT());
        }
        return stack;
    }

    @NotNull
    public class_2561 method_7864(@NotNull class_1799 stack) {
        PartInstance<?> instance = this.getPartInstance(stack);
        if (instance != null) {
            return instance.getItemName();
        }
        return super.method_7864(stack);
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> tips, @NotNull class_1836 isAdvanced) {
        super.method_7851(stack, level, tips, isAdvanced);
        PartInstance<?> instance = this.getPartInstance(stack);
        if (instance != null) {
            instance.addToolTips(tips, isAdvanced);
            if (isAdvanced.method_8035()) {
                tips.add(ItemVehicle.formatTooltip("PartId", instance.getStatsId()));
            }
        }
    }

    @Nullable
    public PartInstance<?> getPartInstance(class_1799 stack) {
        return UtilPresetParse.parsePartFromItem(stack, this.getDefaultPartPresetId());
    }

    @NotNull
    public String getPreset(@NotNull class_1799 stack) {
        PartStats stats = UtilPresetParse.getPartStatsFromItem(stack);
        if (stats == null) {
            return this.getDefaultPartPresetId();
        }
        return stats.getId();
    }

    @NotNull
    public class_1792 method_8389() {
        return this;
    }
}

