/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.item;

import com.onewhohears.dscombat.data.parts.client.PartAssets;
import com.onewhohears.dscombat.data.parts.client.PartClientStats;
import com.onewhohears.dscombat.data.parts.instance.TurretInstance;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.init.ModItems;
import com.onewhohears.dscombat.item.ItemPart;
import com.onewhohears.dscombat.item.fabric.ItemTurretImpl;
import com.onewhohears.dscombat.util.UtilPresetParse;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import com.onewhohears.onewholibs.item.ObjModelItem;
import com.onewhohears.onewholibs.util.UtilMCText;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class ItemTurret
extends ItemPart
implements ObjModelItem {
    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemTurret create(int stackSize, String defaultPresetId) {
        void var1_1;
        return ItemTurretImpl.create(stackSize, (String)var1_1);
    }

    public ItemTurret(int stackSize, String defaultPresetId) {
        super(stackSize, defaultPresetId);
    }

    @Override
    @NotNull
    public class_2561 method_7864(@NotNull class_1799 stack) {
        TurretInstance data = (TurretInstance)UtilPresetParse.parsePartFromItem(stack);
        if (data == null) {
            return super.method_7864(stack);
        }
        class_5250 name = ((class_5250)super.method_7864(stack)).method_27693(" ");
        String weapon = data.getWeaponId();
        if (weapon.isEmpty()) {
            name.method_27693("EMPTY");
        } else {
            WeaponStats wd = WeaponPresets.get().get(weapon);
            if (wd != null) {
                name.method_10852((class_2561)wd.getDisplayNameComponent()).method_27693(" ").method_10852((class_2561)UtilMCText.literal((String)wd.getWeaponTypeCode()));
            } else {
                name.method_27693(weapon + "?");
            }
        }
        int ammo = (int)data.getCurrentAmmo();
        int max = (int)data.getMaxAmmo();
        if (max != 0) {
            name.method_27693(" " + ammo + "/" + max);
        }
        return name;
    }

    @Override
    protected void fillItemCategory(PartStats stats, class_2371<class_1799> items) {
        List<String> list = WeaponPresets.get().getCompatibleWeapons(stats.getId());
        for (String s : list) {
            this.addTurret(stats, s, items);
        }
    }

    private void addTurret(PartStats stats, String preset, class_2371<class_1799> items) {
        class_1799 turret = new class_1799((class_1935)this);
        if (stats != null) {
            turret.method_7980(stats.createFilledPartInstance(preset).writeNBT());
        }
        items.add((Object)turret);
    }

    @Override
    public class_1761 getCreativeTab() {
        return ModItems.WEAPON_PARTS;
    }

    public TurretInstance<?> getTurretInstance(class_1799 stack) {
        return (TurretInstance)this.getPartInstance(stack);
    }

    @NotNull
    public String getObjModelId(@NotNull String preset) {
        PartClientStats pcs = PartAssets.get().get(preset);
        if (pcs == null) {
            return "";
        }
        return pcs.getModelId();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ObjEntityModels.ModelOverrides getItemModelOverrides(@NotNull String preset) {
        PartClientStats pcs = PartAssets.get().get(preset);
        if (pcs == null) {
            return ObjEntityModels.NO_OVERRIDES;
        }
        return pcs.getItemModelOverrides();
    }
}

