/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.item;

import com.onewhohears.dscombat.data.vehicle.VehiclePresets;
import com.onewhohears.dscombat.data.vehicle.client.VehicleClientPresets;
import com.onewhohears.dscombat.data.vehicle.client.VehicleClientStats;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.ModItems;
import com.onewhohears.dscombat.item.fabric.ItemVehicleImpl;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import com.onewhohears.onewholibs.item.ObjModelItem;
import com.onewhohears.onewholibs.util.UtilMCText;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3468;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemVehicle
extends class_1792
implements ObjModelItem {
    private static final Predicate<class_1297> ENTITY_PREDICATE = class_1301.field_6155.and(class_1297::method_5863);
    private final String defaultPreset;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemVehicle create(String defaultPresetId) {
        return ItemVehicleImpl.create(defaultPresetId);
    }

    public ItemVehicle(String defaultPreset) {
        super(new class_1792.class_1793().method_7892(ModItems.VEHICLES).method_7889(1));
        this.defaultPreset = defaultPreset;
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, class_1657 player, @NotNull class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        class_3965 hitresult = ItemVehicle.method_7872((class_1937)level, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1347);
        if (hitresult.method_17783() == class_239.class_240.field_1333) {
            return class_1271.method_22430((Object)itemstack);
        }
        class_243 vec3 = player.method_5828(1.0f);
        List list = level.method_8333((class_1297)player, player.method_5829().method_18804(vec3.method_1021(5.0)).method_1014(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            class_243 vec31 = player.method_33571();
            for (class_1297 entity : list) {
                class_238 aabb = entity.method_5829().method_1014((double)entity.method_5871());
                if (!aabb.method_1006(vec31)) continue;
                return class_1271.method_22430((Object)itemstack);
            }
        }
        if (hitresult.method_17783() == class_239.class_240.field_1332) {
            String presetName = this.getPresetName(itemstack);
            VehicleStats vs = (VehicleStats)VehiclePresets.get().get(presetName);
            if (vs == null) {
                vs = (VehicleStats)VehiclePresets.get().get(this.defaultPreset);
            }
            class_1299<? extends EntityVehicle> entityType = vs.getEntityType();
            class_1799 spawn_data_stack = this.spawnData(itemstack, player, vs.getId());
            EntityVehicle e = (EntityVehicle)entityType.method_5883(level);
            class_243 pos = hitresult.method_17784();
            if (e.isCustomBoundingBox()) {
                e.method_33574(pos.method_1031(0.0, (double)e.method_17682() / 2.0, 0.0));
            } else {
                e.method_33574(pos);
            }
            if (!level.method_8587((class_1297)e, e.method_5829())) {
                return class_1271.method_22431((Object)itemstack);
            }
            if (!level.method_8608()) {
                class_1297 entity;
                int above = 0;
                if (e.isCustomBoundingBox()) {
                    above = (int)((double)e.method_17682() / 2.0) + 1;
                }
                if ((entity = entityType.method_5894((class_3218)level, spawn_data_stack, player, new class_2338(pos).method_10086(above), class_3730.field_16465, false, false)) != null) {
                    level.method_43275((class_1297)player, class_5712.field_28738, pos);
                    itemstack.method_7934(1);
                }
            }
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
            return class_1271.method_29237((Object)itemstack, (boolean)level.method_8608());
        }
        return class_1271.method_22430((Object)itemstack);
    }

    private class_1799 spawnData(class_1799 itemstack, class_1657 player, String preset) {
        class_2487 display;
        class_2487 et;
        class_1799 copy = itemstack.method_7972();
        class_2487 tag = copy.method_7948();
        if (!tag.method_10573("EntityTag", 10)) {
            et = new class_2487();
            et.method_10556("merged_preset", false);
            et.method_25927("owner_id", player.method_5667());
            tag.method_10566("EntityTag", (class_2520)et);
        }
        et = tag.method_10562("EntityTag");
        et.method_10582("preset", preset);
        et.method_10548("yRot", player.method_36454());
        et.method_10548("current_throttle", 0.0f);
        et.method_10556("landing_gear", true);
        if (tag.method_10573("display", 10) && (display = tag.method_10562("display")).method_10573("Name", 8)) {
            et.method_10582("CustomName", display.method_10558("Name"));
            et.method_10556("CustomNameVisible", true);
        }
        return copy;
    }

    public String getPresetName(class_1799 itemstack) {
        class_2487 eTag;
        class_2487 tag = itemstack.method_7969();
        if (tag == null) {
            return this.defaultPreset;
        }
        if (tag.method_10545("preset")) {
            return tag.method_10558("preset");
        }
        if (tag.method_10545("EntityTag") && (eTag = tag.method_10562("EntityTag")).method_10545("preset")) {
            return eTag.method_10558("preset");
        }
        return this.defaultPreset;
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> tips, @NotNull class_1836 isAdvanced) {
        super.method_7851(stack, level, tips, isAdvanced);
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10545("EntityTag")) {
            class_2487 et = tag.method_10562("EntityTag");
            if (et.method_10545("health")) {
                tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.health").method_27693(": " + (int)et.method_10583("health")).method_10862(class_2583.field_24360.method_36139(0xAAAAAA)));
            }
            if (et.method_10545("fuel")) {
                tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.fuel").method_27693(": " + (int)et.method_10583("fuel")).method_10862(class_2583.field_24360.method_36139(0xAAAAAA)));
            }
            if (et.method_10545("flares")) {
                tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.flares").method_27693(": " + (int)et.method_10583("flares")).method_10862(class_2583.field_24360.method_36139(0xAAAAAA)));
            }
        }
        if (isAdvanced.method_8035()) {
            tips.add(ItemVehicle.formatTooltip("VehicleId", this.getPreset(stack)));
        }
    }

    public static class_2561 formatTooltip(String key, String value) {
        return class_2561.method_43470((String)String.format("%s: \"%s\"", key, value)).method_27692(class_124.field_1063);
    }

    @NotNull
    public class_2561 method_7864(class_1799 stack) {
        String owner;
        class_2487 tag = stack.method_7969();
        String presetId = this.getPresetName(stack);
        VehicleStats vs = (VehicleStats)VehiclePresets.get().get(presetId);
        if (tag == null || !tag.method_10545("EntityTag")) {
            if (vs == null) {
                return UtilMCText.translatable((String)this.method_7876()).method_27693(" unknown preset!");
            }
            return vs.getDisplayNameComponent().method_10862(class_2583.field_24360.method_36139(0x55FFFF));
        }
        class_2487 etag = tag.method_10562("EntityTag");
        if (etag.method_10573("CustomName", 8)) {
            String cn = etag.method_10558("CustomName");
            try {
                return class_2561.class_2562.method_10877((String)cn);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((owner = etag.method_10558("owner_name")).isEmpty()) {
            owner = "Someone";
        }
        class_5250 component = UtilMCText.literal((String)(owner + "'s ")).method_10862(class_2583.field_24360.method_36139(0xFFAA00).method_10982(Boolean.valueOf(true)));
        if (vs == null) {
            return component.method_10852(super.method_7864(stack));
        }
        return component.method_10852((class_2561)vs.getBaseDisplayName());
    }

    public boolean method_7886(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag != null && tag.method_10545("EntityTag");
    }

    public void method_7850(@NotNull class_1761 group, @NotNull class_2371<class_1799> items) {
        VehicleStats[] presets;
        if (group != ModItems.VEHICLES && group != class_1761.field_7915) {
            return;
        }
        for (VehicleStats preset : presets = (VehicleStats[])VehiclePresets.get().getAll()) {
            if (!preset.getItem().method_31574((class_1792)this)) continue;
            class_1799 stack = new class_1799((class_1935)this);
            stack.method_7948().method_10582("preset", preset.getId());
            items.add((Object)stack);
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ObjEntityModels.ModelOverrides getItemModelOverrides(@NotNull String preset) {
        VehicleStats vs = (VehicleStats)VehiclePresets.get().get(preset);
        if (vs == null) {
            vs = (VehicleStats)VehiclePresets.get().get(this.getDefaultPreset());
        }
        if (vs == null) {
            return ObjEntityModels.NO_OVERRIDES;
        }
        String assetId = vs.getAssetId();
        VehicleClientStats vcs = VehicleClientPresets.get().get(assetId);
        if (vcs == null) {
            return ObjEntityModels.NO_OVERRIDES;
        }
        return vcs.getItemModelOverrides();
    }

    public String getDefaultPreset() {
        return this.defaultPreset;
    }

    @NotNull
    public String getPreset(@NotNull class_1799 stack) {
        return this.getPresetName(stack);
    }

    @NotNull
    public String getObjModelId(@NotNull String preset) {
        VehicleStats vs = (VehicleStats)VehiclePresets.get().get(preset);
        if (vs == null) {
            vs = (VehicleStats)VehiclePresets.get().get(this.getDefaultPreset());
        }
        if (vs == null) {
            return "";
        }
        String assetId = vs.getAssetId();
        VehicleClientStats vcs = VehicleClientPresets.get().get(assetId);
        if (vcs == null) {
            return "";
        }
        return vcs.getModelId();
    }

    @NotNull
    public class_1792 method_8389() {
        return this;
    }
}

