/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.util;

import com.onewhohears.dscombat.client.screen.VehiclePaintScreen;
import com.onewhohears.dscombat.data.parts.PartSlot;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.data.radar.RadarSystem;
import com.onewhohears.dscombat.data.vehicle.VehicleInputManager;
import com.onewhohears.dscombat.data.vehicle.VehicleTextureManager;
import com.onewhohears.dscombat.data.vehicle.physics.DSCPhyCons;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.parts.EntityChainHook;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.parts.EntityWeaponRack;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.hitbox.RotableHitbox;
import com.onewhohears.dscombat.util.UtilParticles;
import com.onewhohears.dscombat.util.UtilSound;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5819;
import net.minecraft.class_638;

public class UtilClientPacket {
    public static void aircraftInputsPacket(int id, VehicleInputManager inputs) {
        EntityVehicle plane;
        class_310 m = class_310.method_1551();
        class_638 world = m.field_1687;
        class_1297 class_12972 = world.method_8469(id);
        if (class_12972 instanceof EntityVehicle && !(plane = (EntityVehicle)class_12972).method_5787()) {
            plane.inputs.updateInputsFromPacket(inputs, plane);
        }
    }

    public static void pingsPacket(int id, List<RadarStats.RadarPing> pings) {
        class_310 m = class_310.method_1551();
        class_638 world = m.field_1687;
        class_1297 class_12972 = world.method_8469(id);
        if (class_12972 instanceof EntityVehicle) {
            EntityVehicle plane = (EntityVehicle)class_12972;
            plane.radarSystem.readClientPingsFromServer(pings);
        }
    }

    public static void weaponAmmoPacket(int id, String weaponId, String slotId, int ammo) {
        class_310 m = class_310.method_1551();
        class_638 world = m.field_1687;
        class_1297 class_12972 = world.method_8469(id);
        if (class_12972 instanceof EntityVehicle) {
            EntityVehicle plane = (EntityVehicle)class_12972;
            WeaponInstance<?> w = plane.weaponSystem.get(weaponId, slotId);
            if (w != null) {
                w.setCurrentAmmo(ammo);
            }
        }
    }

    public static void weaponSelectPacket(int id, int index) {
        class_310 m = class_310.method_1551();
        class_638 world = m.field_1687;
        class_1297 class_12972 = world.method_8469(id);
        if (class_12972 instanceof EntityVehicle) {
            EntityVehicle plane = (EntityVehicle)class_12972;
            plane.weaponSystem.setSelected(index);
        }
    }

    public static void addPartPacket(int id, String slotId, PartInstance<?> data) {
        class_310 m = class_310.method_1551();
        class_638 world = m.field_1687;
        class_1297 class_12972 = world.method_8469(id);
        if (class_12972 instanceof EntityVehicle) {
            EntityVehicle plane = (EntityVehicle)class_12972;
            PartSlot slot = plane.partsManager.getSlot(slotId);
            if (slot != null) {
                slot.addPartData(data, plane);
            }
        }
    }

    public static void removePartPacket(int id, String slotId) {
        class_310 m = class_310.method_1551();
        class_638 world = m.field_1687;
        class_1297 class_12972 = world.method_8469(id);
        if (class_12972 instanceof EntityVehicle) {
            EntityVehicle plane = (EntityVehicle)class_12972;
            PartSlot slot = plane.partsManager.getSlot(slotId);
            if (slot != null) {
                slot.removePartData(plane);
            }
        }
    }

    public static void syncPartPacket(int id, String slotId, class_2540 buffer) {
        class_310 m = class_310.method_1551();
        class_638 world = m.field_1687;
        buffer.method_19772();
        class_1297 class_12972 = world.method_8469(id);
        if (class_12972 instanceof EntityVehicle) {
            EntityVehicle plane = (EntityVehicle)class_12972;
            PartSlot slot = plane.partsManager.getSlot(slotId);
            if (slot != null && slot.getPartData() != null) {
                slot.getPartData().readBuffer(buffer);
                slot.getPartData().onReceiveClientSync();
            }
        }
    }

    public static void rwrPacket(int id, RadarSystem.RWRWarning warning) {
        class_310 m = class_310.method_1551();
        class_638 world = m.field_1687;
        class_1297 class_12972 = world.method_8469(id);
        if (class_12972 instanceof EntityVehicle) {
            EntityVehicle plane = (EntityVehicle)class_12972;
            plane.radarSystem.readRWRWarningFromServer(warning);
        }
    }

    public static void addMomentPacket(int id, class_243 force, class_243 moment) {
        class_310 m = class_310.method_1551();
        class_638 world = m.field_1687;
        class_1297 class_12972 = world.method_8469(id);
        if (class_12972 instanceof EntityVehicle) {
            EntityVehicle plane = (EntityVehicle)class_12972;
            plane.addForceBetweenTicks = plane.addForceBetweenTicks.method_1019(force);
            plane.addMomentBetweenTicks = plane.addMomentBetweenTicks.method_1019(moment);
        }
    }

    public static void vehicleTexturePacket(int ignore_player_id, int vehicle_id, ByteBuf buffer) {
        class_310 m = class_310.method_1551();
        if (m.field_1724.method_5628() == ignore_player_id) {
            return;
        }
        class_638 world = m.field_1687;
        class_1297 class_12972 = world.method_8469(vehicle_id);
        if (class_12972 instanceof EntityVehicle) {
            EntityVehicle plane = (EntityVehicle)class_12972;
            plane.textureManager.read(buffer);
        }
    }

    public static void openVehicleTextureScreen(VehicleTextureManager textures) {
        class_310 m = class_310.method_1551();
        m.method_1507((class_437)new VehiclePaintScreen(textures));
    }

    public static void vehicleExplode(int id, class_243 pos) {
        class_310 m = class_310.method_1551();
        if (id == -1) {
            UtilParticles.vehicleCrashExplosion((class_1937)m.field_1687, pos, 5.0);
        } else {
            class_1297 class_12972 = m.field_1687.method_8469(id);
            if (class_12972 instanceof EntityVehicle) {
                EntityVehicle plane = (EntityVehicle)class_12972;
                UtilParticles.vehicleCrashExplosion((class_1937)m.field_1687, pos, ((VehicleStats)plane.getStats()).crashExplosionRadius);
            }
        }
    }

    public static void weaponImpact(WeaponStats.WeaponClientImpactType impactType, class_243 pos) {
        class_310 m = class_310.method_1551();
        impactType.onClientImpact((class_1937)m.field_1687, pos);
    }

    public static void delayedSound(String soundId, class_243 pos, float range, float volume, float pitch) {
        class_3414 sound = UtilSound.getSoundById(soundId, null);
        if (sound == null) {
            return;
        }
        class_310 m = class_310.method_1551();
        float dist = (float)Objects.requireNonNull(m.method_1560()).method_19538().method_1022(pos);
        float attenuationCoefficient = (float)class_3532.method_15350((double)(1.0 / Math.pow((dist + range / 5.0f) / (range * 2.0f), 2.0) / 100.0), (double)0.0, (double)1.0);
        class_1109 ssi = new class_1109(sound, class_3419.field_15248, volume * attenuationCoefficient, pitch, class_5819.method_43049((long)UtilParticles.random.nextLong()), pos.field_1352, pos.field_1351, pos.field_1350);
        int delay = (int)(dist / DSCPhyCons.getVelSound());
        m.method_1483().method_4872((class_1113)ssi, delay);
    }

    public static void updateVehicleChain(int vehicleId, int hookId, int playerId, EntityChainHook.ChainUpdateType type) {
        class_310 m = class_310.method_1551();
        EntityVehicle vehicle = null;
        EntityChainHook hook = null;
        class_1657 player = null;
        if (m.field_1687 == null) {
            return;
        }
        class_1297 class_12972 = m.field_1687.method_8469(vehicleId);
        if (class_12972 instanceof EntityVehicle) {
            EntityVehicle v;
            vehicle = v = (EntityVehicle)class_12972;
        }
        if ((class_12972 = m.field_1687.method_8469(hookId)) instanceof EntityChainHook) {
            EntityChainHook c;
            hook = c = (EntityChainHook)class_12972;
        }
        if ((class_12972 = m.field_1687.method_8469(playerId)) instanceof class_1657) {
            class_1657 p;
            player = p = (class_1657)class_12972;
        }
        switch (type) {
            case CHAIN_ADD_PLAYER: {
                if (hook == null) {
                    return;
                }
                hook.addPlayerConnection(player);
                return;
            }
            case CHAIN_ADD_VEHICLE: {
                if (hook == null) {
                    return;
                }
                hook.addVehicleConnection(player, vehicle);
                return;
            }
            case CHAIN_DISCONNECT_PLAYER: {
                if (hook == null) {
                    return;
                }
                hook.disconnectPlayer(player);
                return;
            }
            case CHAIN_DISCONNECT_VEHICLE: {
                if (hook == null) {
                    return;
                }
                hook.disconnectVehicle(vehicle);
                return;
            }
            case VEHICLE_ADD_PLAYER: {
                if (vehicle == null) {
                    return;
                }
                vehicle.chainToPlayer(player);
                return;
            }
        }
    }

    public static void debugHitboxPos(int id, String hitbox_name, class_243 pos, class_243 size) {
        class_310 m = class_310.method_1551();
        class_638 world = m.field_1687;
        if (world == null) {
            return;
        }
        class_1297 class_12972 = world.method_8469(id);
        if (!(class_12972 instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)class_12972;
        RotableHitbox hitbox = vehicle.getHitboxByName(hitbox_name);
        if (hitbox == null) {
            return;
        }
        hitbox.setTestPos(pos);
        hitbox.setTestSize(size);
    }

    public static void onShoot(int vehicleId, int shooterId, ShootType type) {
        class_310 m = class_310.method_1551();
        class_638 world = m.field_1687;
        if (world == null) {
            return;
        }
        if (type == ShootType.WEAPON_RACK) {
            class_1297 class_12972 = world.method_8469(vehicleId);
            if (!(class_12972 instanceof EntityWeaponRack)) {
                return;
            }
            EntityWeaponRack rack = (EntityWeaponRack)class_12972;
            rack.onClientShoot();
        } else if (type == ShootType.TURRET) {
            class_1297 class_12973 = world.method_8469(vehicleId);
            if (!(class_12973 instanceof EntityTurret)) {
                return;
            }
            EntityTurret turret = (EntityTurret)class_12973;
            turret.onClientShoot();
        } else if (type == ShootType.FLARE) {
            if (m.field_1724 == null || m.field_1724.method_5668().method_5628() != vehicleId) {
                return;
            }
            class_1297 class_12974 = world.method_8469(vehicleId);
            if (!(class_12974 instanceof EntityVehicle)) {
                return;
            }
            EntityVehicle vehicle = (EntityVehicle)class_12974;
            vehicle.soundManager.playPassengerFlareSound();
        } else if (type == ShootType.CHAFF) {
            if (m.field_1724 == null || m.field_1724.method_5668().method_5628() != vehicleId) {
                return;
            }
            class_1297 class_12975 = world.method_8469(vehicleId);
            if (!(class_12975 instanceof EntityVehicle)) {
                return;
            }
            EntityVehicle vehicle = (EntityVehicle)class_12975;
            vehicle.soundManager.playPassengerChaffSound();
        }
    }

    public static enum ShootType {
        TURRET,
        WEAPON_RACK,
        FLARE,
        CHAFF;

    }
}

