/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.util.math;

import com.onewhohears.dscombat.util.math.DisguisedAABB;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.Optional;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_4048;

public class RotableAABB {
    public static final double SUBSIZE = 0.5;
    public static final double SUBSIZEHALF = 0.25;
    public static final double SUB_COL_SKIN = 0.0;
    public static final double COLLIDE_CHECK_SKIN = 0.0;
    public static final double PUSH_OUT_SKIN = 0.0;
    public static final double INSIDE_PUSH_OUT_SKIN = 0.0;
    public static final double IS_INSIDE_CHECK_SKIN = -0.01;
    public static final double PROBLEM_Y_ADJUST = 0.0;
    private class_243 center;
    private class_243 extents;
    private double maxRadius;
    private QuaternionF rot = QuaternionF.ONE.copy();
    private QuaternionF roti = QuaternionF.ONE.copy();

    public RotableAABB(class_238 bb) {
        this(bb.method_1005(), RotableAABB.extentsFromBB(bb));
    }

    public RotableAABB() {
        this(class_243.field_1353, class_243.field_1353);
    }

    public RotableAABB(double width, double height, double length) {
        this(class_243.field_1353, new class_243(width / 2.0, height / 2.0, length / 2.0));
    }

    public RotableAABB(class_243 center, class_243 extents) {
        this.center = center;
        this.extents = extents;
        this.maxRadius = extents.method_1033();
    }

    public RotableAABB copy() {
        return new RotableAABB(this.getCenter(), this.getExtents());
    }

    public void setCenterAndRot(class_243 center, QuaternionF q) {
        this.setCenter(center);
        this.setRot(q);
    }

    public class_243 collide(class_243 pos, class_238 aabb, class_243 move) {
        class_243 clip = this.getPushOutPos(pos, aabb, 0.0);
        if (move.field_1351 > 0.0 && clip.field_1351 < this.getCenter().field_1351 && pos.field_1351 + move.field_1351 > clip.field_1351) {
            move = new class_243(move.field_1352, clip.field_1351 - pos.field_1351, move.field_1350);
        } else if (move.field_1351 < 0.0 && clip.field_1351 > this.getCenter().field_1351 && pos.field_1351 + move.field_1351 < clip.field_1351) {
            move = new class_243(move.field_1352, clip.field_1351 - pos.field_1351, move.field_1350);
        }
        if (move.field_1351 > -0.08 && move.field_1351 < 0.0) {
            move = move.method_18805(1.0, 0.0, 1.0);
        }
        return move;
    }

    public boolean contains(class_238 aabb) {
        return this.contains(UtilGeometry.getClosestPointOnAABB((class_243)this.center, (class_238)aabb));
    }

    public boolean contains(class_243 pos) {
        return this.containsRelRot(this.toRelRotPos(pos));
    }

    public boolean containsRelRot(class_243 relRotPos) {
        boolean insideX = relRotPos.method_10216() <= this.extents.method_10216() && relRotPos.method_10216() >= -this.extents.method_10216();
        boolean insideY = relRotPos.method_10214() <= this.extents.method_10214() && relRotPos.method_10214() >= -this.extents.method_10214();
        boolean insideZ = relRotPos.method_10215() <= this.extents.method_10215() && relRotPos.method_10215() >= -this.extents.method_10215();
        return insideX && insideY && insideZ;
    }

    public boolean isInside(class_238 aabb, double skin) {
        return this.isInside(UtilGeometry.getClosestPointOnAABB((class_243)this.center, (class_238)aabb), skin);
    }

    public boolean isInside(class_238 aabb) {
        boolean inside = this.isInside(aabb, 0.0);
        return inside;
    }

    public boolean isInside(class_243 pos, double skin) {
        return this.isInsideRelPos(this.toRelRotPos(pos), skin);
    }

    public boolean isInside(class_243 pos) {
        return this.isInside(pos, 0.0);
    }

    public boolean isInsideRelPos(class_243 relRotPos, double skin) {
        boolean insideX = relRotPos.method_10216() < this.extents.method_10216() + skin && relRotPos.method_10216() > -this.extents.method_10216() - skin;
        boolean insideY = relRotPos.method_10214() < this.extents.method_10214() + skin && relRotPos.method_10214() > -this.extents.method_10214() - skin;
        boolean insideZ = relRotPos.method_10215() < this.extents.method_10215() + skin && relRotPos.method_10215() > -this.extents.method_10215() - skin;
        return insideX && insideY && insideZ;
    }

    public boolean isInsideRelPos(class_243 relRotPos) {
        return this.isInsideRelPos(relRotPos, 0.0);
    }

    public class_243 toRelRotPos(class_243 pos) {
        return UtilAngles.rotateVector((class_243)pos.method_1020(this.center), (QuaternionF)this.roti);
    }

    public class_243 toWorldPos(class_243 relRotPos) {
        return UtilAngles.rotateVector((class_243)relRotPos, (QuaternionF)this.rot).method_1019(this.center);
    }

    public class_243 toWorldVel(class_243 relRotVel) {
        return UtilAngles.rotateVector((class_243)relRotVel, (QuaternionF)this.rot);
    }

    public Optional<class_243> clip(class_243 from, class_243 to) {
        return this.clip(from, to, true);
    }

    public Optional<class_243> clip(class_243 from, class_243 to, boolean push) {
        Double clipZ;
        Double clipX;
        class_243 fromRelRot = this.toRelRotPos(from);
        if (this.isInsideRelPos(fromRelRot)) {
            if (push) {
                return Optional.of(this.getPushOutPos(from, 0.0));
            }
            return Optional.of(from);
        }
        class_243 toRelRot = this.toRelRotPos(to);
        class_243 diff = toRelRot.method_1020(fromRelRot);
        double tMin = Double.MAX_VALUE;
        class_243 clipRelRot = class_243.field_1353;
        Double clipY = this.clipAxis(fromRelRot.field_1351, toRelRot.field_1351, this.extents.field_1351);
        if (clipY != null) {
            double t = (clipY - fromRelRot.field_1351) / diff.field_1351;
            clipRelRot = fromRelRot.method_1019(diff.method_1021(t));
            clipRelRot = new class_243(clipRelRot.field_1352, clipY.doubleValue(), clipRelRot.field_1350);
            if (t < tMin && this.containsRelRot(clipRelRot)) {
                tMin = t;
            }
        }
        if ((clipX = this.clipAxis(fromRelRot.field_1352, toRelRot.field_1352, this.extents.field_1352)) != null) {
            double t = (clipX - fromRelRot.field_1352) / diff.field_1352;
            clipRelRot = fromRelRot.method_1019(diff.method_1021(t));
            clipRelRot = new class_243(clipX.doubleValue(), clipRelRot.field_1351, clipRelRot.field_1350);
            if (t < tMin && this.containsRelRot(clipRelRot)) {
                tMin = t;
            }
        }
        if ((clipZ = this.clipAxis(fromRelRot.field_1350, toRelRot.field_1350, this.extents.field_1350)) != null) {
            double t = (clipZ - fromRelRot.field_1350) / diff.field_1350;
            clipRelRot = fromRelRot.method_1019(diff.method_1021(t));
            clipRelRot = new class_243(clipRelRot.field_1352, clipRelRot.field_1351, clipZ.doubleValue());
            if (t < tMin && this.containsRelRot(clipRelRot)) {
                tMin = t;
            }
        }
        if (tMin == Double.MAX_VALUE) {
            return Optional.empty();
        }
        class_243 clip = this.toWorldPos(clipRelRot);
        return Optional.of(clip);
    }

    private Double clipAxis(double from, double to, double ext) {
        double diff = to - from;
        if (diff > 0.0 && from <= -ext && from + diff >= -ext) {
            return -ext;
        }
        if (diff < 0.0 && from >= ext && from + diff <= ext) {
            return ext;
        }
        return null;
    }

    public class_243 getPushOutPos(class_243 pos, class_238 aabb, double skin) {
        class_243[] relRotCorners = new class_243[8];
        relRotCorners[0] = this.toRelRotPos(new class_243(aabb.field_1323, aabb.field_1322, aabb.field_1321));
        class_243 zaxis = UtilAngles.getRollAxis((QuaternionF)this.roti);
        class_243 yaxis = UtilAngles.getYawAxis((QuaternionF)this.roti);
        class_243 xaxis = UtilAngles.getPitchAxis((QuaternionF)this.roti);
        relRotCorners[1] = relRotCorners[0].method_1019(zaxis.method_1021(aabb.method_17941()));
        relRotCorners[2] = relRotCorners[0].method_1019(yaxis.method_1021(aabb.method_17940()));
        relRotCorners[3] = relRotCorners[0].method_1019(zaxis.method_1021(aabb.method_17941())).method_1019(yaxis.method_1021(aabb.method_17940()));
        relRotCorners[4] = relRotCorners[0].method_1019(xaxis.method_1021(aabb.method_17939()));
        relRotCorners[5] = relRotCorners[0].method_1019(zaxis.method_1021(aabb.method_17941())).method_1019(xaxis.method_1021(aabb.method_17939()));
        relRotCorners[6] = relRotCorners[0].method_1019(yaxis.method_1021(aabb.method_17940())).method_1019(xaxis.method_1021(aabb.method_17939()));
        relRotCorners[7] = relRotCorners[0].method_1019(zaxis.method_1021(aabb.method_17941())).method_1019(yaxis.method_1021(aabb.method_17940())).method_1019(xaxis.method_1021(aabb.method_17939()));
        int[] absIndex = new int[]{UtilGeometry.getMaxYIndex((class_243[])relRotCorners), UtilGeometry.getMinYIndex((class_243[])relRotCorners), UtilGeometry.getMaxXIndex((class_243[])relRotCorners), UtilGeometry.getMinXIndex((class_243[])relRotCorners), UtilGeometry.getMaxZIndex((class_243[])relRotCorners), UtilGeometry.getMinZIndex((class_243[])relRotCorners)};
        double[] dists = new double[]{Math.abs(this.extents.field_1351 - relRotCorners[absIndex[0]].field_1351), Math.abs(-this.extents.field_1351 - relRotCorners[absIndex[0]].field_1351), Math.abs(this.extents.field_1351 - relRotCorners[absIndex[1]].field_1351), Math.abs(-this.extents.field_1351 - relRotCorners[absIndex[1]].field_1351), Math.abs(this.extents.field_1352 - relRotCorners[absIndex[2]].field_1352), Math.abs(-this.extents.field_1352 - relRotCorners[absIndex[2]].field_1352), Math.abs(this.extents.field_1352 - relRotCorners[absIndex[3]].field_1352), Math.abs(-this.extents.field_1352 - relRotCorners[absIndex[3]].field_1352), Math.abs(this.extents.field_1350 - relRotCorners[absIndex[4]].field_1350), Math.abs(-this.extents.field_1350 - relRotCorners[absIndex[4]].field_1350), Math.abs(this.extents.field_1350 - relRotCorners[absIndex[5]].field_1350), Math.abs(-this.extents.field_1350 - relRotCorners[absIndex[5]].field_1350)};
        int minIndex = UtilGeometry.getMinIndex((double[])dists);
        class_243 relRotPos = this.toRelRotPos(pos);
        class_243 relRotPush = class_243.field_1353;
        int extDir = minIndex % 2 == 0 ? 1 : -1;
        int absIndexIndex = minIndex / 2;
        if (minIndex % 4 == 0) {
            ++absIndexIndex;
        } else if (minIndex % 4 == 3) {
            --absIndexIndex;
        }
        class_243 relRotCorner = relRotCorners[absIndex[absIndexIndex]];
        if (minIndex >= 0 && minIndex <= 3) {
            ext = (this.extents.field_1351 + skin) * (double)extDir;
            relRotPush = new class_243(relRotPos.field_1352, ext += relRotPos.field_1351 - relRotCorner.field_1351, relRotPos.field_1350);
        } else if (minIndex >= 4 && minIndex <= 7) {
            ext = (this.extents.field_1352 + skin) * (double)extDir;
            relRotPush = new class_243(ext += relRotPos.field_1352 - relRotCorner.field_1352, relRotPos.field_1351, relRotPos.field_1350);
        } else if (minIndex >= 8 && minIndex <= 11) {
            ext = (this.extents.field_1350 + skin) * (double)extDir;
            relRotPush = new class_243(relRotPos.field_1352, relRotPos.field_1351, ext += relRotPos.field_1350 - relRotCorner.field_1350);
        }
        class_243 push = this.toWorldPos(relRotPush);
        return push;
    }

    public class_243 getPushOutPosOld(class_243 pos, class_238 aabb, double skin) {
        class_243 close = UtilGeometry.getClosestPointOnAABB((class_243)this.center, (class_238)aabb);
        class_243 aabbDiff = pos.method_1020(close);
        class_243 push = this.getPushOutPos(close, skin).method_1019(aabbDiff);
        return push;
    }

    public class_243 getPushOutPos(class_243 pos, double skin) {
        class_243 test;
        double distSqr;
        Double pushZ;
        class_243 test2;
        double distSqr2;
        Double pushX;
        class_243 test3;
        double distSqr3;
        class_243 posRelRot = this.toRelRotPos(pos);
        if (!this.isInsideRelPos(posRelRot)) {
            return pos;
        }
        double distSqrMin = Double.MAX_VALUE;
        class_243 pushRelRot = class_243.field_1353;
        Double pushY = this.pushAxis(posRelRot.field_1351, this.extents.field_1351, skin);
        if (pushY != null && (distSqr3 = posRelRot.method_1025(test3 = new class_243(posRelRot.field_1352, pushY.doubleValue(), posRelRot.field_1350))) < distSqrMin) {
            distSqrMin = distSqr3;
            pushRelRot = test3;
        }
        if ((pushX = this.pushAxis(posRelRot.field_1352, this.extents.field_1352, skin)) != null && (distSqr2 = posRelRot.method_1025(test2 = new class_243(pushX.doubleValue(), posRelRot.field_1351, posRelRot.field_1350))) < distSqrMin) {
            distSqrMin = distSqr2;
            pushRelRot = test2;
        }
        if ((pushZ = this.pushAxis(posRelRot.field_1350, this.extents.field_1350, skin)) != null && (distSqr = posRelRot.method_1025(test = new class_243(posRelRot.field_1352, posRelRot.field_1351, pushZ.doubleValue()))) < distSqrMin) {
            distSqrMin = distSqr;
            pushRelRot = test;
        }
        if (distSqrMin == Double.MAX_VALUE) {
            return pos;
        }
        class_243 push = this.toWorldPos(pushRelRot);
        return push;
    }

    private Double pushAxis(double pos, double ext, double skin) {
        if (pos < 0.0) {
            return -ext - skin;
        }
        return ext + skin;
    }

    public static class_243 extentsFromBB(class_238 bb) {
        return new class_243(bb.method_17939() / 2.0, bb.method_17940() / 2.0, bb.method_17941() / 2.0);
    }

    public class_243 getCenter() {
        return this.center;
    }

    public void setCenter(class_243 center) {
        this.center = center;
    }

    public class_243 getExtents() {
        return this.extents;
    }

    public void setExtents(class_243 extents) {
        this.extents = extents;
    }

    public QuaternionF getRot() {
        return this.rot.copy();
    }

    public QuaternionF getIRot() {
        return this.roti.copy();
    }

    public void setRot(QuaternionF rot) {
        this.rot = rot;
        this.roti = rot.copy();
        this.roti.conj();
    }

    public double getMaxRadius() {
        return this.maxRadius;
    }

    public class_4048 getMaxDimensions() {
        float max = (float)this.getMaxRadius();
        return class_4048.method_18384((float)(max * 2.0f), (float)(max * 2.0f));
    }

    public DisguisedAABB getDisguisedAABB(class_243 pos) {
        return new DisguisedAABB(this, pos, 0.5);
    }

    public class_238 makeMaxDimBox() {
        class_4048 d = this.getMaxDimensions();
        double pX = this.center.field_1352;
        double pY = this.center.field_1351;
        double pZ = this.center.field_1350;
        double f = d.field_18067 / 2.0f;
        double f1 = d.field_18068 / 2.0f;
        return new class_238(pX - f, pY - f1, pZ - f, pX + f, pY + f1, pZ + f);
    }

    public String toString() {
        return "RotableAABB:" + String.valueOf(this.getCenter()) + ":" + String.valueOf(this.getExtents());
    }

    public double getMaxY() {
        return UtilAngles.rotateVector((class_243)this.getExtents(), (QuaternionF)this.rot).field_1351 + this.getCenter().field_1351;
    }
}

