/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.model.obj;

import com.onewhohears.onewholibs.client.model.obj.ObjBakedModel;
import com.onewhohears.onewholibs.client.model.obj.ObjModelHandler;
import com.onewhohears.onewholibs.client.model.obj.ObjUnbakedModel;
import com.onewhohears.onewholibs.util.math.Mat4f;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import de.javagl.obj.FloatTuple;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjModelHandlerImpl
implements ObjModelHandler {
    @NotNull
    private final String modelId;
    @NotNull
    private final ObjBakedModel bakedModel;
    @NotNull
    private final ObjUnbakedModel unbakedModel;
    @Nullable
    private class_243 size = null;
    @Nullable
    private class_243 center = null;

    public ObjModelHandlerImpl(@NotNull String modelId, @NotNull ObjBakedModel bakedModel, @NotNull ObjUnbakedModel unbakedModel) {
        this.modelId = modelId;
        this.bakedModel = bakedModel;
        this.unbakedModel = unbakedModel;
    }

    @Override
    public void render(class_4587 poseStack, class_4597 bufferSource, float partialTicks, int lightmap, int overlay, Map<String, Mat4f> transforms, Function<class_2960, class_1921> renderType) {
        this.bakedModel.render(poseStack, bufferSource, renderType, lightmap, overlay, partialTicks, transforms);
    }

    @Override
    @NotNull
    public String getModelId() {
        return this.modelId;
    }

    @Override
    @NotNull
    public class_243 getSize() {
        if (this.size == null) {
            this.calcSizeCenter();
        }
        return this.size;
    }

    @Override
    @NotNull
    public class_243 getCenter() {
        if (this.center == null) {
            this.calcSizeCenter();
        }
        return this.center;
    }

    private void calcSizeCenter() {
        int numV = this.unbakedModel.getObj().getNumVertices();
        class_243[] vertices = new class_243[numV];
        for (int i = 0; i < vertices.length; ++i) {
            FloatTuple ft = this.unbakedModel.getObj().getVertex(i);
            vertices[i] = new class_243((double)ft.getX(), (double)ft.getY(), (double)ft.getZ());
        }
        class_243[] sizeCenter = UtilGeometry.getSizeCenter(vertices);
        this.size = sizeCenter[0];
        this.center = sizeCenter[1];
    }

    @NotNull
    public ObjBakedModel getBakedModel() {
        return this.bakedModel;
    }

    @NotNull
    public ObjUnbakedModel getUnbakedModel() {
        return this.unbakedModel;
    }
}

