/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import com.onewhohears.onewholibs.client.model.obj.ObjModelHandler;
import com.onewhohears.onewholibs.item.ObjModelItem;
import com.onewhohears.onewholibs.util.math.Mat4f;
import com.onewhohears.onewholibs.util.math.Vec3f;
import dev.architectury.registry.ReloadListenerRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_756;
import net.minecraft.class_809;
import net.minecraft.class_824;

public class RendererObjModelItems
extends class_756 {
    private static RendererObjModelItems instance;
    private final Map<String, ItemObjModelData> models = new HashMap<String, ItemObjModelData>();
    public static final Map<String, Mat4f> EMPTY_TRANSFORMS;

    public static RendererObjModelItems get() {
        return instance;
    }

    public static void register() {
        instance = RendererObjModelItems.createNew();
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)instance);
    }

    public static RendererObjModelItems createNew() {
        class_310 m = class_310.method_1551();
        return new RendererObjModelItems(m.method_31975(), m.method_31974());
    }

    protected RendererObjModelItems(class_824 blockEntityRenderDispatcher, class_5599 entityModelSet) {
        super(blockEntityRenderDispatcher, entityModelSet);
    }

    public void method_14491(class_3300 resourceManager) {
        this.models.clear();
    }

    public void method_3166(class_1799 stack, class_809.class_811 transformType, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay) {
        class_1792 item = stack.method_7909();
        if (item instanceof ObjModelItem) {
            ObjModelItem objItem = (ObjModelItem)item;
            String preset = objItem.getPreset(stack);
            ItemObjModelData model = this.models.get(preset);
            if (model == null) {
                String modelId = objItem.getObjModelId(preset);
                ObjModelHandler handler = ObjEntityModels.get().getObjModelHandler(modelId);
                ObjEntityModels.ModelOverrides override = ObjEntityModels.get().getModelOverride(modelId);
                ObjEntityModels.ModelOverrides itemModelOverrides = objItem.getItemModelOverrides(preset);
                model = new ItemObjModelData(handler, override, itemModelOverrides);
                this.models.put(preset, model);
            }
            model.render(transformType, poseStack, buffer, packedLight, packedOverlay);
        }
    }

    static {
        EMPTY_TRANSFORMS = ImmutableMap.of();
    }

    public static class ItemObjModelData {
        public static final float SIZE_SCALE_FACTOR = 1.25f;
        public final ObjModelHandler handler;
        public final ObjEntityModels.ModelOverrides modelOverrides;
        public final ObjEntityModels.ModelOverrides itemModelOverrides;
        public final class_243 center;
        public final float scale;

        public ItemObjModelData(ObjModelHandler handler, ObjEntityModels.ModelOverrides modelOverrides, ObjEntityModels.ModelOverrides itemModelOverrides) {
            this.handler = handler;
            this.modelOverrides = modelOverrides;
            this.itemModelOverrides = itemModelOverrides;
            class_243 size = handler.getSize();
            float maxSize = (float)Math.max(size.method_10215(), Math.max(size.method_10216(), size.method_10214()));
            this.center = handler.getCenter();
            this.scale = 1.25f / maxSize;
        }

        public void render(class_809.class_811 transformType, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay) {
            poseStack.method_22903();
            this.modelOverrides.applyRotation(poseStack);
            this.itemModelOverrides.apply(poseStack);
            if (transformType == class_809.class_811.field_4317) {
                poseStack.method_22904(0.5, 0.5, 0.5);
                poseStack.method_22907(Vec3f.XP.rotationDegrees(30.0f).convert());
                poseStack.method_22907(Vec3f.YP.rotationDegrees(45.0f).convert());
            } else if (transformType == class_809.class_811.field_4319) {
                poseStack.method_22904(0.5, 0.5, 0.35);
                poseStack.method_22907(Vec3f.XP.rotationDegrees(-90.0f).convert());
            } else if (transformType == class_809.class_811.field_4318) {
                poseStack.method_22904(0.5, 0.5, 0.5);
            } else if (transformType == class_809.class_811.field_4322) {
                poseStack.method_22904(0.5, 0.5, 0.3);
                poseStack.method_22907(Vec3f.XP.rotationDegrees(30.0f).convert());
                poseStack.method_22907(Vec3f.YP.rotationDegrees(225.0f).convert());
            } else if (transformType == class_809.class_811.field_4321) {
                poseStack.method_22904(0.5, 0.5, 0.3);
                poseStack.method_22907(Vec3f.XP.rotationDegrees(30.0f).convert());
                poseStack.method_22907(Vec3f.YP.rotationDegrees(135.0f).convert());
            } else if (transformType == class_809.class_811.field_4320) {
                poseStack.method_22904(0.5, 0.5, 0.5);
                poseStack.method_22907(Vec3f.XP.rotationDegrees(90.0f).convert());
                poseStack.method_22907(Vec3f.YP.rotationDegrees(225.0f).convert());
            } else if (transformType == class_809.class_811.field_4323) {
                poseStack.method_22904(0.5, 0.5, 0.5);
                poseStack.method_22907(Vec3f.XP.rotationDegrees(90.0f).convert());
                poseStack.method_22907(Vec3f.YP.rotationDegrees(135.0f).convert());
            } else if (transformType == class_809.class_811.field_4316) {
                poseStack.method_22904(0.5, 1.2, 0.5);
                poseStack.method_22905(2.0f, 2.0f, 2.0f);
                poseStack.method_22907(Vec3f.YP.rotationDegrees(180.0f).convert());
            } else if (transformType == class_809.class_811.field_4315) {
                poseStack.method_22904(0.5, 0.5, 0.5);
            }
            poseStack.method_22905(this.scale, this.scale, this.scale);
            poseStack.method_22904((double)((float)(-this.center.method_10216())), (double)((float)(-this.center.method_10214())), (double)((float)(-this.center.method_10215())));
            this.handler.render(poseStack, buffer, 0.0f, packedLight, packedOverlay, EMPTY_TRANSFORMS, class_1921::method_23572);
            poseStack.method_22909();
        }
    }
}

