/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.common.core;

import com.mojang.logging.LogUtils;
import com.onewhohears.onewholibs.common.core.RayCastPerspective;
import com.onewhohears.onewholibs.common.network.toclient.ToClientCanSeePos;
import com.onewhohears.onewholibs.util.UtilEntity;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class DistantRayCastManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final IntObjectMap<RayCastData> RAY_CASTS = new IntObjectHashMap();
    private static int RAY_CAST_ID_COUNTER = 0;

    public static void distantRayCast(@NotNull class_3218 level, @NotNull class_1297 eyeEntity, @NotNull class_1297 targetEntity, @NotNull RayCastComplete onComplete, long timeoutTime, long rayCastLifeTime, double throWater, double throBlock) {
        RayCastData data = DistantRayCastManager.getRayCastWithEntities(eyeEntity, targetEntity);
        if (data != null) {
            data.sendPayloads();
            return;
        }
        long createdTime = System.currentTimeMillis();
        data = new RayCastData(++RAY_CAST_ID_COUNTER, level, eyeEntity, targetEntity, createdTime, timeoutTime, rayCastLifeTime, throWater, throBlock, onComplete);
        RAY_CASTS.put(data.rayCastId, (Object)data);
        data.sendPayloads();
    }

    @Nullable
    public static RayCastData getRayCastWithEntities(@NotNull class_1297 entity1, @NotNull class_1297 entity2) {
        for (RayCastData data : RAY_CASTS.values()) {
            if (!data.hasEntity(entity1) || !data.hasEntity(entity2)) continue;
            return data;
        }
        return null;
    }

    public static void handleC2SRayCast(int rayCastId, RayCastPerspective perspective, boolean success) {
        RayCastData data = (RayCastData)RAY_CASTS.get(rayCastId);
        if (data == null) {
            LOGGER.warn("Received ray cast packet with ID {} that doesn't exist.", (Object)rayCastId);
            return;
        }
        data.handle(perspective, success);
    }

    public static void onServerTick() {
        long currentTime = System.currentTimeMillis();
        RAY_CASTS.entrySet().removeIf(entry -> {
            RayCastData data = (RayCastData)entry.getValue();
            if (!data.isComplete() && currentTime - data.createdTime > data.timeoutTime) {
                return true;
            }
            return data.isComplete() && currentTime - data.completeTime > data.rayCastLifeTime;
        });
    }

    public static class RayCastData {
        public final int rayCastId;
        @NotNull
        public final class_3218 level;
        @NotNull
        public final class_1297 eyeEntity;
        @NotNull
        public final class_1297 targetEntity;
        public final long createdTime;
        public final long timeoutTime;
        public final long rayCastLifeTime;
        public final double throWater;
        public final double throBlock;
        @NotNull
        public final RayCastComplete onComplete;
        public boolean eyeConfirm = false;
        public boolean targetConfirm = false;
        public boolean eyeComplete = false;
        public boolean targetComplete = false;
        public long completeTime;

        public RayCastData(int rayCastId, @NotNull class_3218 level, @NotNull class_1297 eyeEntity, @NotNull class_1297 targetEntity, long createdTime, long timeoutTime, long rayCastLifeTime, double throWater, double throBlock, @NotNull RayCastComplete onComplete) {
            this.rayCastId = rayCastId;
            this.level = level;
            this.eyeEntity = eyeEntity;
            this.targetEntity = targetEntity;
            this.createdTime = createdTime;
            this.timeoutTime = timeoutTime;
            this.rayCastLifeTime = rayCastLifeTime;
            this.throWater = throWater;
            this.throBlock = throBlock;
            this.onComplete = onComplete;
        }

        public boolean isConfirmed() {
            return this.eyeConfirm && this.targetConfirm;
        }

        public boolean isComplete() {
            return this.eyeComplete && this.targetComplete;
        }

        public boolean hasEntity(@NotNull class_1297 entity) {
            return this.eyeEntity.method_5628() == entity.method_5628() || this.targetEntity.method_5628() == entity.method_5628();
        }

        public void sendPayloads() {
            this.sendPayload(this.eyeEntity, this.targetEntity.method_33571(), RayCastPerspective.EYE);
            this.sendPayload(this.targetEntity, this.eyeEntity.method_33571(), RayCastPerspective.TARGET);
        }

        private void sendPayload(class_1297 entity, class_243 pos, RayCastPerspective perspective) {
            ToClientCanSeePos packet = new ToClientCanSeePos(this.rayCastId, perspective, entity, pos, this.throWater, this.throBlock);
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                packet.sendTo(player);
            } else {
                class_1297 class_12972 = entity.method_5642();
                if (class_12972 instanceof class_3222) {
                    class_3222 player = (class_3222)class_12972;
                    packet.sendTo(player);
                } else {
                    int viewDistanceBlocks = this.level.method_8503().method_3760().method_14568() * 16;
                    class_1657 nearestPlayer = this.level.method_18460(entity, (double)viewDistanceBlocks);
                    if (nearestPlayer == null) {
                        DistantRayCastManager.handleC2SRayCast(this.rayCastId, perspective, UtilEntity.isLocalVisionBlocked((class_1937)this.level, entity.method_33571(), pos, this.throWater, this.throBlock, 32));
                    } else {
                        packet.sendTo((class_3222)nearestPlayer);
                    }
                }
            }
        }

        public void apply() {
            this.completeTime = System.currentTimeMillis();
            this.onComplete.apply(this.level, this.eyeEntity, this.targetEntity, this.isConfirmed());
            this.eyeComplete = false;
            this.targetComplete = false;
        }

        public void handle(RayCastPerspective perspective, boolean success) {
            if (perspective == RayCastPerspective.EYE) {
                this.eyeComplete = true;
                this.eyeConfirm = success;
            } else if (perspective == RayCastPerspective.TARGET) {
                this.targetComplete = true;
                this.targetConfirm = success;
            }
            if (this.isComplete()) {
                this.apply();
            }
        }
    }

    public static interface RayCastComplete {
        public void apply(@NotNull class_3218 var1, @NotNull class_1297 var2, @NotNull class_1297 var3, @NotNull Boolean var4);
    }
}

