/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.common.event;

import com.mojang.brigadier.CommandDispatcher;
import com.onewhohears.onewholibs.common.command.TestIngredientStackCommand;
import com.onewhohears.onewholibs.common.command.TestPresetCommand;
import com.onewhohears.onewholibs.common.core.DistantRayCastManager;
import com.onewhohears.onewholibs.common.event.OWLEvents;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetReloadListener;
import com.onewhohears.onewholibs.data.jsonpreset.test.TestPresets;
import com.onewhohears.onewholibs.util.UtilSync;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public class OWLCommonEventHandlers {
    public static void init() {
        PlayerEvent.PLAYER_JOIN.register(OWLCommonEventHandlers::onPlayerJoin);
        CommandRegistrationEvent.EVENT.register(OWLCommonEventHandlers::registerCommands);
        OWLEvents.GET_JSON_PRESET_LISTENERS.register(OWLCommonEventHandlers::registerPresetListeners);
        LifecycleEvent.SETUP.register(OWLEvents::registerAllJsonPresetReloadListeners);
        TickEvent.SERVER_PRE.register(OWLCommonEventHandlers::onServerTickPre);
    }

    public static void onServerTickPre(MinecraftServer server) {
        DistantRayCastManager.onServerTick();
    }

    public static void registerPresetListeners(List<JsonPresetReloadListener<?>> listeners) {
        listeners.add(TestPresets.get());
    }

    public static void onPlayerJoin(class_3222 player) {
        UtilSync.syncPresets(Collections.singleton(player));
        UtilSync.syncGameRules(Collections.singleton(player), player.method_5682());
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 context, class_2170.class_5364 selection) {
        new TestPresetCommand(dispatcher);
        new TestIngredientStackCommand(dispatcher, context);
    }
}

