/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.util.math;

import com.mojang.datafixers.util.Pair;
import com.onewhohears.onewholibs.util.math.Mat4f;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.Vec3f;
import java.nio.FloatBuffer;
import net.minecraft.class_3532;
import net.minecraft.class_4581;
import org.apache.commons.lang3.tuple.Triple;
import org.lwjgl.BufferUtils;

public final class Mat3f {
    private static final int ORDER = 3;
    private static final float G = 3.0f + 2.0f * (float)Math.sqrt(2.0);
    private static final float CS = (float)Math.cos(0.39269908169872414);
    private static final float SS = (float)Math.sin(0.39269908169872414);
    private static final float SQ2 = 1.0f / (float)Math.sqrt(2.0);
    float m00;
    float m01;
    float m02;
    float m10;
    float m11;
    float m12;
    float m20;
    float m21;
    float m22;

    public Mat3f() {
    }

    public Mat3f(QuaternionF quaternion) {
        float f = quaternion.i();
        float g = quaternion.j();
        float h = quaternion.k();
        float i = quaternion.r();
        float j = 2.0f * f * f;
        float k = 2.0f * g * g;
        float l = 2.0f * h * h;
        this.m00 = 1.0f - k - l;
        this.m11 = 1.0f - l - j;
        this.m22 = 1.0f - j - k;
        float m = f * g;
        float n = g * h;
        float o = h * f;
        float p = f * i;
        float q = g * i;
        float r = h * i;
        this.m10 = 2.0f * (m + r);
        this.m01 = 2.0f * (m - r);
        this.m20 = 2.0f * (o - q);
        this.m02 = 2.0f * (o + q);
        this.m21 = 2.0f * (n + p);
        this.m12 = 2.0f * (n - p);
    }

    public static Mat3f createScaleMatrix(float f, float g, float h) {
        Mat3f Mat3f2 = new Mat3f();
        Mat3f2.m00 = f;
        Mat3f2.m11 = g;
        Mat3f2.m22 = h;
        return Mat3f2;
    }

    public Mat3f(Mat4f matrix4f) {
        this.m00 = matrix4f.m00;
        this.m01 = matrix4f.m01;
        this.m02 = matrix4f.m02;
        this.m10 = matrix4f.m10;
        this.m11 = matrix4f.m11;
        this.m12 = matrix4f.m12;
        this.m20 = matrix4f.m20;
        this.m21 = matrix4f.m21;
        this.m22 = matrix4f.m22;
    }

    public Mat3f(Mat3f Mat3f2) {
        this.m00 = Mat3f2.m00;
        this.m01 = Mat3f2.m01;
        this.m02 = Mat3f2.m02;
        this.m10 = Mat3f2.m10;
        this.m11 = Mat3f2.m11;
        this.m12 = Mat3f2.m12;
        this.m20 = Mat3f2.m20;
        this.m21 = Mat3f2.m21;
        this.m22 = Mat3f2.m22;
    }

    private static Pair<Float, Float> approxGivensQuat(float f, float g, float h) {
        float i = 2.0f * (f - h);
        if (G * g * g < i * i) {
            float k = class_3532.method_22858((float)(g * g + i * i));
            return Pair.of((Object)Float.valueOf(k * g), (Object)Float.valueOf(k * i));
        }
        return Pair.of((Object)Float.valueOf(SS), (Object)Float.valueOf(CS));
    }

    private static Pair<Float, Float> qrGivensQuat(float f, float g) {
        float k;
        float h = (float)Math.hypot(f, g);
        float i = h > 1.0E-6f ? g : 0.0f;
        float j = Math.abs(f) + Math.max(h, 1.0E-6f);
        if (f < 0.0f) {
            k = i;
            i = j;
            j = k;
        }
        k = class_3532.method_22858((float)(j * j + i * i));
        return Pair.of((Object)Float.valueOf(i *= k), (Object)Float.valueOf(j *= k));
    }

    private static QuaternionF stepJacobi(Mat3f Mat3f2) {
        float h;
        float g;
        float f;
        QuaternionF quaternion2;
        Float float2;
        Float float_;
        Pair<Float, Float> pair;
        Mat3f Mat3f22 = new Mat3f();
        QuaternionF quaternion = QuaternionF.ONE.copy();
        if (Mat3f2.m01 * Mat3f2.m01 + Mat3f2.m10 * Mat3f2.m10 > 1.0E-6f) {
            pair = Mat3f.approxGivensQuat(Mat3f2.m00, 0.5f * (Mat3f2.m01 + Mat3f2.m10), Mat3f2.m11);
            float_ = (Float)pair.getFirst();
            float2 = (Float)pair.getSecond();
            quaternion2 = new QuaternionF(0.0f, 0.0f, float_.floatValue(), float2.floatValue());
            f = float2.floatValue() * float2.floatValue() - float_.floatValue() * float_.floatValue();
            g = -2.0f * float_.floatValue() * float2.floatValue();
            h = float2.floatValue() * float2.floatValue() + float_.floatValue() * float_.floatValue();
            quaternion.mul(quaternion2);
            Mat3f22.setIdentity();
            Mat3f22.m00 = f;
            Mat3f22.m11 = f;
            Mat3f22.m10 = -g;
            Mat3f22.m01 = g;
            Mat3f22.m22 = h;
            Mat3f2.mul(Mat3f22);
            Mat3f22.transpose();
            Mat3f22.mul(Mat3f2);
            Mat3f2.load(Mat3f22);
        }
        if (Mat3f2.m02 * Mat3f2.m02 + Mat3f2.m20 * Mat3f2.m20 > 1.0E-6f) {
            pair = Mat3f.approxGivensQuat(Mat3f2.m00, 0.5f * (Mat3f2.m02 + Mat3f2.m20), Mat3f2.m22);
            float i = -((Float)pair.getFirst()).floatValue();
            float2 = (Float)pair.getSecond();
            quaternion2 = new QuaternionF(0.0f, i, 0.0f, float2.floatValue());
            f = float2.floatValue() * float2.floatValue() - i * i;
            g = -2.0f * i * float2.floatValue();
            h = float2.floatValue() * float2.floatValue() + i * i;
            quaternion.mul(quaternion2);
            Mat3f22.setIdentity();
            Mat3f22.m00 = f;
            Mat3f22.m22 = f;
            Mat3f22.m20 = g;
            Mat3f22.m02 = -g;
            Mat3f22.m11 = h;
            Mat3f2.mul(Mat3f22);
            Mat3f22.transpose();
            Mat3f22.mul(Mat3f2);
            Mat3f2.load(Mat3f22);
        }
        if (Mat3f2.m12 * Mat3f2.m12 + Mat3f2.m21 * Mat3f2.m21 > 1.0E-6f) {
            pair = Mat3f.approxGivensQuat(Mat3f2.m11, 0.5f * (Mat3f2.m12 + Mat3f2.m21), Mat3f2.m22);
            float_ = (Float)pair.getFirst();
            float2 = (Float)pair.getSecond();
            quaternion2 = new QuaternionF(float_.floatValue(), 0.0f, 0.0f, float2.floatValue());
            f = float2.floatValue() * float2.floatValue() - float_.floatValue() * float_.floatValue();
            g = -2.0f * float_.floatValue() * float2.floatValue();
            h = float2.floatValue() * float2.floatValue() + float_.floatValue() * float_.floatValue();
            quaternion.mul(quaternion2);
            Mat3f22.setIdentity();
            Mat3f22.m11 = f;
            Mat3f22.m22 = f;
            Mat3f22.m21 = -g;
            Mat3f22.m12 = g;
            Mat3f22.m00 = h;
            Mat3f2.mul(Mat3f22);
            Mat3f22.transpose();
            Mat3f22.mul(Mat3f2);
            Mat3f2.load(Mat3f22);
        }
        return quaternion;
    }

    private static void sortSingularValues(Mat3f Mat3f2, QuaternionF quaternion) {
        QuaternionF quaternion2;
        float i;
        float f = Mat3f2.m00 * Mat3f2.m00 + Mat3f2.m10 * Mat3f2.m10 + Mat3f2.m20 * Mat3f2.m20;
        float g = Mat3f2.m01 * Mat3f2.m01 + Mat3f2.m11 * Mat3f2.m11 + Mat3f2.m21 * Mat3f2.m21;
        float h = Mat3f2.m02 * Mat3f2.m02 + Mat3f2.m12 * Mat3f2.m12 + Mat3f2.m22 * Mat3f2.m22;
        if (f < g) {
            i = Mat3f2.m10;
            Mat3f2.m10 = -Mat3f2.m00;
            Mat3f2.m00 = i;
            i = Mat3f2.m11;
            Mat3f2.m11 = -Mat3f2.m01;
            Mat3f2.m01 = i;
            i = Mat3f2.m12;
            Mat3f2.m12 = -Mat3f2.m02;
            Mat3f2.m02 = i;
            quaternion2 = new QuaternionF(0.0f, 0.0f, SQ2, SQ2);
            quaternion.mul(quaternion2);
            i = f;
            f = g;
            g = i;
        }
        if (f < h) {
            i = Mat3f2.m20;
            Mat3f2.m20 = -Mat3f2.m00;
            Mat3f2.m00 = i;
            i = Mat3f2.m21;
            Mat3f2.m21 = -Mat3f2.m01;
            Mat3f2.m01 = i;
            i = Mat3f2.m22;
            Mat3f2.m22 = -Mat3f2.m02;
            Mat3f2.m02 = i;
            quaternion2 = new QuaternionF(0.0f, SQ2, 0.0f, SQ2);
            quaternion.mul(quaternion2);
            h = f;
        }
        if (g < h) {
            i = Mat3f2.m20;
            Mat3f2.m20 = -Mat3f2.m10;
            Mat3f2.m10 = i;
            i = Mat3f2.m21;
            Mat3f2.m21 = -Mat3f2.m11;
            Mat3f2.m11 = i;
            i = Mat3f2.m22;
            Mat3f2.m22 = -Mat3f2.m12;
            Mat3f2.m12 = i;
            quaternion2 = new QuaternionF(SQ2, 0.0f, 0.0f, SQ2);
            quaternion.mul(quaternion2);
        }
    }

    public void transpose() {
        float f = this.m01;
        this.m01 = this.m10;
        this.m10 = f;
        f = this.m02;
        this.m02 = this.m20;
        this.m20 = f;
        f = this.m12;
        this.m12 = this.m21;
        this.m21 = f;
    }

    public Triple<QuaternionF, Vec3f, QuaternionF> svdDecompose() {
        QuaternionF quaternion = QuaternionF.ONE.copy();
        QuaternionF quaternion2 = QuaternionF.ONE.copy();
        Mat3f Mat3f2 = this.copy();
        Mat3f2.transpose();
        Mat3f2.mul(this);
        for (int i = 0; i < 5; ++i) {
            quaternion2.mul(Mat3f.stepJacobi(Mat3f2));
        }
        quaternion2.normalize();
        Mat3f Mat3f22 = new Mat3f(this);
        Mat3f22.mul(new Mat3f(quaternion2));
        float f = 1.0f;
        Pair<Float, Float> pair = Mat3f.qrGivensQuat(Mat3f22.m00, Mat3f22.m10);
        Float float_ = (Float)pair.getFirst();
        Float float2 = (Float)pair.getSecond();
        float g = float2.floatValue() * float2.floatValue() - float_.floatValue() * float_.floatValue();
        float h = -2.0f * float_.floatValue() * float2.floatValue();
        float j = float2.floatValue() * float2.floatValue() + float_.floatValue() * float_.floatValue();
        QuaternionF quaternion3 = new QuaternionF(0.0f, 0.0f, float_.floatValue(), float2.floatValue());
        quaternion.mul(quaternion3);
        Mat3f Mat3f3 = new Mat3f();
        Mat3f3.setIdentity();
        Mat3f3.m00 = g;
        Mat3f3.m11 = g;
        Mat3f3.m10 = h;
        Mat3f3.m01 = -h;
        Mat3f3.m22 = j;
        f *= j;
        Mat3f3.mul(Mat3f22);
        pair = Mat3f.qrGivensQuat(Mat3f3.m00, Mat3f3.m20);
        float k = -((Float)pair.getFirst()).floatValue();
        Float float3 = (Float)pair.getSecond();
        float l = float3.floatValue() * float3.floatValue() - k * k;
        float m = -2.0f * k * float3.floatValue();
        float n = float3.floatValue() * float3.floatValue() + k * k;
        QuaternionF quaternion4 = new QuaternionF(0.0f, k, 0.0f, float3.floatValue());
        quaternion.mul(quaternion4);
        Mat3f Mat3f4 = new Mat3f();
        Mat3f4.setIdentity();
        Mat3f4.m00 = l;
        Mat3f4.m22 = l;
        Mat3f4.m20 = -m;
        Mat3f4.m02 = m;
        Mat3f4.m11 = n;
        f *= n;
        Mat3f4.mul(Mat3f3);
        pair = Mat3f.qrGivensQuat(Mat3f4.m11, Mat3f4.m21);
        Float float4 = (Float)pair.getFirst();
        Float float5 = (Float)pair.getSecond();
        float o = float5.floatValue() * float5.floatValue() - float4.floatValue() * float4.floatValue();
        float p = -2.0f * float4.floatValue() * float5.floatValue();
        float q = float5.floatValue() * float5.floatValue() + float4.floatValue() * float4.floatValue();
        QuaternionF quaternion5 = new QuaternionF(float4.floatValue(), 0.0f, 0.0f, float5.floatValue());
        quaternion.mul(quaternion5);
        Mat3f Mat3f5 = new Mat3f();
        Mat3f5.setIdentity();
        Mat3f5.m11 = o;
        Mat3f5.m22 = o;
        Mat3f5.m21 = p;
        Mat3f5.m12 = -p;
        Mat3f5.m00 = q;
        f *= q;
        Mat3f5.mul(Mat3f4);
        f = 1.0f / f;
        quaternion.mul((float)Math.sqrt(f));
        Vec3f vector3f = new Vec3f(Mat3f5.m00 * f, Mat3f5.m11 * f, Mat3f5.m22 * f);
        return Triple.of((Object)quaternion, (Object)vector3f, (Object)quaternion2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            Mat3f Mat3f2 = (Mat3f)object;
            return Float.compare(Mat3f2.m00, this.m00) == 0 && Float.compare(Mat3f2.m01, this.m01) == 0 && Float.compare(Mat3f2.m02, this.m02) == 0 && Float.compare(Mat3f2.m10, this.m10) == 0 && Float.compare(Mat3f2.m11, this.m11) == 0 && Float.compare(Mat3f2.m12, this.m12) == 0 && Float.compare(Mat3f2.m20, this.m20) == 0 && Float.compare(Mat3f2.m21, this.m21) == 0 && Float.compare(Mat3f2.m22, this.m22) == 0;
        }
        return false;
    }

    public int hashCode() {
        int i = this.m00 != 0.0f ? Float.floatToIntBits(this.m00) : 0;
        i = 31 * i + (this.m01 != 0.0f ? Float.floatToIntBits(this.m01) : 0);
        i = 31 * i + (this.m02 != 0.0f ? Float.floatToIntBits(this.m02) : 0);
        i = 31 * i + (this.m10 != 0.0f ? Float.floatToIntBits(this.m10) : 0);
        i = 31 * i + (this.m11 != 0.0f ? Float.floatToIntBits(this.m11) : 0);
        i = 31 * i + (this.m12 != 0.0f ? Float.floatToIntBits(this.m12) : 0);
        i = 31 * i + (this.m20 != 0.0f ? Float.floatToIntBits(this.m20) : 0);
        i = 31 * i + (this.m21 != 0.0f ? Float.floatToIntBits(this.m21) : 0);
        i = 31 * i + (this.m22 != 0.0f ? Float.floatToIntBits(this.m22) : 0);
        return i;
    }

    private static int bufferIndex(int i, int j) {
        return j * 3 + i;
    }

    public void load(FloatBuffer floatBuffer) {
        this.m00 = floatBuffer.get(Mat3f.bufferIndex(0, 0));
        this.m01 = floatBuffer.get(Mat3f.bufferIndex(0, 1));
        this.m02 = floatBuffer.get(Mat3f.bufferIndex(0, 2));
        this.m10 = floatBuffer.get(Mat3f.bufferIndex(1, 0));
        this.m11 = floatBuffer.get(Mat3f.bufferIndex(1, 1));
        this.m12 = floatBuffer.get(Mat3f.bufferIndex(1, 2));
        this.m20 = floatBuffer.get(Mat3f.bufferIndex(2, 0));
        this.m21 = floatBuffer.get(Mat3f.bufferIndex(2, 1));
        this.m22 = floatBuffer.get(Mat3f.bufferIndex(2, 2));
    }

    public void loadTransposed(FloatBuffer floatBuffer) {
        this.m00 = floatBuffer.get(Mat3f.bufferIndex(0, 0));
        this.m01 = floatBuffer.get(Mat3f.bufferIndex(1, 0));
        this.m02 = floatBuffer.get(Mat3f.bufferIndex(2, 0));
        this.m10 = floatBuffer.get(Mat3f.bufferIndex(0, 1));
        this.m11 = floatBuffer.get(Mat3f.bufferIndex(1, 1));
        this.m12 = floatBuffer.get(Mat3f.bufferIndex(2, 1));
        this.m20 = floatBuffer.get(Mat3f.bufferIndex(0, 2));
        this.m21 = floatBuffer.get(Mat3f.bufferIndex(1, 2));
        this.m22 = floatBuffer.get(Mat3f.bufferIndex(2, 2));
    }

    public void load(FloatBuffer floatBuffer, boolean bl) {
        if (bl) {
            this.loadTransposed(floatBuffer);
        } else {
            this.load(floatBuffer);
        }
    }

    public void load(Mat3f Mat3f2) {
        this.m00 = Mat3f2.m00;
        this.m01 = Mat3f2.m01;
        this.m02 = Mat3f2.m02;
        this.m10 = Mat3f2.m10;
        this.m11 = Mat3f2.m11;
        this.m12 = Mat3f2.m12;
        this.m20 = Mat3f2.m20;
        this.m21 = Mat3f2.m21;
        this.m22 = Mat3f2.m22;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Mat3f:\n");
        stringBuilder.append(this.m00);
        stringBuilder.append(" ");
        stringBuilder.append(this.m01);
        stringBuilder.append(" ");
        stringBuilder.append(this.m02);
        stringBuilder.append("\n");
        stringBuilder.append(this.m10);
        stringBuilder.append(" ");
        stringBuilder.append(this.m11);
        stringBuilder.append(" ");
        stringBuilder.append(this.m12);
        stringBuilder.append("\n");
        stringBuilder.append(this.m20);
        stringBuilder.append(" ");
        stringBuilder.append(this.m21);
        stringBuilder.append(" ");
        stringBuilder.append(this.m22);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public void store(FloatBuffer floatBuffer) {
        floatBuffer.put(Mat3f.bufferIndex(0, 0), this.m00);
        floatBuffer.put(Mat3f.bufferIndex(0, 1), this.m01);
        floatBuffer.put(Mat3f.bufferIndex(0, 2), this.m02);
        floatBuffer.put(Mat3f.bufferIndex(1, 0), this.m10);
        floatBuffer.put(Mat3f.bufferIndex(1, 1), this.m11);
        floatBuffer.put(Mat3f.bufferIndex(1, 2), this.m12);
        floatBuffer.put(Mat3f.bufferIndex(2, 0), this.m20);
        floatBuffer.put(Mat3f.bufferIndex(2, 1), this.m21);
        floatBuffer.put(Mat3f.bufferIndex(2, 2), this.m22);
    }

    public void storeTransposed(FloatBuffer floatBuffer) {
        floatBuffer.put(Mat3f.bufferIndex(0, 0), this.m00);
        floatBuffer.put(Mat3f.bufferIndex(1, 0), this.m01);
        floatBuffer.put(Mat3f.bufferIndex(2, 0), this.m02);
        floatBuffer.put(Mat3f.bufferIndex(0, 1), this.m10);
        floatBuffer.put(Mat3f.bufferIndex(1, 1), this.m11);
        floatBuffer.put(Mat3f.bufferIndex(2, 1), this.m12);
        floatBuffer.put(Mat3f.bufferIndex(0, 2), this.m20);
        floatBuffer.put(Mat3f.bufferIndex(1, 2), this.m21);
        floatBuffer.put(Mat3f.bufferIndex(2, 2), this.m22);
    }

    public void store(FloatBuffer floatBuffer, boolean bl) {
        if (bl) {
            this.storeTransposed(floatBuffer);
        } else {
            this.store(floatBuffer);
        }
    }

    public void setIdentity() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
    }

    public float adjugateAndDet() {
        float f = this.m11 * this.m22 - this.m12 * this.m21;
        float g = -(this.m10 * this.m22 - this.m12 * this.m20);
        float h = this.m10 * this.m21 - this.m11 * this.m20;
        float i = -(this.m01 * this.m22 - this.m02 * this.m21);
        float j = this.m00 * this.m22 - this.m02 * this.m20;
        float k = -(this.m00 * this.m21 - this.m01 * this.m20);
        float l = this.m01 * this.m12 - this.m02 * this.m11;
        float m = -(this.m00 * this.m12 - this.m02 * this.m10);
        float n = this.m00 * this.m11 - this.m01 * this.m10;
        float o = this.m00 * f + this.m01 * g + this.m02 * h;
        this.m00 = f;
        this.m10 = g;
        this.m20 = h;
        this.m01 = i;
        this.m11 = j;
        this.m21 = k;
        this.m02 = l;
        this.m12 = m;
        this.m22 = n;
        return o;
    }

    public float determinant() {
        float f = this.m11 * this.m22 - this.m12 * this.m21;
        float g = -(this.m10 * this.m22 - this.m12 * this.m20);
        float h = this.m10 * this.m21 - this.m11 * this.m20;
        return this.m00 * f + this.m01 * g + this.m02 * h;
    }

    public boolean invert() {
        float f = this.adjugateAndDet();
        if (Math.abs(f) > 1.0E-6f) {
            this.mul(f);
            return true;
        }
        return false;
    }

    public void set(int i, int j, float f) {
        if (i == 0) {
            if (j == 0) {
                this.m00 = f;
            } else if (j == 1) {
                this.m01 = f;
            } else {
                this.m02 = f;
            }
        } else if (i == 1) {
            if (j == 0) {
                this.m10 = f;
            } else if (j == 1) {
                this.m11 = f;
            } else {
                this.m12 = f;
            }
        } else if (j == 0) {
            this.m20 = f;
        } else if (j == 1) {
            this.m21 = f;
        } else {
            this.m22 = f;
        }
    }

    public void mul(Mat3f Mat3f2) {
        float f = this.m00 * Mat3f2.m00 + this.m01 * Mat3f2.m10 + this.m02 * Mat3f2.m20;
        float g = this.m00 * Mat3f2.m01 + this.m01 * Mat3f2.m11 + this.m02 * Mat3f2.m21;
        float h = this.m00 * Mat3f2.m02 + this.m01 * Mat3f2.m12 + this.m02 * Mat3f2.m22;
        float i = this.m10 * Mat3f2.m00 + this.m11 * Mat3f2.m10 + this.m12 * Mat3f2.m20;
        float j = this.m10 * Mat3f2.m01 + this.m11 * Mat3f2.m11 + this.m12 * Mat3f2.m21;
        float k = this.m10 * Mat3f2.m02 + this.m11 * Mat3f2.m12 + this.m12 * Mat3f2.m22;
        float l = this.m20 * Mat3f2.m00 + this.m21 * Mat3f2.m10 + this.m22 * Mat3f2.m20;
        float m = this.m20 * Mat3f2.m01 + this.m21 * Mat3f2.m11 + this.m22 * Mat3f2.m21;
        float n = this.m20 * Mat3f2.m02 + this.m21 * Mat3f2.m12 + this.m22 * Mat3f2.m22;
        this.m00 = f;
        this.m01 = g;
        this.m02 = h;
        this.m10 = i;
        this.m11 = j;
        this.m12 = k;
        this.m20 = l;
        this.m21 = m;
        this.m22 = n;
    }

    public void mul(QuaternionF quaternion) {
        this.mul(new Mat3f(quaternion));
    }

    public void mul(float f) {
        this.m00 *= f;
        this.m01 *= f;
        this.m02 *= f;
        this.m10 *= f;
        this.m11 *= f;
        this.m12 *= f;
        this.m20 *= f;
        this.m21 *= f;
        this.m22 *= f;
    }

    public void add(Mat3f Mat3f2) {
        this.m00 += Mat3f2.m00;
        this.m01 += Mat3f2.m01;
        this.m02 += Mat3f2.m02;
        this.m10 += Mat3f2.m10;
        this.m11 += Mat3f2.m11;
        this.m12 += Mat3f2.m12;
        this.m20 += Mat3f2.m20;
        this.m21 += Mat3f2.m21;
        this.m22 += Mat3f2.m22;
    }

    public void sub(Mat3f Mat3f2) {
        this.m00 -= Mat3f2.m00;
        this.m01 -= Mat3f2.m01;
        this.m02 -= Mat3f2.m02;
        this.m10 -= Mat3f2.m10;
        this.m11 -= Mat3f2.m11;
        this.m12 -= Mat3f2.m12;
        this.m20 -= Mat3f2.m20;
        this.m21 -= Mat3f2.m21;
        this.m22 -= Mat3f2.m22;
    }

    public float trace() {
        return this.m00 + this.m11 + this.m22;
    }

    public Mat3f copy() {
        return new Mat3f(this);
    }

    public class_4581 convert() {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)9);
        class_4581 mat = new class_4581();
        buffer.put(Mat3f.bufferIndex(0, 0), this.m00);
        buffer.put(Mat3f.bufferIndex(0, 1), this.m01);
        buffer.put(Mat3f.bufferIndex(0, 2), this.m02);
        buffer.put(Mat3f.bufferIndex(1, 0), this.m10);
        buffer.put(Mat3f.bufferIndex(1, 1), this.m11);
        buffer.put(Mat3f.bufferIndex(1, 2), this.m12);
        buffer.put(Mat3f.bufferIndex(2, 0), this.m20);
        buffer.put(Mat3f.bufferIndex(2, 1), this.m21);
        buffer.put(Mat3f.bufferIndex(2, 2), this.m22);
        mat.method_35261(buffer);
        return mat;
    }

    public static Mat3f from(class_4581 mat3f) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)9);
        mat3f.method_35266(buffer);
        Mat3f mat = new Mat3f();
        mat.load(buffer);
        return mat;
    }
}

