/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.obj;

import de.javagl.obj.FloatTuple;
import de.javagl.obj.FloatTuples;
import java.io.IOException;
import java.util.Queue;
import java.util.StringTokenizer;

class Utils {
    static FloatTuple readFloatTuple(StringTokenizer st) throws IOException {
        float x = Utils.parseFloat(st.nextToken());
        if (st.hasMoreTokens()) {
            float y = Utils.parseFloat(st.nextToken());
            if (st.hasMoreTokens()) {
                float z = Utils.parseFloat(st.nextToken());
                if (st.hasMoreTokens()) {
                    float w = Utils.parseFloat(st.nextToken());
                    return FloatTuples.create(x, y, z, w);
                }
                return FloatTuples.create(x, y, z);
            }
            return FloatTuples.create(x, y);
        }
        return FloatTuples.create(x);
    }

    static float parseFloat(String s) throws IOException {
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
    }

    private static boolean isFloat(String s) {
        if (s == null) {
            return false;
        }
        try {
            Float.parseFloat(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    static Float[] parseFloats(Queue<String> tokens, int max) {
        Float[] result = new Float[max];
        for (int i = 0; i < max; ++i) {
            String token = tokens.poll();
            if (!Utils.isFloat(token)) continue;
            float value = Float.parseFloat(token);
            result[i] = Float.valueOf(value);
        }
        return result;
    }

    static boolean parseBoolean(String s) {
        if ("true".equalsIgnoreCase(s)) {
            return true;
        }
        return "on".equalsIgnoreCase(s);
    }

    static int parseInt(String s) throws IOException {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
    }

    static FloatTuple createRgbTuple(Float r, Float g, Float b) {
        if (r == null) {
            return null;
        }
        float fr = r.floatValue();
        float fg = r.floatValue();
        float fb = r.floatValue();
        if (g != null) {
            fg = g.floatValue();
        }
        if (b != null) {
            fb = b.floatValue();
        }
        return FloatTuples.create(fr, fg, fb);
    }

    static FloatTuple createUvwTuple(Float u, Float v, Float w, float defaultValue) {
        if (u == null) {
            return null;
        }
        float fu = u.floatValue();
        float fv = v == null ? defaultValue : v.floatValue();
        float fw = w == null ? defaultValue : w.floatValue();
        return FloatTuples.create(fu, fv, fw);
    }

    private Utils() {
    }
}

