/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix;

import java.lang.management.ManagementFactory;
import java.util.concurrent.ExecutorService;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_3218;
import net.minecraft.class_3898;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.modernfix.command.ModernFixCommands;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.resources.ReloadExecutor;
import org.embeddedt.modernfix.util.ClassInfoManager;

public class ModernFix {
    public static final Logger LOGGER = LogManager.getLogger((String)"ModernFix");
    public static final String MODID = "modernfix";
    public static String NAME = "ModernFix";
    public static ModernFix INSTANCE;
    public static boolean runningFirstInjection;
    private static ExecutorService resourceReloadService;

    public static ExecutorService resourceReloadExecutor() {
        return resourceReloadService;
    }

    public ModernFix() {
        INSTANCE = this;
        if (ModernFixMixinPlugin.instance.isOptionEnabled("feature.snapshot_easter_egg.NameChange") && !class_155.method_16673().isStable()) {
            NAME = "PreemptiveFix";
        }
        ModernFixPlatformHooks.INSTANCE.onServerCommandRegister(ModernFixCommands::register);
    }

    public void onServerStarted() {
        if (ModernFixPlatformHooks.INSTANCE.isDedicatedServer()) {
            float gameStartTime = (float)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0f;
            if (ModernFixMixinPlugin.instance.isOptionEnabled("feature.measure_time.ServerLoad")) {
                LOGGER.warn("Dedicated server took " + gameStartTime + " seconds to load");
            }
            ModernFixPlatformHooks.INSTANCE.onLaunchComplete();
        }
        ClassInfoManager.clear();
    }

    public void onServerDead(MinecraftServer server) {
        try {
            for (class_3218 level : server.method_3738()) {
                class_3898 chunkMap = level.method_14178().field_17254;
                chunkMap.field_17213.clear();
                chunkMap.field_17220.clear();
                chunkMap.field_18807.clear();
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("Couldn't clear chunk data", (Throwable)e);
        }
    }

    static {
        runningFirstInjection = false;
        resourceReloadService = null;
        resourceReloadService = ModernFixMixinPlugin.instance.isOptionEnabled("perf.dedicated_reload_executor.ReloadExecutor") ? ReloadExecutor.createCustomResourceReloadExecutor() : class_156.method_18349();
    }
}

