/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.faster_texture_loading;

import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_1011;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1079;
import net.minecraft.class_2960;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.apache.commons.io.IOUtils;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1059.class}, priority=600)
@ClientOnlyMixin
public abstract class TextureAtlasMixin {
    private Map<class_2960, Pair<class_3298, class_1011>> loadedImages = new ConcurrentHashMap<class_2960, Pair<class_3298, class_1011>>();
    private boolean usingFasterLoad;
    private Collection<class_1058.class_4727> storedResults;

    @Shadow
    protected abstract class_2960 method_4603(class_2960 var1);

    @Shadow
    protected abstract Collection<class_1058.class_4727> method_18164(class_3300 var1, Set<class_2960> var2);

    @Inject(method={"getBasicSpriteInfos"}, at={@At(value="HEAD")})
    private void loadImages(class_3300 manager, Set<class_2960> imageLocations, CallbackInfoReturnable<Collection<class_1058.class_4727>> cir) {
        this.usingFasterLoad = ModernFixPlatformHooks.INSTANCE.isLoadingNormally();
    }

    @Redirect(method={"getBasicSpriteInfos"}, at=@At(value="INVOKE", target="Ljava/util/Set;iterator()Ljava/util/Iterator;", ordinal=0))
    private Iterator<?> skipIteration(Set<?> instance, class_3300 manager, Set<class_2960> imageLocations) {
        if (!this.usingFasterLoad) {
            return instance.iterator();
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        ConcurrentLinkedQueue<class_1058.class_4727> results = new ConcurrentLinkedQueue<class_1058.class_4727>();
        for (class_2960 location : imageLocations) {
            if (class_1047.method_4539().equals((Object)location)) continue;
            futures.add(CompletableFuture.runAsync(() -> {
                InputStream stream = null;
                try {
                    class_2960 fileLocation = this.method_4603(location);
                    Optional resourceOpt = manager.method_14486(fileLocation);
                    if (!resourceOpt.isPresent()) {
                        ModernFix.LOGGER.error("Using missing texture, unable to load {}", (Object)location);
                        return;
                    }
                    class_3298 resource = (class_3298)resourceOpt.get();
                    stream = resource.method_14482();
                    class_1011 image = class_1011.method_4309((InputStream)stream);
                    class_1079 animData = resource.method_14481().method_43041((class_3270)class_1079.field_5337).orElse(class_1079.field_21768);
                    Pair dimensions = animData.method_24141(image.method_4307(), image.method_4323());
                    this.loadedImages.put(location, (Pair<class_3298, class_1011>)Pair.of((Object)resource, (Object)image));
                    results.add(new class_1058.class_4727(location, ((Integer)dimensions.getFirst()).intValue(), ((Integer)dimensions.getSecond()).intValue(), animData));
                    stream.close();
                    stream = null;
                }
                catch (IOException e) {
                    ModernFix.LOGGER.error("Using missing texture, unable to load {} : {}", (Object)location, (Object)e);
                }
                catch (RuntimeException e) {
                    ModernFix.LOGGER.error("Unable to parse metadata from {} : {}", (Object)location, (Object)e);
                }
                if (stream != null) {
                    IOUtils.closeQuietly(stream);
                }
            }, ModernFix.resourceReloadExecutor()));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        this.storedResults = results;
        return Collections.emptyIterator();
    }

    @Inject(method={"getBasicSpriteInfos"}, at={@At(value="RETURN")})
    private void injectFastSprites(class_3300 resourceManager, Set<class_2960> spriteLocations, CallbackInfoReturnable<Collection<class_1058.class_4727>> cir) {
        if (this.usingFasterLoad) {
            ((Collection)cir.getReturnValue()).addAll(this.storedResults);
        }
    }

    @Inject(method={"prepareToStitch"}, at={@At(value="HEAD")})
    private void initMap(CallbackInfoReturnable<class_1059.class_4007> cir) {
        this.loadedImages = new ConcurrentHashMap<class_2960, Pair<class_3298, class_1011>>();
    }

    @Inject(method={"prepareToStitch"}, at={@At(value="RETURN")})
    private void clearLoadedImages(CallbackInfoReturnable<class_1059.class_4007> cir) {
        this.loadedImages = Collections.emptyMap();
        this.storedResults = null;
    }

    @Inject(method={"load(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite$Info;IIIII)Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/TextureAtlas;getResourceLocation(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/resources/ResourceLocation;")}, cancellable=true)
    private void loadFromExisting(class_3300 resourceManager, class_1058.class_4727 spriteInfo, int storageX, int storageY, int mipLevel, int x, int y, CallbackInfoReturnable<class_1058> cir) {
        if (!this.usingFasterLoad) {
            return;
        }
        Pair<class_3298, class_1011> pair = this.loadedImages.get(spriteInfo.method_24121());
        if (pair == null) {
            ModernFix.LOGGER.error("Texture {} was not loaded in early stage", (Object)spriteInfo.method_24121());
            cir.setReturnValue(null);
        } else {
            class_1058 sprite = null;
            try {
                sprite = ModernFixPlatformHooks.INSTANCE.loadTextureAtlasSprite((class_1059)this, resourceManager, spriteInfo, (class_3298)pair.getFirst(), storageX, storageY, x, y, mipLevel, (class_1011)pair.getSecond());
            }
            catch (IOException | RuntimeException e) {
                ModernFix.LOGGER.error("Error loading texture {}: {}", (Object)spriteInfo.method_24121(), (Object)e);
            }
            cir.setReturnValue(sprite);
        }
    }
}

