/*
 * Decompiled with CFR 0.152.
 */
package com.zake.fishtraps.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.zake.fishtraps.common.block.FishTrapBlock;
import com.zake.fishtraps.common.block.entity.FishTrapBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FishTrapRenderer
implements BlockEntityRenderer<FishTrapBlockEntity> {
    public FishTrapRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FishTrapBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pCombinedLight, int pCombinedOverlay) {
        ItemStack bait = pBlockEntity.inventory.getStackInSlot(0);
        if (bait.isEmpty()) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        BakedModel bakedModel = itemRenderer.getModel(bait, pBlockEntity.getLevel(), null, 0);
        BlockState state = pBlockEntity.getBlockState();
        pPoseStack.pushPose();
        boolean isActive = state.hasProperty((Property)FishTrapBlock.ACTIVE) && (Boolean)state.getValue((Property)FishTrapBlock.ACTIVE) != false;
        long time = pBlockEntity.getLevel().getGameTime();
        if (isActive) {
            double offset = Math.sin((double)((float)time + pPartialTick) / 10.0) * 0.05;
            pPoseStack.translate(0.5, 0.45 + offset, 0.5);
            pPoseStack.scale(0.85f, 0.85f, 0.85f);
            float rotation = ((float)time + pPartialTick) * 2.0f;
            pPoseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        } else {
            pPoseStack.translate(0.58, 0.02, 0.44);
            pPoseStack.scale(0.85f, 0.85f, 0.85f);
            pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            pPoseStack.mulPose(Axis.ZP.rotationDegrees(45.0f));
        }
        itemRenderer.render(bait, ItemDisplayContext.GROUND, false, pPoseStack, pBufferSource, pCombinedLight, pCombinedOverlay, bakedModel);
        pPoseStack.popPose();
    }
}

