/*
 * Decompiled with CFR 0.152.
 */
package com.zake.fishtraps.common.block.entity;

import com.zake.fishtraps.common.block.FishTrapBlock;
import com.zake.fishtraps.common.item.FishBaitItem;
import com.zake.fishtraps.config.CommonConfig;
import com.zake.fishtraps.init.ModBlockEntities;
import com.zake.fishtraps.init.ModBlocks;
import com.zake.fishtraps.init.ModItems;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishTrapBlockEntity
extends BlockEntity {
    public final ItemStackHandler inventory = new ItemStackHandler(46){

        protected void onContentsChanged(int slot) {
            FishTrapBlockEntity.this.setChanged();
            if (FishTrapBlockEntity.this.level != null && !((FishTrapBlockEntity)FishTrapBlockEntity.this).level.isClientSide) {
                FishTrapBlockEntity.this.level.sendBlockUpdated(FishTrapBlockEntity.this.worldPosition, FishTrapBlockEntity.this.getBlockState(), FishTrapBlockEntity.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                return stack.getItem() instanceof FishBaitItem;
            }
            return false;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot == 0 && stack.getItem() instanceof FishBaitItem) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    };
    private final IItemHandler baitHandler = new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 1);
    private final IItemHandler outputHandler = new RangedWrapper((IItemHandlerModifiable)this.inventory, 1, 46);
    private int progress = 0;
    private int maxProgress = 300;
    private final Random random = new Random();

    public FishTrapBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.FISH_TRAP_BE.get(), blockPos, blockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
        tag.putInt("fish_trap.progress", this.progress);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
        this.progress = tag.getInt("fish_trap.progress");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FishTrapBlockEntity pEntity) {
        boolean shouldBeActive;
        if (level.isClientSide()) {
            if (((Boolean)state.getValue((Property)FishTrapBlock.ACTIVE)).booleanValue() && pEntity.hasBait() && pEntity.random.nextInt((Integer)CommonConfig.PARTICLE_CHANCE.get()) == 0) {
                int count = 1 + pEntity.random.nextInt(3);
                for (int i = 0; i < count; ++i) {
                    double ox = (double)pos.getX() + 0.5 + (pEntity.random.nextDouble() - 0.5) * 0.4;
                    double oy = (double)pos.getY() + 0.5 + pEntity.random.nextDouble() * 0.3;
                    double oz = (double)pos.getZ() + 0.5 + (pEntity.random.nextDouble() - 0.5) * 0.4;
                    level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, ox, oy, oz, 0.0, 0.06, 0.0);
                }
            }
            return;
        }
        boolean surrounded = FishTrapBlockEntity.isSurroundedByWater(level, pos);
        boolean hasSpace = pEntity.canInventoryAcceptAnything();
        boolean bl = shouldBeActive = surrounded && hasSpace;
        if ((Boolean)state.getValue((Property)FishTrapBlock.ACTIVE) != shouldBeActive) {
            level.setBlock(pos, (BlockState)state.setValue((Property)FishTrapBlock.ACTIVE, (Comparable)Boolean.valueOf(shouldBeActive)), 3);
        }
        if (!shouldBeActive) {
            return;
        }
        boolean hasBait = pEntity.hasBait();
        if (hasBait && pEntity.random.nextInt((Integer)CommonConfig.AMBIENT_SOUND_CHANCE.get()) == 0) {
            float pitch = 0.7f + pEntity.random.nextFloat() * 0.6f;
            level.playSound(null, pos, SoundEvents.FISH_SWIM, SoundSource.BLOCKS, 0.1f, pitch);
        }
        int baseSpeed = state.is((Block)ModBlocks.DIAMOND_FISH_TRAP.get()) ? (Integer)CommonConfig.DIAMOND_TRAP_SPEED.get() : (state.is((Block)ModBlocks.IRON_FISH_TRAP.get()) ? ((Integer)CommonConfig.IRON_TRAP_SPEED.get()).intValue() : ((Integer)CommonConfig.WOODEN_TRAP_SPEED.get()).intValue());
        pEntity.maxProgress = hasBait ? baseSpeed : baseSpeed * (Integer)CommonConfig.NO_BAIT_PENALTY.get();
        ++pEntity.progress;
        if (pEntity.progress >= pEntity.maxProgress) {
            pEntity.catchFish(level, pos, state, hasBait);
            pEntity.progress = 0;
        }
    }

    private void catchFish(Level level, BlockPos pos, BlockState state, boolean hasBait) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean hasEmptySlot = false;
        for (int i = 1; i < this.inventory.getSlots(); ++i) {
            if (!this.inventory.getStackInSlot(i).isEmpty()) continue;
            hasEmptySlot = true;
            break;
        }
        for (int attempt = 0; attempt < 10; ++attempt) {
            LootParams params;
            ResourceLocation lootTableLocation = this.selectLootTable(state);
            LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTableLocation));
            ObjectArrayList loot = lootTable.getRandomItems(params = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)new ItemStack((ItemLike)Items.FISHING_ROD)).create(LootContextParamSets.FISHING));
            if (loot.isEmpty()) continue;
            ItemStack caughtItem = ((ItemStack)loot.get(0)).copy();
            if (!hasEmptySlot && caughtItem.getMaxStackSize() == 1) continue;
            if (hasBait && caughtItem.is(ItemTags.FISHES)) {
                double chance = state.is((Block)ModBlocks.DIAMOND_FISH_TRAP.get()) ? (Double)CommonConfig.DIAMOND_BONUS_CHANCE.get() : (state.is((Block)ModBlocks.IRON_FISH_TRAP.get()) ? ((Double)CommonConfig.IRON_BONUS_CHANCE.get()).doubleValue() : ((Double)CommonConfig.WOODEN_BONUS_CHANCE.get()).doubleValue());
                if (this.random.nextDouble() < chance) {
                    caughtItem.grow(1);
                }
            }
            if (this.internalInsert(caughtItem)) {
                if (hasBait) {
                    this.damageBait(serverLevel, pos, caughtItem.getCount());
                }
                return;
            }
            if (hasEmptySlot) break;
        }
    }

    private void damageBait(ServerLevel serverLevel, BlockPos pos, int amount) {
        ItemStack bait = this.inventory.getStackInSlot(0);
        if (bait.getItem() instanceof FishBaitItem) {
            int newDamage = bait.getDamageValue() + amount;
            if (newDamage >= bait.getMaxDamage()) {
                ItemStack breakStack = bait.copy();
                serverLevel.playSound(null, pos, SoundEvents.WET_GRASS_BREAK, SoundSource.BLOCKS, 0.2f, 0.8f + serverLevel.getRandom().nextFloat() * 0.4f);
                serverLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, breakStack), (double)pos.getX() + 0.5, (double)pos.getY() + 0.45, (double)pos.getZ() + 0.5, 40, 0.15, 0.15, 0.15, 0.15);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.BUBBLE_POP, (double)pos.getX() + 0.5, (double)pos.getY() + 0.45, (double)pos.getZ() + 0.5, 20, 0.1, 0.1, 0.1, 0.05);
                this.inventory.setStackInSlot(0, ItemStack.EMPTY);
            } else {
                bait.setDamageValue(newDamage);
            }
        }
    }

    private ResourceLocation selectLootTable(BlockState state) {
        int treasure;
        int junk;
        int fish;
        if (state.is((Block)ModBlocks.DIAMOND_FISH_TRAP.get())) {
            fish = (Integer)CommonConfig.DIAMOND_FISH_WEIGHT.get();
            junk = (Integer)CommonConfig.DIAMOND_JUNK_WEIGHT.get();
            treasure = (Integer)CommonConfig.DIAMOND_TREASURE_WEIGHT.get();
        } else if (state.is((Block)ModBlocks.IRON_FISH_TRAP.get())) {
            fish = (Integer)CommonConfig.IRON_FISH_WEIGHT.get();
            junk = (Integer)CommonConfig.IRON_JUNK_WEIGHT.get();
            treasure = (Integer)CommonConfig.IRON_TREASURE_WEIGHT.get();
        } else {
            fish = (Integer)CommonConfig.WOODEN_FISH_WEIGHT.get();
            junk = (Integer)CommonConfig.WOODEN_JUNK_WEIGHT.get();
            treasure = (Integer)CommonConfig.WOODEN_TREASURE_WEIGHT.get();
        }
        int totalWeight = fish + junk + treasure;
        if (totalWeight <= 0) {
            return ResourceLocation.withDefaultNamespace((String)"gameplay/fishing/fish");
        }
        int roll = this.random.nextInt(totalWeight);
        if (roll < fish) {
            return ResourceLocation.withDefaultNamespace((String)"gameplay/fishing/fish");
        }
        if (roll < fish + junk) {
            return ResourceLocation.withDefaultNamespace((String)"gameplay/fishing/junk");
        }
        return ResourceLocation.withDefaultNamespace((String)"gameplay/fishing/treasure");
    }

    private boolean internalInsert(ItemStack stack) {
        for (int i = 1; i < this.inventory.getSlots(); ++i) {
            ItemStack existing = this.inventory.getStackInSlot(i);
            if (existing.isEmpty()) {
                this.inventory.setStackInSlot(i, stack.copy());
                return true;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)stack)) continue;
            int space = existing.getMaxStackSize() - existing.getCount();
            if (space >= stack.getCount()) {
                existing.grow(stack.getCount());
                return true;
            }
            if (space <= 0) continue;
            existing.grow(space);
            stack.shrink(space);
        }
        return false;
    }

    public boolean hasBait() {
        return this.inventory.getStackInSlot(0).getItem() == ModItems.FISH_BAIT.get();
    }

    public boolean canInventoryAcceptAnything() {
        for (int i = 1; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (!stack.isEmpty() && stack.getCount() >= stack.getMaxStackSize()) continue;
            return true;
        }
        return false;
    }

    public static boolean isSurroundedByWater(Level level, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            FluidState fluidState = level.getFluidState(pos.relative(direction));
            if (fluidState.is(FluidTags.WATER)) continue;
            return false;
        }
        return true;
    }

    public IItemHandler getItemHandler(@Nullable Direction side) {
        if (side == null) {
            return this.inventory;
        }
        if (side == Direction.DOWN) {
            return this.outputHandler;
        }
        return this.baitHandler;
    }
}

