/*
 * Decompiled with CFR 0.152.
 */
package com.zake.fishtraps.common.menu;

import com.zake.fishtraps.common.block.entity.FishTrapBlockEntity;
import com.zake.fishtraps.common.item.FishBaitItem;
import com.zake.fishtraps.init.ModBlocks;
import com.zake.fishtraps.init.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class FishTrapMenu
extends AbstractContainerMenu {
    private final FishTrapBlockEntity blockEntity;
    private final ContainerLevelAccess levelAccess;

    public FishTrapMenu(int containerId, Inventory inv, RegistryFriendlyByteBuf extraData) {
        this(containerId, inv, (FishTrapBlockEntity)inv.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public FishTrapMenu(int containerId, Inventory inv, FishTrapBlockEntity entity) {
        super((MenuType)ModMenuTypes.FISH_TRAP_MENU.get(), containerId);
        int col;
        int row;
        this.blockEntity = entity;
        this.levelAccess = ContainerLevelAccess.create((Level)entity.getLevel(), (BlockPos)entity.getBlockPos());
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)entity.inventory, 0, 8, 118));
        for (row = 0; row < 5; ++row) {
            for (col = 0; col < 9; ++col) {
                int index = 1 + col + row * 9;
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)entity.inventory, index, 8 + col * 18, 17 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)inv, col + row * 9 + 9, 8 + col * 18, 142 + row * 18));
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            this.addSlot(new Slot((Container)inv, col2, 8 + col2 * 18, 200));
        }
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 46) {
                if (!this.moveItemStackTo(itemstack1, 46, 82, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (itemstack1.getItem() instanceof FishBaitItem) {
                if (!this.moveItemStackTo(itemstack1, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return FishTrapMenu.stillValid((ContainerLevelAccess)this.levelAccess, (Player)player, (Block)((Block)ModBlocks.WOODEN_FISH_TRAP.get())) || FishTrapMenu.stillValid((ContainerLevelAccess)this.levelAccess, (Player)player, (Block)((Block)ModBlocks.IRON_FISH_TRAP.get())) || FishTrapMenu.stillValid((ContainerLevelAccess)this.levelAccess, (Player)player, (Block)((Block)ModBlocks.DIAMOND_FISH_TRAP.get()));
    }
}

