/*
 * Decompiled with CFR 0.152.
 */
package com.zake.fishtraps.config;

import net.neoforged.neoforge.common.ModConfigSpec;

public class CommonConfig {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.IntValue WOODEN_TRAP_SPEED;
    public static final ModConfigSpec.IntValue IRON_TRAP_SPEED;
    public static final ModConfigSpec.IntValue DIAMOND_TRAP_SPEED;
    public static final ModConfigSpec.IntValue WOODEN_FISH_WEIGHT;
    public static final ModConfigSpec.IntValue WOODEN_JUNK_WEIGHT;
    public static final ModConfigSpec.IntValue WOODEN_TREASURE_WEIGHT;
    public static final ModConfigSpec.IntValue IRON_FISH_WEIGHT;
    public static final ModConfigSpec.IntValue IRON_JUNK_WEIGHT;
    public static final ModConfigSpec.IntValue IRON_TREASURE_WEIGHT;
    public static final ModConfigSpec.IntValue DIAMOND_FISH_WEIGHT;
    public static final ModConfigSpec.IntValue DIAMOND_JUNK_WEIGHT;
    public static final ModConfigSpec.IntValue DIAMOND_TREASURE_WEIGHT;
    public static final ModConfigSpec.DoubleValue WOODEN_BONUS_CHANCE;
    public static final ModConfigSpec.DoubleValue IRON_BONUS_CHANCE;
    public static final ModConfigSpec.DoubleValue DIAMOND_BONUS_CHANCE;
    public static final ModConfigSpec.IntValue BAIT_DURABILITY;
    public static final ModConfigSpec.IntValue AMBIENT_SOUND_CHANCE;
    public static final ModConfigSpec.IntValue PARTICLE_CHANCE;
    public static final ModConfigSpec.IntValue NO_BAIT_PENALTY;

    static {
        BUILDER.push("Traps Speed Settings");
        WOODEN_TRAP_SPEED = BUILDER.defineInRange("wooden_trap_speed", 600, 20, 20000);
        IRON_TRAP_SPEED = BUILDER.defineInRange("iron_trap_speed", 400, 20, 20000);
        DIAMOND_TRAP_SPEED = BUILDER.defineInRange("diamond_trap_speed", 200, 20, 20000);
        BUILDER.pop();
        BUILDER.push("Wooden Trap Probabilities");
        WOODEN_FISH_WEIGHT = BUILDER.defineInRange("wooden_fish_weight", 60, 0, 100);
        WOODEN_JUNK_WEIGHT = BUILDER.defineInRange("wooden_junk_weight", 35, 0, 100);
        WOODEN_TREASURE_WEIGHT = BUILDER.defineInRange("wooden_treasure_weight", 5, 0, 100);
        BUILDER.pop();
        BUILDER.push("Iron Trap Probabilities");
        IRON_FISH_WEIGHT = BUILDER.defineInRange("iron_fish_weight", 55, 0, 100);
        IRON_JUNK_WEIGHT = BUILDER.defineInRange("iron_junk_weight", 30, 0, 100);
        IRON_TREASURE_WEIGHT = BUILDER.defineInRange("iron_treasure_weight", 15, 0, 100);
        BUILDER.pop();
        BUILDER.push("Diamond Trap Probabilities");
        DIAMOND_FISH_WEIGHT = BUILDER.defineInRange("diamond_fish_weight", 50, 0, 100);
        DIAMOND_JUNK_WEIGHT = BUILDER.defineInRange("diamond_junk_weight", 20, 0, 100);
        DIAMOND_TREASURE_WEIGHT = BUILDER.defineInRange("diamond_treasure_weight", 30, 0, 100);
        BUILDER.pop();
        BUILDER.push("Bonus Luck Settings");
        WOODEN_BONUS_CHANCE = BUILDER.defineInRange("wooden_bonus_chance", 0.2, 0.0, 1.0);
        IRON_BONUS_CHANCE = BUILDER.defineInRange("iron_bonus_chance", 0.4, 0.0, 1.0);
        DIAMOND_BONUS_CHANCE = BUILDER.defineInRange("diamond_bonus_chance", 0.6, 0.0, 1.0);
        BUILDER.pop();
        BUILDER.push("General Settings");
        BAIT_DURABILITY = BUILDER.defineInRange("bait_durability", 64, 1, 1000);
        AMBIENT_SOUND_CHANCE = BUILDER.defineInRange("ambient_sound_chance", 2000, 100, 10000);
        PARTICLE_CHANCE = BUILDER.defineInRange("particle_chance", 80, 1, 500);
        NO_BAIT_PENALTY = BUILDER.defineInRange("no_bait_penalty", 8, 1, 100);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

